import { Injectable, Inject } from '@angular/core';
import { HttpClient } from '@angular/common/http';
import { ResponseModel } from '../../models/api-models/api-models';
import { GeneralFilter } from '../../models/general/generalFilter.model';

@Injectable({
  providedIn: 'root'
})
export class EmployeeSettlementService {
  private url = '';
  constructor(private http: HttpClient, @Inject('BASE_URL') baseUrl: string) {
    this.url = baseUrl + 'EmployeeSettlement';
  }

  getEmployeeSettlement(filter: any) {
    const urlValue: string = this.url + '/GetEmployeeSettlement';
    return this.http.post<ResponseModel>(urlValue, filter).map(
      (response) => {
        const res = new ResponseModel();
        res.data = response['data'];
        res.message = response['message'];
        res.status = response['status'];
        return res;
      }
    );
  }
  GetATMSettlementImages(routeHistoryId: number) {
    const urlValue: string = this.url + "/GetATMSettlementImages";
    return this.http.post<ResponseModel>(urlValue, routeHistoryId).map((response) => {
      return response;
    });
  }
  GetExpensesSettlementImages(routeHistoryId: number) {
    const urlValue: string = this.url + "/GetExpensesSettlementImages";
    return this.http.post<ResponseModel>(urlValue, routeHistoryId).map((response) => {
      return response;
    });
  }
  settleRoute(routeHistory: any) {
    const urlValue: string = this.url + "/SettleRoute";
    return this.http.post<ResponseModel>(urlValue, routeHistory).map(
      response => {
        return response;
      });
  }
  getExpenses(settlement: any) {
    const urlValue: string = this.url + '/GetExpenses';
    return this.http.post<ResponseModel>(urlValue, settlement).map(
      (response) => {
        const res = new ResponseModel();
        res.data = response['data'];
        res.message = response['message'];
        res.status = response['status'];
        return res;
      }
    );
  }
}
