import { Injectable, Inject } from '@angular/core';
import { HttpClient, HttpHeaders } from '@angular/common/http';
import { CoreSession } from '../../../core/core.session';
import { ResponseModel } from '../../models/api-models/api-models';
import { GeneralFilter } from '../../models/general/generalFilter.model';
import { EmployeeKeyFilter } from '../../models/employee-keys/employee-keys';

@Injectable({
    providedIn: 'root'
})
export class ExchangeRouteCustomerService {
    private url = '';
    private httpOptions;

    constructor(
        private http: HttpClient,
        private coreSession: CoreSession,
        @Inject('BASE_URL') baseUrl: string
    ) {
        this.url = baseUrl + 'ExchangeRouteCustomer';
        this.httpOptions = {
            headers: new HttpHeaders({
                'Content-Type': 'application/json',
                Authorization: 'my-auth-token'
            })
        };
    }
    exchangeRouteCustomer(exchangeData: any) {
        const urlValue: string = this.url + "/ExchangeRouteCustomer";
        return this.http.post<ResponseModel>(urlValue, exchangeData)
            .map(response => {
                const res = new ResponseModel();
                res.data = response["data"];
                res.message = response["message"];
                res.status = response["status"];
                return res;
            });
    }
    GetCustomerOutletForExchange(territoryId: number, routeId: number, hidInactiveCustomer: boolean) {

        let routeFilter = {
            territoryId: territoryId,
            routeId: routeId,
            hidInactiveCustomer: hidInactiveCustomer
        }
        const urlValue = this.url + '/GetCustomerOutletForExchange'
        return this.http.post<ResponseModel>(urlValue, routeFilter).map(response => {
            const res = new ResponseModel();
            res.data = response['data'];
            res.message = response['message'];
            res.status = response['status'];
            return res;
        });
    }
}
