import { Injectable, Inject } from '@angular/core';
import { HttpClient, HttpHeaders } from '@angular/common/http';
import { CoreSession } from '../../../core/core.session';
import { ResponseModel } from '../../models/api-models/api-models';

@Injectable({
    providedIn: 'root'
})
export class JourneyActionsService {
    private url = '';
    private httpOptions;

    constructor(
        private http: HttpClient,
        private coreSession: CoreSession,
        @Inject('BASE_URL') baseUrl: string
    ) {
        this.url = baseUrl + 'JourneyActions';
        this.httpOptions = {
            headers: new HttpHeaders({
                'Content-Type': 'application/json',
                Authorization: 'my-auth-token'
            })
        };
    }
    getJourneyActions() {
        const urlValue = this.url + '/GetJourneyActions';
        return this.http.post<ResponseModel>(urlValue, "").map(response => {
            return response.data;
        });
    }
    UpdateJourneyActions(journeyActions: any) {
        const urlValue = this.url + '/UpdateJourneyActions';
        return this.http.post<ResponseModel>(urlValue, journeyActions).map(response => {
            return response;
        });
    }
}
