import { Injectable, Inject } from '@angular/core';
import { HttpClient, HttpHeaders } from '@angular/common/http';
import { ResponseModel } from '../../../shared/models/api-models/api-models';
import { CoreSession } from '../../../core/core.session';

@Injectable({
  providedIn: 'root'
})
export class MoveTransactionsService {
  
  private url = "";
  httpOptions;
  constructor(
    private http: HttpClient,
    @Inject("BASE_URL") baseUrl: string,
    private coreSession: CoreSession
    ) {
      this.url = baseUrl + "MoveTransactions";
      this.httpOptions = {
        headers: new HttpHeaders({
          "Content-Type": "application/json",
        }),
      };
     }

  getEmployeeTransactions(filter: any) {
    const urlValue: string = this.url + '/GetEmployeeTransactions';
    return this.http.post<ResponseModel>(urlValue, filter).map(
      (response) => {
        const res = new ResponseModel();
        res.data = response['data'];
        res.message = response['message'];
        res.status = response['status'];
        return res;
      }
    );
  }

  moveTransactions(transList: any[], fromEmployeeId: number, toEmployeeId: number) {
    let invoices = {
      transaction: transList,
      fromEmployeeId: fromEmployeeId,
      toEmployeeId: toEmployeeId,
    }
    const urlValue: string = this.url + '/moveTransactions';
    return this.http.post<ResponseModel>(urlValue, invoices).map(response => {
      return response;
    });
  }
}
