import { Injectable, Inject } from '@angular/core';
import { HttpClient, HttpHeaders } from '@angular/common/http';
import { ResponseModel } from '../../models/api-models/api-models';

@Injectable({
  providedIn: 'root'
})
export class RetrieveRouteCustomerService {
  private url = '';
  private httpOptions;

  constructor(private http: HttpClient, @Inject('BASE_URL') baseUrl: string) {
    this.url = baseUrl + 'RetrieveRouteCustomer/';
  }

  GetCustomerOutletForRetrieve(routeId: number) {
    let routeFilter = {
      routeId: routeId
    }
    const urlValue = this.url + 'GetCustomerOutletForRetrieve'
    return this.http.post<ResponseModel>(urlValue, routeFilter).map(response => {
      const res = new ResponseModel();
      res.data = response['data'];
      res.message = response['message'];
      res.status = response['status'];
      return res;
    });
  }

  retrieveRouteCustomer(RetrieveData: any) {
    const urlValue: string = this.url + "RetrieveRouteCustomer";
    return this.http.post<ResponseModel>(urlValue, RetrieveData)
      .map(response => {
        const res = new ResponseModel();
        res.data = response["data"];
        res.message = response["message"];
        res.status = response["status"];
        return res;
      });
  }
}
