import { Injectable, Inject } from '@angular/core';
import { HttpClient } from '@angular/common/http';
import { ResponseModel } from '../../models/api-models/api-models';

@Injectable({
  providedIn: 'root'
})
export class RouteEndorsementService {
  private url = '';
  constructor(private http: HttpClient, @Inject('BASE_URL') baseUrl: string) {
    this.url = baseUrl + 'RouteEndorsement';
  }

  getNonEndorsedRoutes(filter: any) {
    const urlValue: string = this.url + '/GetNonEndorsedRoutes';
    return this.http.post<ResponseModel>(urlValue, filter).map(
      (response) => {
        const res = new ResponseModel();
        res.data = response['data'];
        res.message = response['message'];
        res.status = response['status'];
        return res;
      }
    );
  }
  endorseRoute(endorsementObj: any) {
    const urlValue: string = this.url + '/EndorseRoute';
    return this.http.post<ResponseModel>(urlValue, endorsementObj).map(
      (response) => {
        const result = new ResponseModel();
        result.data = response['data'];
        result.message = response['message'];
        result.status = response['status'];
        return result;
      }
    );
  }
  getEndorsementDashboards(routeHistoryId: number) {
    const urlValue: string = this.url + "/GetEndorsementDashboards";
    return this.http.post<ResponseModel>(urlValue, routeHistoryId).map(response => {
      return response;
    });
  }
}
