import { Injectable, Inject } from "@angular/core";
import { HttpClient, HttpHeaders } from "@angular/common/http";
import { CoreSession } from "../../../core/core.session";
import { ResponseModel } from "../../models/api-models/api-models";
import { OrderListFilter, warehouseFilter } from "../../models/shared-table/custom-list.interface";
import { WarehouseTransactionOperation } from "../../models/enums/warehouse-transaction-operation.enum";
import { WarehouseTransaction } from "../../models/warehouse-transactions/warehouse-transaction.model";
import { WarehouseTransactionStatus } from "../../models/enums/warehouse-transaction-status.enum";
import * as FileSaver from 'file-saver';

@Injectable({
  providedIn: 'root'
})

export class OrderAssignedService {
  private url = "";
  httpOptions;
  constructor(
    private http: HttpClient,
    @Inject("BASE_URL") baseUrl: string,
    private coreSession: CoreSession
  ) {
    this.url = baseUrl + "OrderAssigned";
    this.httpOptions = {
      headers: new HttpHeaders({
        "Content-Type": "application/json",
      }),
    };
  }

  exportOrderToExcel(filter: OrderListFilter) {
    const urlValue = this.url + "/ExportOrderToExcel";
    return this.http.post(urlValue, filter , { responseType: 'blob' }).map((res) => {
      var blob = new Blob([res], { type: 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet' });
      FileSaver.saveAs(blob, filter.tableName + ".xlsx");
      return blob;
    });
  }

  getOrders(filter: OrderListFilter) {
    const urlValue = this.url + "/GetOrders";
    return this.http.post<ResponseModel>(urlValue, filter).map(response => {
      return response;
    });
  }

  getOrder(filter: OrderListFilter) {
    const urlValue = this.url + "/GetOrder";
    return this.http.post<ResponseModel>(urlValue, filter).map(response => {
      return response;
    });
  }

  removeOrderAssignment(orders: any) {
    const urlValue = this.url + "/RemoveAssignment";
    return this.http.post<ResponseModel>(urlValue, orders).map(response => {
      return response;
    });
  }

  rescheduleDeliveryDate(orders: any) {
    const urlValue = this.url + "/RescheduleDeliveredDate";
    return this.http.post<ResponseModel>(urlValue, orders).map(response => {
      return response;
    });
  }

  invoiceOrder(order: any) {
    const urlValue = this.url + "/InvoiceOrder";
    return this.http.post<ResponseModel>(urlValue, order).map(response => {
      return response;
    });
  }

  deliveryOrder(order: any) {
    const urlValue = this.url + "/DeliveryOrder";
    return this.http.post<ResponseModel>(urlValue, order).map(response => {
      return response;
    });
  }

  sendLoadRequest(ordersList: any) {
    const urlValue = this.url + "/SendLoadRequestAction";
    return this.http.post<ResponseModel>(urlValue, ordersList).map(response => {
      return response;
    });
  }


  processRetunOrder(order: any) {
    const urlValue = this.url + "/ProcessRetunOrder";
    return this.http.post<ResponseModel>(urlValue, order).map(response => {
      return response;
    });
  }

  isOrderValidToRemoveAssignment(orders: any) {
    const urlValue = this.url + "/IsOrderValidToRemoveAssignment";
    return this.http.post<ResponseModel>(urlValue, orders).map(response => {
      return response;
    });
  }

  isOrderValidToInvoice(order: any) {
    const urlValue = this.url + "/IsOrderValidToBill";
    return this.http.post<ResponseModel>(urlValue, order).map(response => {
      return response;
    });
  }

  checkOrderStatusBeforeAnyAction(order: any) {
    const urlValue = this.url + "/CheckOrderStatusBeforeAnyAction";
    return this.http.post<ResponseModel>(urlValue, order).map(response => {
      return response;
    });
  }

  checkResellableItems(orderItemsPackStatuses: any[]) {
    const urlValue: string = this.url + "/CheckResellableItems";
    return this.http
      .post<ResponseModel>(urlValue, orderItemsPackStatuses)
      .map((response) => {
        const result = new ResponseModel();
        result.data = response["data"];
        result.message = response["message"];
        result.status = response["status"];
        return result;
      });
  }

  checkForPostedCustomerTransactions(order: any) {
    const urlValue = this.url + "/CheckForPostedCustomerTransactions";
    return this.http.post<ResponseModel>(urlValue, order).map(response => {
      return response;
    });
  }
  isDelivaryOrdersUploaded(orders: any) {
    const urlValue = this.url + "/IsDelivaryOrdersUploaded";
    return this.http.post<ResponseModel>(urlValue, orders).map(response => {
      return response;
    });
  }
}
