import { Injectable, Inject } from "@angular/core";
import { HttpClient, HttpHeaders } from "@angular/common/http";
import { CoreSession } from "../../../core/core.session";
import { ResponseModel } from "../../models/api-models/api-models";
import { OrderListFilter, warehouseFilter } from "../../models/shared-table/custom-list.interface";
import { WarehouseTransactionOperation } from "../../models/enums/warehouse-transaction-operation.enum";
import { WarehouseTransaction } from "../../models/warehouse-transactions/warehouse-transaction.model";
import { WarehouseTransactionStatus } from "../../models/enums/warehouse-transaction-status.enum";

@Injectable({
    providedIn: 'root'
})

export class OrderInvoicedService {
    private url = "";
    httpOptions;
    constructor(
        private http: HttpClient,
        @Inject("BASE_URL") baseUrl: string,
        private coreSession: CoreSession
    ) {
        this.url = baseUrl + "OrderInvoiced";
        this.httpOptions = {
            headers: new HttpHeaders({
                "Content-Type": "application/json",
            }),
        };
    }
    getOrders(filter: OrderListFilter) {
        const urlValue = this.url + "/GetOrders";
        return this.http.post<ResponseModel>(urlValue, filter).map(response => {
            return response;
        });
    }

    getInvoicedOrderForView(filter: OrderListFilter) {
        const urlValue = this.url + "/GetOrderForView";
        return this.http.post<ResponseModel>(urlValue, filter).map(response => {
            return response;
        });
    }

    voidOrderInvoice(order: any) {
        const urlValue = this.url + "/VoidOrder";
        return this.http.post<ResponseModel>(urlValue, order).map(response => {
            return response;
        });
    }

    assignOrderToDriver(orders: any) {
        const urlValue = this.url + "/AssignOrder";
        return this.http.post<ResponseModel>(urlValue, orders).map(response => {
            return response;
        });
    }
    deliveryOrder(orders: any) {
        const urlValue = this.url + "/DeliveryOrder";
        return this.http.post<ResponseModel>(urlValue, orders).map(response => {
            return response;
        });
    }

    isOrderValidToInvoice(order: any) {
        const urlValue = this.url + "/IsOrderValidToBill";
        return this.http.post<ResponseModel>(urlValue, order).map(response => {
            return response;
        });
    }

    reassignOrders(order: any) {
        const urlValue = this.url + "/ReassignOrders";
        return this.http.post<ResponseModel>(urlValue, order).map(response => {
            return response;
        });
    }

    checkOrderStatusBeforeAnyAction(order: any) {
        const urlValue = this.url + "/CheckOrderStatusBeforeAnyAction";
        return this.http.post<ResponseModel>(urlValue, order).map(response => {
            return response;
        });
    }

    isValidToVoidInvoice(order: any) {
        const urlValue = this.url + "/IsValidToVoidOrderBill";
        return this.http.post<ResponseModel>(urlValue, order).map(response => {
            return response;
        });
    }
}
