import { Injectable, Inject } from "@angular/core";
import { HttpClient, HttpHeaders } from "@angular/common/http";
import { CoreSession } from "../../../core/core.session";
import { ResponseModel } from "../../models/api-models/api-models";
import { OrderStatus } from "../../models/enums/order-status.enum";
import { OrderListFilter } from "../../models/shared-table/custom-list.interface";

@Injectable({
    providedIn: 'root'
})

export class OrderPendingService {
    private url = "";
    httpOptions;
    constructor(
        private http: HttpClient,
        @Inject("BASE_URL") baseUrl: string,
        private coreSession: CoreSession
    ) {
        this.url = baseUrl + "OrderPending";
        this.httpOptions = {
            headers: new HttpHeaders({
                "Content-Type": "application/json",
            }),
        };
    }

    getOrders(filter: OrderListFilter) {
        const urlValue = this.url + "/GetOrders";
        return this.http.post<ResponseModel>(urlValue, filter).map(response => {
            return response;
        });
    }

    getOrder(filter: OrderListFilter) {
        const urlValue = this.url + "/GetOrder";
        return this.http.post<ResponseModel>(urlValue, filter).map(response => {
            return response;
        });
    }

    isValidOperation(order: any) {
        const urlValue = this.url + "/IsValidOperation";
        return this.http.post<ResponseModel>(urlValue, order).map(response => {
            return response;
        });
    }

    insertOrder(order: any) {
        const urlValue = this.url + "/InsertOrder";
        return this.http.post<ResponseModel>(urlValue, order).map(response => {
            return response;
        });
    }

    updateOrder(order: any) {
        const urlValue = this.url + "/UpdateOrder";
        return this.http.post<ResponseModel>(urlValue, order).map(response => {
            return response;
        });
    }
  SelectWarehouseOrder(order: any) {
      const urlValue = this.url + "/SelectWarehouseOrder";
      return this.http.post<ResponseModel>(urlValue, order).map(response => {
          return response;
      });
  }


    deleteOrder(order: any) {
        const urlValue = this.url + "/DeleteOrder";
        return this.http.post<ResponseModel>(urlValue, order).map(response => {
            return response;
        });
    }

    deleteMultiOrders(ordersList: any) {
        const urlValue = this.url + "/DeleteMultiOrders";
        return this.http.post<ResponseModel>(urlValue, ordersList).map(response => {
            return response;
        });
    }

    approveSelectedOrders(ordersList: any) {
        const urlValue = this.url + "/ApproveSelectedOrders";
        return this.http.post<ResponseModel>(urlValue, ordersList).map(response => {
            return response;
        });
    }
    checkForPostedCustomerTransactions(order: any) {
        const urlValue = this.url + "/CheckForPostedCustomerTransactions";
        return this.http.post<ResponseModel>(urlValue, order).map(response => {
            return response;
        });
    }

    isValidToApprove(orders:any[] ) {
        const urlValue: string = this.url + '/IsValidToConfirm';
        return this.http.post<ResponseModel>(urlValue, orders).map(response => {
          return response;
        });
    }

}
