import { Injectable, Inject } from "@angular/core";
import { HttpClient, HttpHeaders } from "@angular/common/http";
import { CoreSession } from "../../../core/core.session";
import { ResponseModel } from "../../models/api-models/api-models";
import { warehouseFilter } from "../../models/shared-table/custom-list.interface";
import { WarehouseTransactionOperation } from "../../models/enums/warehouse-transaction-operation.enum";
import { WarehouseTransaction } from "../../models/warehouse-transactions/warehouse-transaction.model";
import { WarehouseTransactionStatus } from "../../models/enums/warehouse-transaction-status.enum";

@Injectable({
    providedIn: 'root'
})

export class OrderRecurringService {
    private url = "";
    httpOptions;
    constructor(
        private http: HttpClient,
        @Inject("BASE_URL") baseUrl: string,
        private coreSession: CoreSession
    ) {
        this.url = baseUrl + "OrderRecurring";
        this.httpOptions = {
            headers: new HttpHeaders({
                "Content-Type": "application/json",
            }),
        };
    }

    // editRecurringOrder(recurringOrder: any) {
    //     const urlValue = this.url + "/UpdateRecurringOrder";
    //     return this.http.post<ResponseModel>(urlValue, recurringOrder).map(response => {
    //         return response;
    //     });
    // }
    // getRecurringChangedReason() {
    //     const urlValue = this.url + "/GetRecurringChangedReason";
    //     return this.http.post<ResponseModel>(urlValue, null).map(response => {
    //         return response;
    //     });
    // }

    getRecurringOrderDetails(recurringObj: any) {
        const urlValue = this.url + "/GetRecurringOrderDetails";
        return this.http.post<ResponseModel>(urlValue, recurringObj).map(response => {
            return response;
        });
    }

    getRecurringOrdersList() {
        const urlValue = this.url + "/GetRecurringOrdersList";
        return this.http.post<ResponseModel>(urlValue, null).map(response => {
            return response;
        });
    }
    checkOrderStatusBeforeAnyAction(order: any) {
        const urlValue = this.url + "/CheckOrderStatusBeforeAnyAction";
        return this.http.post<ResponseModel>(urlValue, order).map(response => {
            return response;
        });
    }
}
