import { Injectable, Inject } from "@angular/core";
import { HttpClient, HttpHeaders } from "@angular/common/http";
import { CoreSession } from "../../../core/core.session";
import { ResponseModel } from "../../models/api-models/api-models";
import { OrderListFilter, warehouseFilter } from "../../models/shared-table/custom-list.interface";
import { WarehouseTransactionOperation } from "../../models/enums/warehouse-transaction-operation.enum";
import { WarehouseTransaction } from "../../models/warehouse-transactions/warehouse-transaction.model";
import { WarehouseTransactionStatus } from "../../models/enums/warehouse-transaction-status.enum";

@Injectable({
    providedIn: 'root'
})

export class OrderRejectedService {
    private url = "";
    httpOptions;
    constructor(
        private http: HttpClient,
        @Inject("BASE_URL") baseUrl: string,
        private coreSession: CoreSession
    ) {
        this.url = baseUrl + "OrderRejected";
        this.httpOptions = {
            headers: new HttpHeaders({
                "Content-Type": "application/json",
            }),
        };
    }
    getOrders(filter: OrderListFilter) {
        const urlValue = this.url + "/GetOrders";
        return this.http.post<ResponseModel>(urlValue, filter).map(response => {
            return response;
        });
    }

    getOrder(filter: OrderListFilter) {
        const urlValue = this.url + "/GetOrder";
        return this.http.post<ResponseModel>(urlValue, filter).map(response => {
            return response;
        });
    }
    approveOrder(order: any) {
        const urlValue = this.url + "/ApproveOrder";
        return this.http.post<ResponseModel>(urlValue, order).map(response => {
            return response;
        });
    }

    disapproveOrder(order: any) {
        const urlValue = this.url + "/DisapproveOrder";
        return this.http.post<ResponseModel>(urlValue, order).map(response => {
            return response;
        });
    }
}
