import { Injectable, Inject } from "@angular/core";
import { HttpClient, HttpHeaders } from "@angular/common/http";
import { CoreSession } from "../../../core/core.session";
import { ResponseModel } from "../../models/api-models/api-models";
import { OrderListFilter, warehouseFilter } from "../../models/shared-table/custom-list.interface";


@Injectable({
    providedIn: 'root'
})

export class OrderApprovedService {
    private url = "";
    httpOptions;
    constructor(
        private http: HttpClient,
        @Inject("BASE_URL") baseUrl: string,
        private coreSession: CoreSession
    ) {
        this.url = baseUrl + "OrderApproved";
        this.httpOptions = {
            headers: new HttpHeaders({
                "Content-Type": "application/json",
            }),
        };
    }
    getOrders(filter: OrderListFilter) {
        const urlValue = this.url + "/GetOrders";
        return this.http.post<ResponseModel>(urlValue, filter).map(response => {
            return response;
        });
    }
    getOrder(filter: OrderListFilter) {
        const urlValue = this.url + "/GetOrder";
        return this.http.post<ResponseModel>(urlValue, filter).map(response => {
            return response;
        });
    }

    updateOrder(order: any) {
        const urlValue = this.url + "/UpdateOrder";
        return this.http.post<ResponseModel>(urlValue, order).map(response => {
            return response;
        });
    }

    disapproveOrder(order: any) {
        const urlValue = this.url + "/DisapproveOrder";
        return this.http.post<ResponseModel>(urlValue, order).map(response => {
            return response;
        });
    }

    invoiceOrder(order: any) {
        const urlValue = this.url + "/InvoiceOrder";
        return this.http.post<ResponseModel>(urlValue, order).map(response => {
            return response;
        });
    }

    deliveryOrder(order: any) {
        const urlValue = this.url + "/DeliveryOrder";
        return this.http.post<ResponseModel>(urlValue, order).map(response => {
            return response;
        });
    }

    assignOrderToDriver(order: any) {
        const urlValue = this.url + "/AssignOrder";
        return this.http.post<ResponseModel>(urlValue, order).map(response => {
            return response;
        });
    }
    isValidOperation(order: any) {
        const urlValue = this.url + "/IsValidOperation";
        return this.http.post<ResponseModel>(urlValue, order).map(response => {
            return response;
        });
    }
    isOrderValidToInvoice(order: any) {
        const urlValue = this.url + "/IsOrderValidToBill";
        return this.http.post<ResponseModel>(urlValue, order).map(response => {
            return response;
        });
    }
    checkForPostedCustomerTransactions(order: any) {
        const urlValue = this.url + "/CheckForPostedCustomerTransactions";
        return this.http.post<ResponseModel>(urlValue, order).map(response => {
            return response;
        });
    }
    checkOrderStatusBeforeAnyAction(order: any) {
        const urlValue = this.url + "/CheckOrderStatusBeforeAnyAction";
        return this.http.post<ResponseModel>(urlValue, order).map(response => {
            return response;
        });
    }
}
