import { Injectable, Inject } from "@angular/core";
import { HttpClient, HttpHeaders } from "@angular/common/http";
import { CoreSession } from "../../../core/core.session";
import { ResponseModel } from "../../models/api-models/api-models";
import { OrderListFilter } from "../../models/shared-table/custom-list.interface";


@Injectable({
    providedIn: 'root'
})
export class OrderCancelPreparedService {

    private url = "";
    httpOptions;
    constructor(
        private http: HttpClient,
        @Inject("BASE_URL") baseUrl: string,
        private coreSession: CoreSession
    ) {
        this.url = baseUrl + "OrderCancelPrepared";
        this.httpOptions = {
            headers: new HttpHeaders({
                "Content-Type": "application/json",
            }),
        };
    }

    cancelOrders(order: any) {
        const urlValue = this.url + "/CancelOrders";
        return this.http.post<ResponseModel>(urlValue, order).map(response => {
            return response;
        });
    }
    getOrders(filter: OrderListFilter) {
        const urlValue = this.url + "/GetOrders";
        return this.http.post<ResponseModel>(urlValue, filter).map(response => {
            return response;
        });
    }
    getOrder(filter: OrderListFilter) {
        const urlValue = this.url + "/GetOrder";
        return this.http.post<ResponseModel>(urlValue, filter).map(response => {
            return response;
        });
    }
}
