import { Injectable, Inject } from "@angular/core";
import { HttpClient, HttpHeaders } from "@angular/common/http";
import { CoreSession } from "../../../core/core.session";
import { ResponseModel } from "../../models/api-models/api-models";
import { OrderListFilter } from "../../models/shared-table/custom-list.interface";

@Injectable({
  providedIn: 'root'
})
export class OrderCancelledService {
  private url = "";
    httpOptions;
    constructor(
        private http: HttpClient,
        @Inject("BASE_URL") baseUrl: string,
        private coreSession: CoreSession
    ) {
        this.url = baseUrl + "OrderCancelled";
        this.httpOptions = {
            headers: new HttpHeaders({
                "Content-Type": "application/json",
            }),
        };
    }

    getOrders(filter: OrderListFilter) {
      const urlValue = this.url + "/GetOrders";
      return this.http.post<ResponseModel>(urlValue, filter).map(response => {
          return response;
      });
  }

  getOrder(filter: OrderListFilter) {
      const urlValue = this.url + "/GetOrder";
      return this.http.post<ResponseModel>(urlValue, filter).map(response => {
          return response;
      });
  }
}
