import { Injectable, Inject } from "@angular/core";
import { HttpClient, HttpHeaders } from "@angular/common/http";
import { CoreSession } from "../../../core/core.session";
import { ResponseModel } from "../../models/api-models/api-models";
import { OrderListFilter } from "../../models/shared-table/custom-list.interface";


@Injectable({
    providedIn: 'root'
})
export class OrderPreparedService {

    private url = "";
    httpOptions;
    constructor(
        private http: HttpClient,
        @Inject("BASE_URL") baseUrl: string,
        private coreSession: CoreSession
    ) {
        this.url = baseUrl + "OrderPrepared";
        this.httpOptions = {
            headers: new HttpHeaders({
                "Content-Type": "application/json",
            }),
        };
    }
    getOrders(filter: OrderListFilter) {
        const urlValue = this.url + "/GetOrders";
        return this.http.post<ResponseModel>(urlValue, filter).map(response => {
            return response;
        });
    }
    invoiceOrder(order: any) {
        const urlValue = this.url + "/InvoiceOrder";
        return this.http.post<ResponseModel>(urlValue, order).map(response => {
            return response;
        });
    }
    getOrder(filter: OrderListFilter) {
        const urlValue = this.url + "/GetOrder";
        return this.http.post<ResponseModel>(urlValue, filter).map(response => {
            return response;
        });
    }
    invoiceOrders(orders: any) {
        const urlValue = this.url + "/InvoiceOrders";
        return this.http.post<ResponseModel>(urlValue, orders).map(response => {
            return response;
        });
    }
}
