import { HttpClient } from '@angular/common/http';
import { Inject, Injectable } from '@angular/core';
import { TranslateService } from '@ngx-translate/core';
import { Observable } from 'rxjs';
import { CoreSession } from '../../core/core.session';
import { ConstantMessages } from '../models/constants/constant-message';
import { RowOperation } from '../models/enums/shared-table-operation.enum';
import { SessionDataProvider } from '../../core/session-data-provider.service';
import { ConstantConfigurations } from '../models/constants/constant-configuration';


@Injectable({
  providedIn: "root"
})
export class PdfCreatorService {
  private url = "";
  constructor(private http: HttpClient,
    private coreSession: CoreSession,
    private sessionData: SessionDataProvider,
    private translateService: TranslateService,
    @Inject("BASE_URL") baseUrl: string) {
    this.url = baseUrl + "PdfCreator";
  }
  public printBlob(blob: Blob): void {
    const blobUrl = URL.createObjectURL(blob);

    const printWindow = window.open(blobUrl, '_blank');
    printWindow.onload = () => {
      printWindow.print();
      printWindow.onafterprint = () => {
        printWindow.close();
        URL.revokeObjectURL(blobUrl);
      };
    };
  }

ExportReport(transaction: any, isDownLoad?, isInvoiceOrderMode?, isDeliveryReport?, isMultiTransactions?) {
    let siteSymbol = this.sessionData.getConfigurationValue(ConstantConfigurations.SiteSymbol);
    if (siteSymbol.toLowerCase() == 'omnitrade' && isDeliveryReport) {
      if (isMultiTransactions)
        this.ExportAllOmnitradeReport(transaction, isDownLoad);
      else
        this.ExportOmnitradeReport(transaction, isDownLoad);


    }
    else {
      const urlValue = this.url + "/ExportReport";
      if (transaction.isReprintReport) {
        this.coreSession.ModalLoading.Show();
      }
      this.http.post(urlValue, transaction, { responseType: "blob" }).map(res => {
        var blob = new Blob([res], { type: "application/pdf" });
        return blob;
      }).subscribe(
        success => {
          const fileURL = URL.createObjectURL(success);
          if (isDownLoad == RowOperation.downLoad) {
            const downloadLink = document.createElement("a");
            downloadLink.href = fileURL;
            downloadLink.download = transaction.transactionId;
            downloadLink.click();
          } else {
            if (isInvoiceOrderMode) {
              const newFileURL = fileURL + "#toolbar=0"; // This removes the ToolBar 'DownLoad Button' in the PDF.
              window.open(newFileURL, "_blank");
            } else {
              const newFileURL = fileURL;
              window.open(newFileURL, "_blank");
            }
          }
          if (transaction.isReprintReport) {
            this.coreSession.ModalLoading.Hide();
          }
        },
        err => {
          if (transaction.isReprintReport) {
            this.coreSession.ModalLoading.Hide();
          }
        }
      );
    }
  }
  ExportOmnitradeReport(transaction: any, isDownLoad?) {
    var blob;
    const urlValue = this.url + "/ExportOmnitradeReport";
    if (transaction.isReprintReport) {
      this.coreSession.ModalLoading.Show();
    }
    this.http.post(urlValue, transaction, { responseType: "blob" }).map(res => {
      blob = new Blob([res], { type: "application/pdf" });
      return blob;
    }).subscribe(
      success => {
        this.printBlob(blob);
        const fileURL = URL.createObjectURL(success);
        if (isDownLoad == RowOperation.downLoad) {
          const downloadLink = document.createElement("a");
          downloadLink.href = fileURL;
          downloadLink.download = transaction.transactionId;
          downloadLink.click();
        } else {
          // const newFileURL = fileURL + "#toolbar=0"; // This removes the ToolBar 'DownLoad Button' in the PDF.
          // window.open(newFileURL, "_blank");
        }
        if (transaction.isReprintReport) {
          this.coreSession.ModalLoading.Hide();
        }
      },
      err => {
        if (transaction.isReprintReport) {
          this.coreSession.ModalLoading.Hide();
        }
      }
    );
  }
  ExportAllOmnitradeReport(transaction: any, isDownLoad?) {
    var blob;
    const urlValue = this.url + "/ExportAllOmnitradeReport";
    if (transaction.isReprintReport) {
      this.coreSession.ModalLoading.Show();
    }
    this.http.post(urlValue, transaction, { responseType: "blob" }).map(res => {
      blob = new Blob([res], { type: "application/pdf" });
      return blob;
    }).subscribe(
      success => {
        this.printBlob(blob);

        const fileURL = URL.createObjectURL(success);
        if (isDownLoad == RowOperation.downLoad) {
          const downloadLink = document.createElement("a");
          downloadLink.href = fileURL;
          downloadLink.download = transaction.transactionId;
          downloadLink.click();

        } else {
          // const newFileURL = fileURL + "#toolbar=0"; // This removes the ToolBar 'DownLoad Button' in the PDF.
          // window.open(newFileURL, "_blank");
        }

        if (transaction.isReprintReport) {
          this.coreSession.ModalLoading.Hide();
        }
      },
      err => {
        if (transaction.isReprintReport) {
          this.coreSession.ModalLoading.Hide();
        }
      }
    );
  }

  generatePdf(): Observable<Blob> {

    const urlValue = this.url + "/generate";
    return this.http.get(urlValue, { responseType: 'blob' })






  }

}
