import { Injectable, Inject } from '@angular/core';
import { HttpClient, HttpHeaders } from '@angular/common/http';
import { CoreSession } from '../../../core/core.session';
import { ResponseModel } from '../../models/api-models/api-models';


@Injectable({
  providedIn: 'root'
})
export class ApprovalCycleLevelService {

  httpOptions;
  private url = '';
  constructor(private http: HttpClient, @Inject('BASE_URL') baseUrl: string,
    private coreSession: CoreSession) {
    this.url = baseUrl + 'ApprovalCycleLevel/';
    this.httpOptions = {
      headers: new HttpHeaders({
        "Content-Type": "application/json",
        Authorization: "my-auth-token"
      })
    };
  }

  saveOperationLevels(operationDataList: any[]) {
    const urlValue = this.url + "InsertOperationLevels";
    return this.http.post<ResponseModel>(urlValue, operationDataList)
      .map(response => {
        return response;
      })
  }
  getOperationLevelsData() {
    const urlValue: string = this.url + 'getOperationLevelsData';
    return this.http.post<ResponseModel>(urlValue, this.httpOptions).map(response => {
      ;
      return response;
    });
  }
}
