import { Injectable, Inject } from '@angular/core';
import { HttpClient, HttpHeaders } from '@angular/common/http';
import { CoreSession } from '../../../core/core.session';
import { ResponseModel } from '../../models/api-models/api-models';
import { GeneralFilter } from '../../models/general/generalFilter.model';
import { ConfigurationLevels } from '../../models/enums/configuration-levels.enum';

@Injectable({
    providedIn: 'root'
})
export class ConfigurationService {
    private url = '';
    private httpOptions;

    constructor(
        private http: HttpClient,
        private coreSession: CoreSession,
        @Inject('BASE_URL') baseUrl: string
    ) {
        this.url = baseUrl + 'Configuration';
        this.httpOptions = {
            headers: new HttpHeaders({
                'Content-Type': 'application/json',
                Authorization: 'my-auth-token'
            })
        };
    }
    getAllConfigurations(level: number, configFilter: string) {
        const urlValue: string = this.url + '/GetAllConfigurations';
        let configuration = {
            levelId: level,
            filter: configFilter
        };
        return this.http
            .post<ResponseModel>(urlValue, configuration)
            .map(response => {
                return response.data;
            })
    }

    saveLevelConfigurations(changedConfigurations: any[], level: ConfigurationLevels) {
        const urlValue = this.url + '/InsertLevelConfigurations';
        let configLevelData = {
            changedConfigurations: changedConfigurations,
            configLevel: level
        }
        return this.http
            .post<ResponseModel>(urlValue, configLevelData)
            .map(
                (response) => {
                    return response;
                }
            );
    }

    updateConfigurations(changedConfigurations: any[]) {
        const urlValue = this.url + '/UpdateSystemConfigurations';
        return this.http
            .post<ResponseModel>(urlValue, changedConfigurations)
            .map(
                (response) => {
                    return response;
                }
            );
    }
}
