
import { Injectable, Inject } from '@angular/core';
import { HttpClient, HttpHeaders } from '@angular/common/http';
import { CoreSession } from '../../../core/core.session';
import { ResponseModel } from '../../models/api-models/api-models';
import { GeneralFilter } from '../../models/general/generalFilter.model';
import { ConfigurationLevels } from '../../models/enums/configuration-levels.enum';
import { AESEncryptionService } from '../EncrDecrService.service';

@Injectable({
    providedIn: 'root'
})
export class SecurityGroupManagementService {
    private url = '';
    private httpOptions;

    constructor(
        private http: HttpClient,
        private coreSession: CoreSession,
        private secService: AESEncryptionService,
        @Inject('BASE_URL') baseUrl: string
    ) {
        this.url = baseUrl + 'SecurityGroupManagement/';
        this.httpOptions = {
            headers: new HttpHeaders({
                'Content-Type': 'application/json',
                Authorization: 'my-auth-token'
            })
        };
    }

    getAllAvailableSecurityGroups() {
        const urlValue = this.url + "GetAvailableSecurityGroupsList";
        return this.http.post<ResponseModel>(urlValue, this.httpOptions).map(response => {
            let employeeId = this.coreSession.CurrentOperator.employeeId;
            let decryptedData = this.secService.decryptData(response.data, employeeId);
            let decryptedDataModel = JSON.parse(decryptedData);
            response.data = decryptedDataModel;
            return response;
        });
    }

    saveSecurityGroup(securityGroupMenusAndId: any) {
        const urlValue: string = this.url + 'InsertSecurityGroup';
        return this.http.post(urlValue, JSON.stringify(securityGroupMenusAndId), this.httpOptions).map(
            (response) => {
                const result = new ResponseModel();
                result.data = response['data'];
                result.message = response['message'];
                result.status = response['status'];
                return result;
            }
        );
    }
    deleteSecurityGroup(securityGroupId: any) {
        const urlValue = this.url + 'DeleteSecurityGroup';
        return this.http.post<ResponseModel>(urlValue, securityGroupId)
            .map(response => {
                return response;
            });
    }
}


