import { Injectable, Inject } from '@angular/core';
import { HttpClient, HttpHeaders } from '@angular/common/http';
import { CoreSession } from '../../../core/core.session';
import { ResponseModel } from '../../models/api-models/api-models';


@Injectable({
  providedIn: 'root'
})
export class ServiceManagementService {

  httpOptions;
  private url = '';
  constructor(private http: HttpClient, @Inject('BASE_URL') baseUrl: string,
    private coreSession: CoreSession) {
    this.url = baseUrl + 'Services/';
    this.httpOptions = {
      headers: new HttpHeaders({
        "Content-Type": "application/json",
        Authorization: "my-auth-token"
      })
    };
  }

  getAllWebServices() {
    const urlValue: string = this.url + 'GetAllServices';
    return this.http.get<ResponseModel>(urlValue).map(response => {
      return response.data;
    });
  }
  updateServices(changedServices: any) {
    const urlValue = this.url + 'UpdateServices';
    return this.http
      .post<ResponseModel>(urlValue, changedServices)
      .map(
        (response) => {
          return response;
        }
      );
  }
}
