import { Injectable, Inject } from '@angular/core';
import { HttpClient, HttpHeaders } from '@angular/common/http';
import { warehouseFilter } from '../../models/shared-table/custom-list.interface';
import { ResponseModel } from '../../models/api-models/api-models';
import { CoreSession } from '../../../core/core.session';
import { WarehouseTransactionStatusModel } from '../../models/warehouse-transactions/warehouse-transaction.model';

@Injectable({
  providedIn: 'root'
})
export class PurchaseOrderService {
  vehicleId: number;
  private url = '';
  private httpOptions;
  public warehouseTransactionStatuses: WarehouseTransactionStatusModel[];
  constructor(
    private http: HttpClient,
    private coreSession: CoreSession,
    @Inject('BASE_URL') baseUrl: string
  ) {
    this.url = baseUrl + 'PurchaseOrder';
    this.httpOptions = {
      headers: new HttpHeaders({
        'Content-Type': 'application/json',
        Authorization: 'my-auth-token'
      })
    };
  }

  GetPurchaseOrders(statusId: number, filter: warehouseFilter) {
    const urlValue: string = this.url + '/GetPurchaseOrders';
    let wHTransaction = {
      wHTransactionStatusId: statusId,
      warehouseFilter: filter
    }
    return this.http.post<ResponseModel>(urlValue, wHTransaction)
      .map(response => {
        const res = new ResponseModel();
        res.data = response['data'];
        res.message = response['message'];
        res.status = response['status'];
        return res;
      });
  }
  getPurchaseOrderData(purchaseOrderId: string) {
    const urlValue: string = this.url + '/GetPurchaseOrderData';
    let purchaseOrder = {
      purchaseOrderId: purchaseOrderId
    }
    return this.http
      .post<ResponseModel>(urlValue, purchaseOrder)
      .map(response => {
        const res = new ResponseModel();
        res.data = response['data'];
        res.message = response['message'];
        res.status = response['status'];
        return res;
      });
  }
  savePurchaseOrder(purchaseOrderObj: any) {
    const urlValue: string = this.url + '/InsertPurchaseOrder';
    // const data = JSON.stringify(warehouseTransaction);
    // return this.http.post(urlValue, warehouseTransaction);
    return this.http
      .post<ResponseModel>(urlValue, purchaseOrderObj)
      .map(response => {
        const res = new ResponseModel();
        res.data = response['data'];
        res.message = response['message'];
        res.status = response['status'];
        return res;
      });
  }

  cancelPurchaseOrder(purchaseOrderId: string) {
    const urlValue: string = this.url + '/CancelPurchaseOrder';

    return this.http
      .post<ResponseModel>(urlValue + "?purchaseOrderId=" + purchaseOrderId, '')
      .map(response => {
        const res = new ResponseModel();
        res.data = response['data'];
        res.message = response['message'];
        res.status = response['status'];
        return res;
      });
  }
}
