import { Injectable } from '@angular/core';
import { Router } from "@angular/router";
import { TranslateService } from "@ngx-translate/core";
import { ShepherdService } from "angular-shepherd";
import { CoreSession } from '../../core/core.session';
import { ConstantStorage } from '../models/constants/constant-stroage';
import { ComponentVisitService } from './trackTour.service';
import { ConstantURLs } from '../models/constants/constant-URL';
import { Subject } from 'rxjs';

@Injectable({
  providedIn: 'root',
})
export class TourService {

  private startTourMainSubject = new Subject<void>();
  private startTourEntrySubject = new Subject<void>();
  private startTourEntryModelSubject = new Subject<void>();

  startTourEntryModel$ = this.startTourEntryModelSubject.asObservable();

  startTourEntry$ = this.startTourEntrySubject.asObservable();

  startTourMain$ = this.startTourMainSubject.asObservable();

  startTourMain() {
    this.startTourMainSubject.next();
  }
  startTourEntry() {
    this.startTourEntrySubject.next();
  }
  startTourEntryModel() {
    this.startTourEntryModelSubject.next();
  }

  imagePath = 'assets/img/close-circle.png';

  private STEPS_BUTTONS = {
    back: {
      classes: 'back-button',
      secondary: true,
      text: 'wwww',
      type: 'back',
    },
    cancel: {
      classes: 'cancel-button',
      secondary: true,
      text: '<img src="assets/img/close-circle.png" alt="Cancel">',
      type: 'cancel',
    },
    next: {
      classes: 'back-button',
      text: 'wwww',
      type: 'next',
      secondary: true,
    },
    definition: {
      classes: 'next-button',
      text: 'Go to definition',
      // action: (tour) => {this.goToDefinition(tour)}
    },
  };

  public defaultStepOptions = {
    classes: 'shepherd-theme-arrows custom-default-class',
    scrollTo: false,
    cancelIcon: {
      enabled: true,
    },
    highlightClass: 'highlight',
  };

  constructor(
    private translateService: TranslateService,
    private shepherdService: ShepherdService,
    private coreSession: CoreSession,
    private componentVisitService: ComponentVisitService,
    private router: Router
  ) { }

  public isTourCompletedForComponent(componentName: string): boolean {
    return this.componentVisitService.isComponentVisited(componentName);
  }

  public isFirstTour(): boolean {
    const firstTourValue = localStorage.getItem(ConstantStorage.FirstTour);
    return firstTourValue === "1";
  }

  generateSteps(
    elementSelectors: string[],
    titles: string[],
    texts: string[],
    isMenu: boolean = false
  ) {
      const steps = [];
      const nextButton = { ...this.STEPS_BUTTONS.next, text: '<i class="fa fa-arrow-right"></i>' };
      const backButton = { ...this.STEPS_BUTTONS.back, text: '<i class="fa fa-arrow-left"></i>' };

      elementSelectors.forEach((selector, index) => {
        const title = this.translateService.instant(titles[index]) || `Step ${index + 1}`;
        const text = this.translateService.instant(texts[index]) || `Content in ${selector} at bottom.`;

        const buttons = isMenu ? [backButton, nextButton] : [backButton, nextButton];

        steps.push({
          attachTo: {
            element: `${selector}`,
            on: 'bottom',
          },
          buttons,
          classes: 'custom-class-name-1 custom-class-name-2',
          id: `step-${index + 1}`,
          title,
          text,
          when: {
            show: () => this.setDirection(),
          },
        });
      });

      return steps;

  }

  private setDirection() {
    const langDir = this.translateService.currentLang === 'ar' ? 'rtl' : 'ltr';
    const modalContent = document.querySelector('.shepherd-content');
    if (modalContent) {
      modalContent.setAttribute('dir', langDir);
      modalContent.querySelectorAll('button').forEach(button => button.setAttribute('dir', langDir));
      modalContent.querySelector('.shepherd-text')?.setAttribute('dir', langDir);
    }
  }

  private goToDefinition(menuName) {
    // Replace with actual logic for handling different menu names
    switch (menuName) {
      case 'Desc_Home_Page':
        this.router.navigate(['/' + ConstantURLs.homeUrl]);
        break;
      case 'Desc_Your_ECHO':
        this.router.navigate(['/' + ConstantURLs.dataDefinitionURL]);
        break;
      case 'Desc_Orders_Management':
        this.router.navigate(['/' + ConstantURLs.orderManagementURL + '/' + ConstantURLs.pendingOrdersURL]);
        break;
      case 'Desc_Reports':
        this.router.navigate(['/' + ConstantURLs.reportURL]);
        break;
      case 'Desc_Dashboards':
        this.router.navigate(['/' + ConstantURLs.dashboardURL]);
        break;
      case 'Desc_Settings':
        this.router.navigate(['/' + ConstantURLs.settingsURL]);
        break;
      case 'Desc_Products':
        this.router.navigate(['/' + ConstantURLs.dataDefinitionURL + '/' + ConstantURLs.productUrl + '/' + ConstantURLs.itemsURL]);
        break;
      case 'Desc_Customers':
        this.router.navigate(['/' + ConstantURLs.dataDefinitionURL + '/' + ConstantURLs.customerURL + '/' + ConstantURLs.customersURL]);
        break;
      case 'Desc_Prices_And_Offers':
        this.router.navigate(['/' + ConstantURLs.dataDefinitionURL + '/' + ConstantURLs.priceAndOfferURL + '/' + ConstantURLs.pricesURL]);
        break;
      case 'Desc_User_Definition':
        this.router.navigate(['/' + ConstantURLs.dataDefinitionURL + '/' + ConstantURLs.staffURL + '/' + ConstantURLs.employeeURL]);
        break;
      case 'Desc_Advance_Settings':
        this.router.navigate(['/' + ConstantURLs.dataDefinitionURL + '/' + ConstantURLs.masterURL]);
        break;
      default:
        this.router.navigate(['/defaultPath']);
        break;
    }
    this.shepherdService.complete();
  }
}
