import { Injectable } from '@angular/core';

@Injectable({
  providedIn: 'root',
})
export class ComponentVisitService {
  private visitedComponents: { [key: string]: boolean } = {};

  markComponentVisited(componentName: string) {
    this.visitedComponents[componentName] = true;
  }

  resetVisitedComponents(){
    this.visitedComponents= {};
  }

  isComponentVisited(componentName: string): boolean {
    return !!this.visitedComponents[componentName];
  }
}
