﻿using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Mvc;
using Newtonsoft.Json;
using Newtonsoft.Json.Serialization;
using Sonic.Web.DAL;
using Sonic.Web.Licensing.Licensing;
using Sonic.Web.Model;
using Sonic.Web.Model.MasterData;
using Sonic.Web.Models;
using Sonic.Web.PL.SystemModels;
using Sonic.Web.Resources;
using Sonic.Web.SecureLibrary;
using Sonic.Web.Service;
using System;
using System.Collections.Generic;
using System.Dynamic;
using System.Reflection;

namespace Sonic.Web.PL.Controllers
{
    [Route("api/[controller]/[action]")]
    [Authorize]
    public class ApprovalCycleLevelController : BaseController
    {
        private readonly IRequestRepository _requestRepository;
        private readonly EmployeeService _employeeService;
        private readonly ConfigurationService _configurationService;
        private readonly SettingService _settingService;
        public ApprovalCycleLevelController(IRequestRepository requestRepository, ILicensing licensing, IActiveTokens activeToken) : base(requestRepository, licensing, activeToken)
        {
            _requestRepository = requestRepository;
            _employeeService = new EmployeeService(requestRepository);
            _configurationService = new ConfigurationService(requestRepository);
            _settingService = new SettingService(requestRepository);
        }

        #region GET

        [HttpPost]
        [ActionName("getOperationLevelsData")]
        public JsonResult getOperationLevelsData()
        {
            try
            {
                List<ApprovalCycleOperationsModel> approvalCycleOperations = new List<ApprovalCycleOperationsModel>();

                GlobalErrors result = _settingService.GetApprovalCycleOperations(ref approvalCycleOperations);

                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(approvalCycleOperations, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        #endregion
        #region INSERT
        [HttpPost]
        [ActionName("InsertOperationLevels")]
        public JsonResult InsertOperationLevels([FromBody] List<ApprovalCycleOperationsModel> operationDataList)
        {
            try
            {
                var result = _settingService.SaveOperationLevels(operationDataList);

                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(operationDataList, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        #endregion
        #region UPDATE

        #endregion

        #region DELETE

        #endregion

    }
}
