﻿using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Microsoft.AspNetCore.Mvc.Filters;
using Sonic.Web.DAL;
using Sonic.Web.Licensing.Enums;
using Sonic.Web.Licensing.Licensing;
using Sonic.Web.Model;
using Sonic.Web.PL.Helper;
using System;
using System.Linq;
using System.Reflection;
using System.Security.Claims;
using InCube.Security;
using GlobalErrors = Sonic.Web.Model.GlobalErrors;
using Sonic.Web.Service;
using System.Globalization;
using System.Threading;

namespace Sonic.Web.PL.Controllers
{
    [Authorize]
    public class BaseController : Controller
    {
        private readonly IRequestRepository _requestRepository;
        private readonly ILicensing _licensing;
        private static IActiveTokens _activeToken;
        private static SharedMethod _sharedMethod;
        public BaseController(IRequestRepository requestRepository, ILicensing licensing, IActiveTokens activeToken)
        {
            _requestRepository = requestRepository;
            _licensing = licensing;
            _activeToken= activeToken;
            _sharedMethod = new SharedMethod(requestRepository);
        }
        public override void OnActionExecuting(ActionExecutingContext filerContext)
        {
            try
            {
                Thread.CurrentThread.CurrentCulture = new CultureInfo("en-US");
                var operatorModel = this.WorkContext().CurrentOperator;
                _requestRepository.CurrentOperator = operatorModel;
                var languageId = this.Request.Headers["LanguageId"].ToString();
                _requestRepository.SessionId = HttpContext.Session.Id;

                SonicModules module = SonicModules.SonicWeb;
                if (!string.IsNullOrEmpty(languageId))
                {
                    _requestRepository.LanguageId = Int32.Parse(languageId);
                }
               
                if (HttpContext.Session != null && string.IsNullOrEmpty(HttpContext.Session.GetString(SessionsConstants.CurrentSession)))
                {
                    HttpContext.Session.SetString(SessionsConstants.CurrentSession, User.FindFirstValue(ClaimTypes.Sid));
                    _requestRepository.CurrentOperator = operatorModel;
                    _requestRepository.SessionId = HttpContext.Session.Id;
                }

                if (_requestRepository.CurrentOperator.EmployeeId > 0 && (System.Net.NetworkInformation.IPGlobalProperties.GetIPGlobalProperties().DomainName == null || System.Net.NetworkInformation.IPGlobalProperties.GetIPGlobalProperties().DomainName.ToLower() != LocalUtilities.DomainName))
                {
                    string browserName = HttpContext.Request.Headers["User-Agent"].ToString();
                    
                    var list = _licensing.GetActiveSessions(module).Where(a => a.SessionId == User.FindFirstValue(ClaimTypes.Sid).ToString() && a.EmployeeId ==
                    operatorModel.EmployeeId && a.MachineName == Environment.MachineName && a.BrowserName == browserName);

                    if (list == null || list.Count() == 0)
                    {
                        ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, "OnActionExecuting -> ", null, "No ConcurrentSessionList for logged in user", operatorModel.EmployeeId);
                        filerContext.Result = new UnauthorizedResult();
                    }
                }

                string controllerName = filerContext.ActionDescriptor.RouteValues["controller"];
                string actionName = filerContext.ActionDescriptor.RouteValues["action"];
                string webMenuId = string.Empty;
                bool isMenuAvailable = true;
                bool isActionAvailable = true;
                bool isMenuHasActions = false;

                WebMenuActions action = WebMenuActions.None;
                
                webMenuId = GetWebMenuId(controllerName);

                if (string.IsNullOrEmpty(webMenuId) && controllerName.ToLower().Contains("webform"))
                {
                    if (filerContext.ActionArguments.ContainsKey("entryForm"))
                    {
                        webMenuId = ((WebFormModel)filerContext.ActionArguments["entryForm"]).ParentFormWebMenuId;
                    } else if (filerContext.ActionArguments.ContainsKey("filter"))
                    {
                        webMenuId = ((PerformActionProcedureModel)filerContext.ActionArguments["filter"]).WebMenuId;
                        action = ((PerformActionProcedureModel)filerContext.ActionArguments["filter"]).ActionId;
                    }
                }
                if (!string.IsNullOrEmpty(webMenuId))
                {
                    if (webMenuId == "900-001-04" && actionName.ToLower() == ("savelevelconfigurations"))
                    {
                        ConfigurationLevelData actionData = (ConfigurationLevelData)filerContext.ActionArguments["configLevelData"];
                        bool hasAdd = actionData.changedConfigurations.Where(x => x.DataAction == Model.DataActions.Add).Count() > 0;
                        bool hasEdit = actionData.changedConfigurations.Where(x => x.DataAction == Model.DataActions.Edit).Count() > 0;
                        bool hasDelete = actionData.changedConfigurations.Where(x => x.DataAction == Model.DataActions.Delete).Count() > 0;

                        if (hasAdd)
                        {
                            isActionAvailable = CheckIsActionAllowed(webMenuId, WebMenuActions.Add.GetHashCode());
                            if (!isActionAvailable)
                            {
                                filerContext.Result = new UnauthorizedResult();
                            }
                        }
                        if (hasEdit)
                        {
                            isActionAvailable = CheckIsActionAllowed(webMenuId, WebMenuActions.Edit.GetHashCode());
                            if (!isActionAvailable)
                            {
                                filerContext.Result = new UnauthorizedResult();
                            }
                        }
                        if (hasDelete)
                        {

                            isActionAvailable = CheckIsActionAllowed(webMenuId, WebMenuActions.Delete.GetHashCode());
                            if (!isActionAvailable)
                            {
                                filerContext.Result = new UnauthorizedResult();
                            }
                        }
                    }
                    else
                    {
                        isMenuHasActions = CheckIsMenuHasActions(webMenuId);
                        if (action == WebMenuActions.None && isMenuHasActions)
                        {
                            action = GetActionValue(actionName);
                        }
                        if (action != WebMenuActions.None)
                        {
                            isMenuAvailable = CheckIsActionAllowed(webMenuId, -1);
                            if (isMenuAvailable)
                            {
                                isActionAvailable = CheckIsActionAllowed(webMenuId, action.GetHashCode());
                            }

                            if (!isMenuAvailable || !isActionAvailable)
                            {
                                filerContext.Result = new UnauthorizedResult();
                            }
                        }
                        else
                        {
                            if (!isMenuHasActions)
                            {
                                isMenuAvailable = CheckIsActionAllowed(webMenuId, -1);
                                if (!isMenuAvailable)
                                {
                                    filerContext.Result = new UnauthorizedResult();
                                }
                            }
                        }
                    }
                }

                //CORS Origin
                //string host = String.Format(@"{0}://{1}", this.Request.Scheme.ToString(), this.Request.Host.ToString());
                //host = host.ToLower();
                if (!string.IsNullOrEmpty(this.Request.Headers["Origin"].ToString()))
                {
                    var originFromHeader = this.Request.Headers["Origin"].ToString().Replace("'", "").Replace("\"", "").ToLower();
                    if (LocalUtilities.AllowedOriginsList != null
                        && LocalUtilities.AllowedOriginsList.Count > 0
                        && LocalUtilities.AllowedOriginsList.FindAll(x => x.Equals("*")).Count <= 0
                        && !string.IsNullOrEmpty(originFromHeader)
                        && !LocalUtilities.AllowedOriginsList.Contains(originFromHeader))
                    {
                        filerContext.Result = new UnauthorizedResult();
                    }
                }
                else if (this.Request.Method.ToString().Equals("POST"))
                {
                    filerContext.Result = new UnauthorizedResult();
                }

                var keyFound = filerContext.ActionArguments.Keys.ToList().Where(a => a != null && (a.ToLower().Contains("origin"))).FirstOrDefault();
                if (keyFound != null && !string.IsNullOrEmpty(keyFound))
                {
                    var originFromBody = filerContext.ActionArguments[keyFound].ToString().ToLower();
                    if (LocalUtilities.AllowedOriginsList != null
                        && LocalUtilities.AllowedOriginsList.Count > 0
                        && (!String.IsNullOrEmpty(originFromBody)
                        && !LocalUtilities.AllowedOriginsList.Contains(originFromBody)))
                    {
                        filerContext.Result = new UnauthorizedResult();
                    }
                }

                string token = this.Request.Headers["Authorization"].ToString();
                if (string.IsNullOrEmpty(token) || _activeToken.GetTokens().ToList().Where(x => x == token).Count() <= 0)
                {
                    ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, "OnActionExecuting -> ", null, $"No ActiveToken for logged in user {token}", operatorModel.OperatorId);
                    filerContext.Result = new UnauthorizedResult();
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
        }

        string GetWebMenuId(string controllerName)
       {
            string webMenuId = string.Empty;
            switch (controllerName.ToLower())
            {
                #region DATA DEFINITION

                #region STAFF
                case "employee"://employee
                    webMenuId = "100-001-01";//
                    break;
                case "territory":
                    webMenuId = "100-001-02";//
                    break;
                case "employeeitemlist":
                    webMenuId = "100-001-03";//
                    break;
                case "employeechannel":
                    webMenuId = "100-001-04";//
                    break;
                case "employeedevice":
                    webMenuId = "100-001-05";//
                    break;
                case "chattingassignment":
                    webMenuId = "100-001-06";//
                    break;
                case "movetransactions":
                    webMenuId = "100-001-09";//
                    break;
                #endregion

                #region MACHINE
                case "machinetemplate"://machine
                    webMenuId = "100-002-01";//
                    break;
                case "machinebox":
                    webMenuId = "100-002-02";//
                    break;
                case "coffeetemplate":
                    webMenuId = "100-002-03";//
                    break;
                #endregion

                #region CUSTOMER
                case "customer"://customer
                    webMenuId = "100-003-01";//
                    break;
                case "customertemplate":
                    webMenuId = "100-003-02";//
                    break;
                case "customercreditrelease":
                    webMenuId = "100-003-03";//
                    break;
                case "customeritemlist":
                    webMenuId = "100-003-04";//
                    break;
                case "customerpointbalance":
                    webMenuId = "100-003-05";//
                    break;
                case "customerooslist":
                    webMenuId = "100-003-06";//
                    break;
                case "customericash":
                    webMenuId = "100-003-07";//
                    break;
                case "customerblockedoperation":
                    webMenuId = "100-003-08";//
                    break;
                case "customersalesrestriction":
                    webMenuId = "100-003-09";//
                    break;
                case "customerhierarchy":
                    webMenuId = "100-003-10";//
                    break;
                case "customeritemblacklist":
                    webMenuId = "100-003-11";//
                    break;
                case "mustsellitems":
                    webMenuId = "100-003-12";//
                    break;
                case "customercontainerslimit":
                    webMenuId = "100-003-13";//
                    break;
                case "salesdistributionchannel":
                    webMenuId = "100-003-15";
                    break;
                #endregion

                #region PRODUCTS
                case "item"://products
                    webMenuId = "100-004-01";//
                    break;
                case "division":
                    webMenuId = "100-004-02";//
                    break;
                case "itemcategory":
                    webMenuId = "100-004-03";//
                    break;
                case "packgroup":
                    webMenuId = "100-004-04";//
                    break;
                case "salesitemrestriction":
                    webMenuId = "100-004-05";//
                    break;
                case "gs1template":
                    webMenuId = "100-004-06";//
                    break;
                case "brand":
                    webMenuId = "100-004-07";//
                    break;
                case "itemgroup":
                    webMenuId = "100-004-08";//
                    break;
                #endregion

                #region DYNAMIC FORMS
                case "customersurvey"://dynamic forms
                    webMenuId = "100-005-01";
                    break;
                case "customerappsurvey":
                    webMenuId = "100-005-03";
                    break;
                case "employeesurvey":
                    webMenuId = "100-005-04";
                    break;
                case "listofvalue":
                    webMenuId = "100-005-05";
                    break;
                #endregion

                #region PRICES & OFFERS
                case "price"://price & offers
                    webMenuId = "100-006-01";//
                    break;
                case "discount":
                    webMenuId = "100-006-02";//
                    break;
                case "promotion":
                    webMenuId = "100-006-03";//
                    break;
                case "bundle":
                    webMenuId = "100-006-04";
                    break;
                case "promotiongroups":
                    webMenuId = "100-006-05";
                    break;
                case "loyaltyprograms":
                    webMenuId = "100-006-06";
                    break;
                case "contractedfoc":
                    webMenuId = "100-006-07";
                    break;
                #endregion

                #region WAREHOUSE & VEHICLES
                case "warehouse"://warehouse & vehicles
                    webMenuId = "100-007-01";//
                    break;
                case "vehicle":
                    webMenuId = "100-007-02";//
                    break;
                #endregion

                #region MOBILE CUSTOMIZATIONS
                case "goldenminute"://golden minute control
                    webMenuId = "100-008-01";
                    break;
                #endregion

                #region DISPLAY UNIT
                case "displayunitlist"://display unit
                    webMenuId = "100-009-01";
                    break;
                case "displayunittemplate":
                    webMenuId = "100-009-02";
                    break;
                case "displayunitsurvey":
                    webMenuId = "100-009-03";
                    break;
                case "displayunitsurveystockcounting":
                    webMenuId = "100-009-04";
                    break;
                case "displayunitstockcountingresult":
                    webMenuId = "100-009-05";
                    break; 
                #endregion

                #endregion

                #region VEHICLE OPERATIONS
                case "loadrequest":
                    webMenuId = "700-001";
                    break;
                case "offloadrequest":
                    webMenuId = "700-002";
                    break;
                #endregion

                #region WAREHOUSE OPERATIONS
                case "inputvouchers":
                    webMenuId = "200-001";
                    break;
                case "outputvouchers":
                    webMenuId = "200-002";
                    break;
                case "transferin":
                    webMenuId = "200-003";
                    break;
                case "transferout":
                    webMenuId = "200-004";
                    break;
                #endregion

                #region EMPLOYEE OPERATIONS
                case "employeekeys":
                    webMenuId = "600-001";
                    break;
                case "exchangeroutecustomer":
                    webMenuId = "600-005";
                    break;
                case "cancelroute":
                    webMenuId = "600-006";
                    break;
                case "retrieveroutecustomer":
                    webMenuId = "600-007";
                    break;
                case "employeekeysprivileges":
                    webMenuId = "600-009";
                    break;

                #endregion

                #region SETTINGS
                case "configurations":
                    webMenuId = "900-001-04";
                    break;
                case "securitygroupmanagement":
                    webMenuId = "900-001-02";
                    break;
                case "excelsheetdynamictemplates":
                    webMenuId = "900-001-12";
                    break;
                case "operatorloginfailures":
                    webMenuId = "900-001-14";
                    break;
                case "customerBILink":
                    webMenuId = "900-001-15";
                    break;
                case "sessionhandling":
                    webMenuId = "900-001-16";
                    break;
                #endregion

                #region ORDER
                case "orderapproved":
                    webMenuId = "300-002";
                    break;
                case "orderassigned":
                    webMenuId = "300-004";
                    break;
                case "ordercollectedreturn":
                    webMenuId = "300-008";
                    break;
                case "orderinvoiced":
                    webMenuId = "300-006";
                    break;
                case "orderpending":
                    webMenuId = "300-001";
                    break;
                case "orderrecurring":
                    webMenuId = "300-005";
                    break;
                case "orderrejected":
                    webMenuId = "300-007";
                    break;
                case "ordercancelled":
                    webMenuId = "300-010";
                    break;
                #endregion

                #region CUSTOMER OPERATIONS
                case "payinvoice":
                    webMenuId = "1000-002";
                    break;
                case "invoice":
                    webMenuId = "1000-001";
                    break;
                case "creditnote":
                    webMenuId = "1000-005";
                    break;
                case "debitnote":
                    webMenuId = "1000-006";
                    break;
                case "transactions":
                    webMenuId = "1000-012";
                    break;
                case "calculatetargetpromotions":
                    webMenuId = "1000-014";
                    break;
                case "returns":
                    webMenuId = "1000-015";
                    break;
                case "exchanges":
                    webMenuId = "1000-016";
                    break;
                case "shopcontracts":
                    webMenuId = "1000-017";
                    break;
                case "testInvoice":
                    webMenuId = "1000-018";
                    break;
                #endregion

                #region CUSTOMER APP PROPERTIES
                case "echonotification":
                    webMenuId = "1700-001-01";
                    break;
                #endregion

                #region PERFORMANCE
                case "kpi":
                    webMenuId = "2200-001";
                    break;
                case "performanceconfiguration":
                    webMenuId = "2200-002";
                    break;
                case "commission":
                    webMenuId = "2200-003";
                    break;
                case "scorecardcustomization":
                    webMenuId = "2200-005";
                    break;
                case "kpidrilldown":
                    webMenuId = "2200-006";
                    break;
                #endregion

                #region Data Review
                case "invoiceslocations":
                    webMenuId = "1500-003";
                    break;
                case "displayunitcustomerimage":
                    webMenuId = "1500-004";
                    break;
                case "surveycustomerimage":
                    webMenuId = "1500-005";
                    break;
                case "surveyemployeeimage":
                    webMenuId = "1500-006";
                    break;
                #endregion

                #region[Chatting]
                case "chatting":
                    webMenuId = "2100";//
                    break;
                #endregion

                #region[Reports]
                case "atreports":
                    webMenuId = "500-002";
                    break;
                case "dynamicreport":
                    webMenuId = "500-001";
                    break;
                #endregion


                default:
                    break;
            }
            return webMenuId;
        }

        WebMenuActions GetActionValue(string actionName)
        {
            WebMenuActions webMenuAction = WebMenuActions.None;
            try
            {
                if (actionName.ToLower().Contains("update"))
                {
                    webMenuAction = WebMenuActions.Edit;
                }
                else if (actionName.ToLower().Contains("insert"))
                {
                    webMenuAction = WebMenuActions.Add;
                }
                else if (actionName.ToLower().Contains("delete"))
                {
                    webMenuAction = WebMenuActions.Delete;
                }
                else if (actionName.ToLower().Contains("adjust"))
                {
                    webMenuAction = WebMenuActions.Adjust;
                }
                else if (actionName.ToLower().Contains("redeem"))
                {
                    webMenuAction = WebMenuActions.Redeem;
                }
                else if (actionName.ToLower().Contains("approve") && !actionName.ToLower().Contains("disapprove"))
                {
                    webMenuAction = WebMenuActions.Approve;
                }
                else if (actionName.ToLower().Contains("disapprove"))
                {
                    webMenuAction = WebMenuActions.Disapprove;
                }
                else if (actionName.ToLower().Contains("cancel"))
                {
                    webMenuAction = WebMenuActions.Cancel;
                }
                else if (actionName.ToLower().Contains("execute"))
                {
                    webMenuAction = WebMenuActions.Execute;
                }
                else if (actionName.ToLower().Contains("assign") && !actionName.ToLower().Contains("removeassignment") && !actionName.ToLower().Contains("GetKPIAssignmentTypes".ToLower()) && !actionName.ToLower().Contains("reassign"))
                {
                    webMenuAction = WebMenuActions.Dispatch;
                }
                else if (actionName.ToLower().Contains("invoice"))
                {
                    webMenuAction = WebMenuActions.Invoice;
                }
                else if (actionName.ToLower().Contains("delivery"))
                {
                    webMenuAction = WebMenuActions.Delivery;
                }
                else if (actionName.ToLower().Contains("reschedule"))
                {
                    webMenuAction = WebMenuActions.Reschedule;
                }
                else if (actionName.ToLower().Contains("removeassignment"))
                {
                    webMenuAction = WebMenuActions.RemoveAssignment;
                }
                else if (actionName.ToLower().Contains("sendloadrequestaction"))
                {
                    webMenuAction = WebMenuActions.SendLoadRequest;
                }
                else if (actionName.ToLower().Contains("process"))
                {
                    webMenuAction = WebMenuActions.Process;
                }
                else if (actionName.ToLower().Contains("void"))
                {
                    webMenuAction = WebMenuActions.Void;
                }else if (actionName.ToLower().Contains("collect"))
                {
                    webMenuAction = WebMenuActions.Collect;
                }else if (actionName.ToLower().Contains("clone"))
                {
                    webMenuAction= WebMenuActions.Clone;
                }
                else if (actionName.ToLower().Contains("postpayment"))
                {
                    webMenuAction = WebMenuActions.PostPayment;
                }
                else if (actionName.ToLower().Contains("move"))
                {
                    webMenuAction = WebMenuActions.Move;
                }
                else if (actionName.ToLower().Contains("reassign"))
                {
                    webMenuAction = WebMenuActions.Reassign;
                }
                else if (actionName.ToLower().Contains("setasnew"))
                {
                    webMenuAction = WebMenuActions.SetAsNew;
                }
                else if (actionName.ToLower().Contains("setaspowersku"))
                {
                    webMenuAction = WebMenuActions.SetAsPowerSKU;
                }
                else if (actionName.ToLower().Contains("setasinitiative"))
                {
                    webMenuAction = WebMenuActions.SetAsInitiative;
                }
            }
            catch (Exception ex)
            {
                webMenuAction = WebMenuActions.None;
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return webMenuAction;
        }

        
        bool CheckIsActionAllowed(string webMenuId, int actionTypeId)
        {
            bool isActionAvailable = false;
            DBHelper<int> dbHelper = new DBHelper<int>();
            GlobalErrors result = GlobalErrors.NotInitialized;
            string actionTypeFilter = string.Empty;
            try
            {
                if(actionTypeId > 0)
                {
                    actionTypeFilter = string.Format("AND ActionTypeID = {0}", actionTypeId);
                }
                object objField = 0;
                string query = string.Format(@"select COUNT(WSGP.MenuID) from WebSecurityGroupPrivilege WSGP
                INNER JOIN SecurityGroup SG on SG.SecurityGroupID = WSGP.SecurityGroupID
                INNER JOIN OperatorSecurityGroup OSG on OSG.SecurityGroupID = SG.SecurityGroupID
                INNER JOIN EmployeeOperator EO on EO.OperatorID = OSG.OperatorID AND EO.EmployeeID = {1}
                WHERE WSGP.MenuID = '{0}' {2}",
                webMenuId, //0
                _requestRepository.CurrentOperator.EmployeeId, //1
                actionTypeFilter //2
                );

                result = dbHelper.ExecuteScalar(query, ref objField);
                if (result == GlobalErrors.Success)
                {
                    if (objField != null && !string.IsNullOrEmpty(objField.ToString()) && int.Parse(objField.ToString()) > 0)
                    {
                        isActionAvailable = true;
                    }
                    else
                    {
                        isActionAvailable = false;
                    }
                }
                else
                {
                    isActionAvailable = false;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                isActionAvailable = false;
            }
            return isActionAvailable;
        }

        bool CheckIsMenuHasActions(string webMenuId)
        {
            bool isMenuHasActions = false;
            DBHelper<int> dbHelper = new DBHelper<int>();
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
              
                object objField = 0;
                string query = string.Format(@"select COUNT(*) from MenuActions where menuid = '{0}' AND ActionTypeId <> '-1'",
                webMenuId);

                result = dbHelper.ExecuteScalar(query, ref objField);
                if (result == GlobalErrors.Success)
                {
                    if (objField != null && !string.IsNullOrEmpty(objField.ToString()) && int.Parse(objField.ToString()) > 0)
                    {
                        isMenuHasActions = true;
                    }
                    else
                    {
                        isMenuHasActions = false;
                    }
                }
                else
                {
                    isMenuHasActions = false;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                isMenuHasActions = false;
            }
            return isMenuHasActions;
        }
    }
}