﻿using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Hosting;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Newtonsoft.Json;
using Sonic.Web.DAL;
using Sonic.Web.Licensing.Licensing;
using Sonic.Web.Model;
using Sonic.Web.Model.Customer;
using Sonic.Web.PL.SystemModels;
using Sonic.Web.Resources;
using Sonic.Web.Service;
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Data;
using System.IO;
using System.Linq;
using System.Reflection;
using System.Threading.Tasks;

namespace Sonic.Web.PL.Controllers
{
    [Route("api/[controller]/[action]")]
    [Authorize]
    public class BundleController : BaseController
    {

        private readonly IRequestRepository _requestRepository;
        private readonly CustomerService _customerService;
        private readonly MasterDataService _masterDataService;
        private readonly IHostingEnvironment _hostingEnvironment;
        private readonly IWebHostEnvironment _webHostEnvironment;

        public BundleController(IRequestRepository requestRepository, IWebHostEnvironment webHostEnvironment, ILicensing licensing, IHostingEnvironment hostingEnvironment, IActiveTokens activeToken) : base(requestRepository, licensing, activeToken)
        {
            _requestRepository = requestRepository;
            _customerService = new CustomerService(_requestRepository);
            _masterDataService = new MasterDataService(requestRepository);
            _hostingEnvironment = hostingEnvironment;
            _webHostEnvironment = webHostEnvironment;
        }

        #region GET
        
        #endregion

        #region INSERT
        
        #endregion

        #region UPDATE
        
        #endregion

        #region DELETE
       
        #endregion
    }
}