﻿using Microsoft.AspNetCore.Mvc;
using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.AspNetCore.Authorization;
using Sonic.Web.DAL;
using Sonic.Web.Licensing.Licensing;
using Sonic.Web.Service;
using Sonic.Web.Model;
using Microsoft.AspNetCore.SignalR;
using Sonic.Web.PL.SystemModels;
using System.Reflection;
using Sonic.Web.Resources;

namespace Sonic.Web.PL.Controllers
{
    [Route("api/[controller]/[action]")]
    [Authorize]
    public class ChattingAssignmentController : BaseController
    {
        private readonly IRequestRepository _requestRepository;
        private readonly ChattingService _chattingService;
        private readonly EmployeeService _employeeService;
        public ChattingAssignmentController(IHubContext<MessageHub> hubContext, IRequestRepository requestRepository, ILicensing licensing, IActiveTokens activeToken) : base(requestRepository, licensing, activeToken)
        {
            _requestRepository = requestRepository;
            _chattingService = new ChattingService(hubContext);
            _employeeService = new EmployeeService(requestRepository);
        }


        [HttpPost]
        [ActionName("InformChattingUsers")]
        public JsonResult UpdateChattingUsers([FromBody] ChattingUserModel user, int languageId)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                if (!string.IsNullOrEmpty(this.Request.Headers["Origin"].ToString()))
                {
                    var originFromHeader = this.Request.Headers["Origin"].ToString().Replace("'", "").Replace("\"", "").ToLower();
                    if (LocalUtilities.AllowedOriginsList != null
                        && LocalUtilities.AllowedOriginsList.Count > 0
                        && LocalUtilities.AllowedOriginsList.FindAll(x => x.Equals("*")).Count <= 0
                        && !string.IsNullOrEmpty(originFromHeader)
                        && !LocalUtilities.AllowedOriginsList.Contains(originFromHeader))
                    {
                        return JSonResultResponse.GetUnauthorized("1");
                    }
                }
                else
                {
                    return JSonResultResponse.GetUnauthorized("1");
                }

                if (user != null && user.UserId != -1) // user: user who logged in / out
                {
                    if (!user.AddRemoveAssignment)
                    {
                        List<ChattingUserModel> availableUsers = new List<ChattingUserModel>(); // users to send notification to.
                        List<ChattingUserModel> BOUsers = new List<ChattingUserModel>();
                        List<ChattingUserModel> FOUsers = new List<ChattingUserModel>();

                        result = _chattingService.GetAvailableUsersForChatting(user.UserId, languageId, string.Empty, ref availableUsers);
                        if (result == GlobalErrors.Success && availableUsers != null && availableUsers.Count > 0)
                        {
                            BOUsers = availableUsers.Where(user1 => user1.IsBOUser == true).ToList();
                            FOUsers = availableUsers.Where(user1 => user1.IsBOUser == false && user1.DeviceToken != null && user1.DeviceToken != string.Empty).ToList();
                            if (FOUsers != null && FOUsers.Count > 0)
                            {
                                string deviceToken = string.Empty;
                                List<string> devices = new List<string>();
                                foreach (ChattingUserModel fouser in FOUsers)
                                {
                                    devices.Add(fouser.DeviceToken);
                                }
                                _chattingService.SendNotificationWhenUpdatingChattingUsers(user, devices, NotificationTypes.UpdateChattingUserStatus, false);
                            }
                            if (BOUsers != null && BOUsers.Count > 0)
                            {
                                _chattingService.UpdateChattingUsersForBOUsers(user);
                            }
                        }
                    }
                    else
                    {
                        _chattingService.UpdateChattingUsersForBOUsers(user);
                        result = GlobalErrors.Success;
                    }
                }
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(result, ResourcesManager.TranslateKey(MessagesConstants.Desc_Saved_Successfully, languageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_Happend, languageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpPost]
        [ActionName("InsertAddedEmployeesToChattingList")]
        public JsonResult InsertAddedEmployeesToChattingList([FromBody] List<ChattingAssignmentModel> assignmentList, int employeeId, int languageId)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                if (!string.IsNullOrEmpty(this.Request.Headers["Origin"].ToString()))
                {
                    var originFromHeader = this.Request.Headers["Origin"].ToString().Replace("'", "").Replace("\"", "").ToLower();
                    if (LocalUtilities.AllowedOriginsList != null
                        && LocalUtilities.AllowedOriginsList.Count > 0
                        && LocalUtilities.AllowedOriginsList.FindAll(x => x.Equals("*")).Count <= 0
                        && !string.IsNullOrEmpty(originFromHeader)
                        && !LocalUtilities.AllowedOriginsList.Contains(originFromHeader))
                    {
                        return JSonResultResponse.GetUnauthorized("1");
                    }
                }
                else
                {
                    return JSonResultResponse.GetUnauthorized("1");
                }

                if (!ModelState.IsValid)
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Provide_UserName_Password, languageId));
                }
                result = _chattingService.SaveAddedEmployeesToChattingList(assignmentList, employeeId, languageId);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(assignmentList, ResourcesManager.TranslateKey(MessagesConstants.Desc_Saved_Successfully, languageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_Happend, languageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpPost]
        [ActionName("InsertAddedSecurityGroupsToChattingList")]
        public JsonResult InsertAddedSecurityGroupsToChattingList([FromBody] List<ChattingAssignmentModel> assignmentList, int employeeId, int languageId)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                if (!string.IsNullOrEmpty(this.Request.Headers["Origin"].ToString()))
                {
                    var originFromHeader = this.Request.Headers["Origin"].ToString().Replace("'", "").Replace("\"", "").ToLower();
                    if (LocalUtilities.AllowedOriginsList != null
                        && LocalUtilities.AllowedOriginsList.Count > 0
                        && LocalUtilities.AllowedOriginsList.FindAll(x => x.Equals("*")).Count <= 0
                        && !string.IsNullOrEmpty(originFromHeader)
                        && !LocalUtilities.AllowedOriginsList.Contains(originFromHeader))
                    {
                        return JSonResultResponse.GetUnauthorized("1");
                    }
                }
                else
                {
                    return JSonResultResponse.GetUnauthorized("1");
                }

                if (!ModelState.IsValid)
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Provide_UserName_Password, languageId));
                }
                result = _chattingService.SaveAddedSecurityGroupsToChattingList(assignmentList, employeeId, languageId);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(assignmentList, ResourcesManager.TranslateKey(MessagesConstants.Desc_Saved_Successfully, languageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_Happend, languageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        [HttpPost]
        [ActionName("DeleteEmployeesFromChattingList")]
        public JsonResult DeleteEmployeesFromChattingList([FromBody] List<ChattingAssignmentModel> assignmentList, int employeeId, int languageId)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                if (!string.IsNullOrEmpty(this.Request.Headers["Origin"].ToString()))
                {
                    var originFromHeader = this.Request.Headers["Origin"].ToString().Replace("'", "").Replace("\"", "").ToLower();
                    if (LocalUtilities.AllowedOriginsList != null
                        && LocalUtilities.AllowedOriginsList.Count > 0
                        && LocalUtilities.AllowedOriginsList.FindAll(x => x.Equals("*")).Count <= 0
                        && !string.IsNullOrEmpty(originFromHeader)
                        && !LocalUtilities.AllowedOriginsList.Contains(originFromHeader))
                    {
                        return JSonResultResponse.GetUnauthorized("1");
                    }
                }
                else
                {
                    return JSonResultResponse.GetUnauthorized("1");
                }

                if (!ModelState.IsValid)
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Provide_UserName_Password, languageId));
                }
                result = _chattingService.DeleteEmployeesFromChattingList(assignmentList, employeeId, languageId);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(assignmentList, ResourcesManager.TranslateKey(MessagesConstants.Desc_Saved_Successfully, languageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_Happend, languageId));
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        [HttpPost]
        [ActionName("DeleteSecurityGroupsFromChattingList")]
        public JsonResult DeleteSecurityGroupsFromChattingList([FromBody] List<ChattingAssignmentModel> assignmentList, int employeeId, int languageId)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                if (!string.IsNullOrEmpty(this.Request.Headers["Origin"].ToString()))
                {
                    var originFromHeader = this.Request.Headers["Origin"].ToString().Replace("'", "").Replace("\"", "").ToLower();
                    if (LocalUtilities.AllowedOriginsList != null
                        && LocalUtilities.AllowedOriginsList.Count > 0
                        && LocalUtilities.AllowedOriginsList.FindAll(x => x.Equals("*")).Count <= 0
                        && !string.IsNullOrEmpty(originFromHeader)
                        && !LocalUtilities.AllowedOriginsList.Contains(originFromHeader))
                    {
                        return JSonResultResponse.GetUnauthorized("1");
                    }
                }
                else
                {
                    return JSonResultResponse.GetUnauthorized("1");
                }

                if (!ModelState.IsValid)
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Provide_UserName_Password, languageId));
                }
                result = _chattingService.DeleteSecurityGroupsFromChattingList(assignmentList, employeeId, languageId);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(assignmentList, ResourcesManager.TranslateKey(MessagesConstants.Desc_Saved_Successfully, languageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_Happend, languageId));
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }


        [HttpPost]
        [ActionName("GetChattingListForAvailableUsersToAdd")]
        public JsonResult GetChattingListForAvailableUsersToAdd([FromBody] EmployeeFilter filter)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                if (!ModelState.IsValid)
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Provide_UserName_Password, _requestRepository.LanguageId));
                }
                List<EmployeeModel> chattingList = new List<EmployeeModel>();
                result = _employeeService.GetChattingListForAvailableUsersToAdd(filter, ref chattingList);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(chattingList, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        [HttpPost]
        [ActionName("GetChattingListForAvailableSecurityGroupsToAdd")]
        public JsonResult GetChattingListForAvailableSecurityGroupsToAdd([FromBody] EmployeeFilter filter)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                if (!ModelState.IsValid)
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Provide_UserName_Password, _requestRepository.LanguageId));
                }
                List<SecurityGroupModel> chattingList = new List<SecurityGroupModel>();
                result = _employeeService.GetChattingListForAvailableSecurityGroupsToAdd(filter, ref chattingList);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(chattingList, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpPost]
        [ActionName("GetChattingListForAddedBeforeUsers")]
        public JsonResult GetChattingListForAddedBeforeUsers([FromBody] EmployeeFilter filter)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                if (!ModelState.IsValid)
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Provide_UserName_Password, _requestRepository.LanguageId));
                }
                List<EmployeeModel> addedChattingList = new List<EmployeeModel>();
                result = _employeeService.GetChattingListForAddedBeforeUsers(filter, ref addedChattingList);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(addedChattingList, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpPost]
        [ActionName("GetChattingListForAddedBeforeSecurityGroups")]
        public JsonResult GetChattingListForAddedBeforeSecurityGroups([FromBody] EmployeeFilter filter)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                if (!ModelState.IsValid)
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Provide_UserName_Password, _requestRepository.LanguageId));
                }
                List<SecurityGroupModel> addedBeforeSGChattingList = new List<SecurityGroupModel>();
                result = _employeeService.GetChattingListForAddedBeforeSecurityGroups(filter, ref addedBeforeSGChattingList);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(addedBeforeSGChattingList, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }


    }
}
