﻿using Microsoft.AspNetCore.Mvc;
using Microsoft.AspNetCore.SignalR;
using Sonic.Web.Core;
using System;
using Microsoft.AspNetCore.Authorization;
using Sonic.Web.PL.SystemModels;
using Sonic.Web.Resources;
using Sonic.Web.DAL;
using Microsoft.AspNetCore.Hosting;
using System.Reflection;
using Sonic.Web.Licensing.Licensing;
using Sonic.Web.Service;
using Sonic.Web.Model;
using System.Collections.Generic;
using System.Linq;
using Microsoft.AspNetCore.Http;
using System.Collections.ObjectModel;
using Newtonsoft.Json;
using System.Threading.Tasks;
using System.IO;

namespace Sonic.Web.PL.Controllers
{
    [Route("api/[controller]/[action]")]
    [Authorize]
    public class ChattingController : BaseController
    {
        private readonly IRequestRepository _requestRepository;
        private readonly ChattingService _chattingService;
        private readonly IWebHostEnvironment _webHostEnvironment;
        private readonly CustomerService _customerService;

        public ChattingController(IHubContext<MessageHub> hubContext, IRequestRepository requestRepository, ILicensing licensing, IActiveTokens activeToken, IWebHostEnvironment webHostEnvironment) : base(requestRepository, licensing, activeToken)
        {
            _requestRepository = requestRepository;
            _chattingService = new ChattingService(hubContext);
            _webHostEnvironment = webHostEnvironment;
            _customerService = new CustomerService(requestRepository);
        }

        [HttpPost]
        [ActionName("CheckForChattingAvailability")]
        public JsonResult CheckForInternetConnection()
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                bool isConnected = _customerService.PingHost(true);
                return JSonResultResponse.GetSuccessrJSon(isConnected, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, 1));

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpPost]
        [ActionName("GetUploadedFOUsersInChattingAssignment")]
        public JsonResult GetUploadedFOUsersInChattingAssignment([FromBody] EmployeeFilter filter)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                if (!string.IsNullOrEmpty(this.Request.Headers["Origin"].ToString()))
                {
                    var originFromHeader = this.Request.Headers["Origin"].ToString().Replace("'", "").Replace("\"", "").ToLower();
                    if (LocalUtilities.AllowedOriginsList != null
                        && LocalUtilities.AllowedOriginsList.Count > 0
                        && LocalUtilities.AllowedOriginsList.FindAll(x => x.Equals("*")).Count <= 0
                        && !string.IsNullOrEmpty(originFromHeader)
                        && !LocalUtilities.AllowedOriginsList.Contains(originFromHeader))
                    {
                        return JSonResultResponse.GetUnauthorized("1");
                    }
                }
                else
                {
                    return JSonResultResponse.GetUnauthorized("1");
                }

                List<ChattingUserModel> uploadedFOUsers = new List<ChattingUserModel>();
                result = _chattingService.GetUploadedFOUsersInChattingAssignment(filter.EmployeeId, false, filter.LanguageId, ref uploadedFOUsers);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(uploadedFOUsers, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, filter.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_Happend, filter.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpPost]
        [ActionName("GetAvailableUsersForChatting")]
        public JsonResult GetAvailableUsersForChatting([FromBody] EmployeeFilter filter)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                if (!string.IsNullOrEmpty(this.Request.Headers["Origin"].ToString()))
                {
                    var originFromHeader = this.Request.Headers["Origin"].ToString().Replace("'", "").Replace("\"", "").ToLower();
                    if (LocalUtilities.AllowedOriginsList != null
                        && LocalUtilities.AllowedOriginsList.Count > 0
                        && LocalUtilities.AllowedOriginsList.FindAll(x => x.Equals("*")).Count <= 0
                        && !string.IsNullOrEmpty(originFromHeader)
                        && !LocalUtilities.AllowedOriginsList.Contains(originFromHeader))
                    {
                        return JSonResultResponse.GetUnauthorized("1");
                    }
                }
                else
                {
                    return JSonResultResponse.GetUnauthorized("1");
                }
                string rootPath = _webHostEnvironment.WebRootPath;
                List<ChattingUserModel> availableUsers = new List<ChattingUserModel>();
                result = _chattingService.GetAvailableUsersForChatting(filter.EmployeeId, filter.LanguageId, rootPath, ref availableUsers);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(availableUsers, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, filter.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_Happend, filter.LanguageId));
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpPost]
        [ActionName("GetChattingUserData")]
        public JsonResult GetChattingUserData([FromBody] EmployeeFilter filter)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                if (!string.IsNullOrEmpty(this.Request.Headers["Origin"].ToString()))
                {
                    var originFromHeader = this.Request.Headers["Origin"].ToString().Replace("'", "").Replace("\"", "").ToLower();
                    if (LocalUtilities.AllowedOriginsList != null
                        && LocalUtilities.AllowedOriginsList.Count > 0
                        && LocalUtilities.AllowedOriginsList.FindAll(x => x.Equals("*")).Count <= 0
                        && !string.IsNullOrEmpty(originFromHeader)
                        && !LocalUtilities.AllowedOriginsList.Contains(originFromHeader))
                    {
                        return JSonResultResponse.GetUnauthorized("1");
                    }
                }
                else
                {
                    return JSonResultResponse.GetUnauthorized("1");
                }
                string rootPath = _webHostEnvironment.WebRootPath;
                ChattingUserModel user = new ChattingUserModel();
                result = _chattingService.GetChattingUserData(filter.EmployeeId, filter.LanguageId, rootPath, ref user);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(user, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, filter.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_Happend, filter.LanguageId));
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpPost]
        [ActionName("GetChattingHistory")]
        public JsonResult GetChattingHistory([FromBody] ChattingHistoryModel chatInfo,int languageId)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                if (!string.IsNullOrEmpty(this.Request.Headers["Origin"].ToString()))
                {
                    var originFromHeader = this.Request.Headers["Origin"].ToString().Replace("'", "").Replace("\"", "").ToLower();
                    if (LocalUtilities.AllowedOriginsList != null
                        && LocalUtilities.AllowedOriginsList.Count > 0
                        && LocalUtilities.AllowedOriginsList.FindAll(x => x.Equals("*")).Count <= 0
                        && !string.IsNullOrEmpty(originFromHeader)
                        && !LocalUtilities.AllowedOriginsList.Contains(originFromHeader))
                    {
                        return JSonResultResponse.GetUnauthorized("1");
                    }
                }
                else
                {
                    return JSonResultResponse.GetUnauthorized("1");
                }

                if (!ModelState.IsValid)
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Provide_UserName_Password, languageId));
                }
                List<ChattingHistoryModel> chattingHistory = new List<ChattingHistoryModel>();
                result = _chattingService.GetChattingHistory(chatInfo, languageId, ref chattingHistory);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(chattingHistory, ResourcesManager.TranslateKey(MessagesConstants.Desc_Saved_Successfully, languageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_Happend, languageId));
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpPost]
        [ActionName("ReceiveMessage")] 
        public JsonResult ReceiveMessage([FromForm] Collection<IFormFile> attachedFiles, [FromForm] string messageString)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                #region[Authorize]
                if (!string.IsNullOrEmpty(this.Request.Headers["Origin"].ToString()))
                {
                    var originFromHeader = this.Request.Headers["Origin"].ToString().Replace("'", "").Replace("\"", "").ToLower();
                    if (LocalUtilities.AllowedOriginsList != null
                        && LocalUtilities.AllowedOriginsList.Count > 0
                        && LocalUtilities.AllowedOriginsList.FindAll(x => x.Equals("*")).Count <= 0
                        && !string.IsNullOrEmpty(originFromHeader)
                        && !LocalUtilities.AllowedOriginsList.Contains(originFromHeader))
                    {
                        return JSonResultResponse.GetUnauthorized("1");
                    }
                }
                else
                {
                    return JSonResultResponse.GetUnauthorized("1");
                }
                #endregion

                if (!ModelState.IsValid)
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Provide_UserName_Password, _requestRepository.LanguageId));
                }
                ChattingHistoryModel message = new ChattingHistoryModel();
                if (messageString != null)
                {
                    message = JsonConvert.DeserializeObject<ChattingHistoryModel>(messageString);
                }
                string rootPath = _webHostEnvironment.WebRootPath;
                message.MessageDateTimeModel = new DateModel(DateTime.Now);
                message.MessageDate = DateTime.Now.ToString("dd/MM/yyyy HH:mm:ss");
                #region[Prepare FO Receivers Device Tokens]
                if (message.ReceiversList == null || message.ReceiversList.Count == 0) // Single message
                {
                    if(!message.IsBOReceiver)
                    {
                        string receiverDeviceToken = string.Empty;
                        result = _chattingService.GetReceiverToken(message.ReceiverDeviceSerial, ref receiverDeviceToken);
                        if (result == GlobalErrors.Success && !string.IsNullOrEmpty(receiverDeviceToken))
                        {
                            message.ReceiverDeviceToken = receiverDeviceToken;
                        }
                        else
                        {
                            return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_Happend, message.LanguageId));
                        }
                    } 
                    else
                    {
                        result = GlobalErrors.Success;
                    }

                } 
                else if (message.ReceiversList != null && message.ReceiversList.Count > 0) // Broadcast message
                {
                    List<BroadcastReceiverModel> foReceivers =  message.ReceiversList.Where(r => !r.IsBOReceiver).ToList();
                    if(foReceivers != null && foReceivers.Count > 0)
                    {
                        result = _chattingService.GetReceiversTokenList(ref foReceivers);
                        if(result == GlobalErrors.Success && foReceivers != null && foReceivers.Count > 0)
                        {
                            foreach (BroadcastReceiverModel r in foReceivers)
                            {
                                message.ReceiversList.Where(foR => foR.ReceiverId == r.ReceiverId).ToList().FirstOrDefault().ReceiverDeviceToken = r.ReceiverDeviceToken;
                            }
                        }
                    } 
                    else
                    {
                        result = GlobalErrors.Success;
                    }
                }
                #endregion
                if (result == GlobalErrors.Success)
                {
                    var isBroadcast = message.ReceiversList != null && message.ReceiversList.Count > 0 ? true : false;
                    if (!isBroadcast)
                    {
                        result = _chattingService.SendMessage(message,attachedFiles, rootPath, false, _requestRepository.Configurations.hasSupervisorApp);

                    }
                    else
                    {
                        result = _chattingService.SendBroadcast(message, attachedFiles, rootPath);
                    }
                    if (result == GlobalErrors.Success)
                    {
                        return JSonResultResponse.GetSuccessrJSon(message, ResourcesManager.TranslateKey(MessagesConstants.Desc_Saved_Successfully, message.LanguageId));
                    }
                    else
                    {
                        return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_Happend, message.LanguageId));
                    }
                } 
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_Happend, message.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }



        [HttpPost]
        [ActionName("SetMessagesAsRead")]
        public JsonResult SetMessageAsRead([FromBody] ChattingHistoryModel message, int languageId)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                if (!string.IsNullOrEmpty(this.Request.Headers["Origin"].ToString()))
                {
                    var originFromHeader = this.Request.Headers["Origin"].ToString().Replace("'", "").Replace("\"", "").ToLower();
                    if (LocalUtilities.AllowedOriginsList != null
                        && LocalUtilities.AllowedOriginsList.Count > 0
                        && LocalUtilities.AllowedOriginsList.FindAll(x => x.Equals("*")).Count <= 0
                        && !string.IsNullOrEmpty(originFromHeader)
                        && !LocalUtilities.AllowedOriginsList.Contains(originFromHeader))
                    {
                        return JSonResultResponse.GetUnauthorized("1");
                    }
                }
                else
                {
                    return JSonResultResponse.GetUnauthorized("1");
                }

                if (!ModelState.IsValid)
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Provide_UserName_Password, languageId));
                }
                result = _chattingService.SetMessagesAsRead(message);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(result, ResourcesManager.TranslateKey(MessagesConstants.Desc_Saved_Successfully, languageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_Happend, languageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpPost]
        [ActionName("SetAttachmentAsDownloaded")]
        public JsonResult SetAttachmentAsDownloaded([FromBody] ChattingHistoryModel message, int languageId)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                #region[Authorize]
                if (!string.IsNullOrEmpty(this.Request.Headers["Origin"].ToString()))
                {
                    var originFromHeader = this.Request.Headers["Origin"].ToString().Replace("'", "").Replace("\"", "").ToLower();
                    if (LocalUtilities.AllowedOriginsList != null
                        && LocalUtilities.AllowedOriginsList.Count > 0
                        && LocalUtilities.AllowedOriginsList.FindAll(x => x.Equals("*")).Count <= 0
                        && !string.IsNullOrEmpty(originFromHeader)
                        && !LocalUtilities.AllowedOriginsList.Contains(originFromHeader))
                    {
                        return JSonResultResponse.GetUnauthorized("1");
                    }
                }
                else
                {
                    return JSonResultResponse.GetUnauthorized("1");
                }
                #endregion

                if (!ModelState.IsValid)
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Provide_UserName_Password, languageId));
                }
                result = _chattingService.SetAttachmentAsDownloaded(message);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(result, ResourcesManager.TranslateKey(MessagesConstants.Desc_Saved_Successfully, languageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_Happend, languageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }

        }

        [HttpPost]
        [ActionName("GetEmployeeUnreadMessages")]
        public JsonResult GetEmployeeUnreadMessages([FromBody] EmployeeFilter filter)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;

            try
            {
                if (!string.IsNullOrEmpty(this.Request.Headers["Origin"].ToString()))
                {
                    var originFromHeader = this.Request.Headers["Origin"].ToString().Replace("'", "").Replace("\"", "").ToLower();
                    if (LocalUtilities.AllowedOriginsList != null
                        && LocalUtilities.AllowedOriginsList.Count > 0
                        && LocalUtilities.AllowedOriginsList.FindAll(x => x.Equals("*")).Count <= 0
                        && !string.IsNullOrEmpty(originFromHeader)
                        && !LocalUtilities.AllowedOriginsList.Contains(originFromHeader))
                    {
                        return JSonResultResponse.GetUnauthorized("1");
                    }
                }
                else
                {
                    return JSonResultResponse.GetUnauthorized("1");
                }

                string rootPath = _webHostEnvironment.WebRootPath;
                List<ChattingHistoryModel> unreadMessages = new List<ChattingHistoryModel>();
                result = _chattingService.GetEmployeeUnreadMessages(filter.EmployeeId, filter.LanguageId, rootPath, ref unreadMessages);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(unreadMessages, ResourcesManager.TranslateKey(MessagesConstants.Desc_Saved_Successfully, filter.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_Happend, filter.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpPost]
        [ActionName("InformChattingUsers")]
        public JsonResult UpdateChattingUsers([FromBody] ChattingUserModel user, int languageId)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                if (!string.IsNullOrEmpty(this.Request.Headers["Origin"].ToString()))
                {
                    var originFromHeader = this.Request.Headers["Origin"].ToString().Replace("'", "").Replace("\"", "").ToLower();
                    if (LocalUtilities.AllowedOriginsList != null
                        && LocalUtilities.AllowedOriginsList.Count > 0
                        && LocalUtilities.AllowedOriginsList.FindAll(x => x.Equals("*")).Count <= 0
                        && !string.IsNullOrEmpty(originFromHeader)
                        && !LocalUtilities.AllowedOriginsList.Contains(originFromHeader))
                    {
                        return JSonResultResponse.GetUnauthorized("1");
                    }
                }
                else
                {
                    return JSonResultResponse.GetUnauthorized("1");
                }

                if (user != null && user.UserId != -1) // user: user who logged in / out
                {
                    if (!user.AddRemoveAssignment)
                    {
                        List<ChattingUserModel> availableUsers = new List<ChattingUserModel>(); // users to send notification to.
                        List<ChattingUserModel> BOUsers = new List<ChattingUserModel>();
                        List<ChattingUserModel> FOUsers = new List<ChattingUserModel>();

                        result = _chattingService.GetAvailableUsersForChatting(user.UserId, languageId, string.Empty, ref availableUsers);
                        if (result == GlobalErrors.Success && availableUsers != null && availableUsers.Count > 0)
                        {
                            BOUsers = availableUsers.Where(user1 => user1.IsBOUser == true ).ToList();
                            FOUsers = availableUsers.Where(user1 => user1.IsBOUser == false && user1.DeviceToken != null && user1.DeviceToken != string.Empty).ToList();
                            if (FOUsers != null && FOUsers.Count > 0)
                            {
                                string deviceToken = string.Empty;
                                List<string> devices = new List<string>();
                                foreach (ChattingUserModel fouser in FOUsers)
                                {
                                    devices.Add(fouser.DeviceToken);
                                }
                                _chattingService.SendNotificationWhenUpdatingChattingUsers(user, devices, NotificationTypes.UpdateChattingUserStatus, false);
                            }
                            if (BOUsers != null && BOUsers.Count > 0)
                            {
                                _chattingService.UpdateChattingUsersForBOUsers(user);
                            }
                        }
                    }
                    else
                    {
                        _chattingService.UpdateChattingUsersForBOUsers(user);
                        result = GlobalErrors.Success;
                    }
                }
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(result, ResourcesManager.TranslateKey(MessagesConstants.Desc_Saved_Successfully, languageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_Happend, languageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }


        [HttpPost]
        [ActionName("SetEmployeeMessagesAsReceived")]
        public JsonResult SetEmployeeMessagesAsReceived([FromBody] ChattingHistoryModel message)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                #region[Authorize]
                if (!string.IsNullOrEmpty(this.Request.Headers["Origin"].ToString()))
                {
                    var originFromHeader = this.Request.Headers["Origin"].ToString().Replace("'", "").Replace("\"", "").ToLower();
                    if (LocalUtilities.AllowedOriginsList != null
                        && LocalUtilities.AllowedOriginsList.Count > 0
                        && LocalUtilities.AllowedOriginsList.FindAll(x => x.Equals("*")).Count <= 0
                        && !string.IsNullOrEmpty(originFromHeader)
                        && !LocalUtilities.AllowedOriginsList.Contains(originFromHeader))
                    {
                        return JSonResultResponse.GetUnauthorized("1");
                    }
                }
                else
                {
                    return JSonResultResponse.GetUnauthorized("1");
                }
                #endregion
                if (!ModelState.IsValid)
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_Happend, _requestRepository.LanguageId));
                }

                result = _chattingService.SetEmployeeMessagesAsReceived(_requestRepository.CurrentOperator.EmployeeId, message);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(result, ResourcesManager.TranslateKey(MessagesConstants.Desc_Saved_Successfully, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_Happend, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpPost]
        [ActionName("CheckInactiveEmployeeChattingHistory")]
        public JsonResult CheckInactiveEmployeeChattingHistory([FromBody] List<int> inactiveUsersIds, int employeeId, int languageId)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                if (!string.IsNullOrEmpty(this.Request.Headers["Origin"].ToString()))
                {
                    var originFromHeader = this.Request.Headers["Origin"].ToString().Replace("'", "").Replace("\"", "").ToLower();
                    if (LocalUtilities.AllowedOriginsList != null
                        && LocalUtilities.AllowedOriginsList.Count > 0
                        && LocalUtilities.AllowedOriginsList.FindAll(x => x.Equals("*")).Count <= 0
                        && !string.IsNullOrEmpty(originFromHeader)
                        && !LocalUtilities.AllowedOriginsList.Contains(originFromHeader))
                    {
                        return JSonResultResponse.GetUnauthorized("1");
                    }
                }
                else
                {
                    return JSonResultResponse.GetUnauthorized("1");
                }

                if (inactiveUsersIds == null || inactiveUsersIds.Count == 0)
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Provide_UserName_Password, languageId));
                }
                List<int> data = new List<int>();

                result = _chattingService.CheckInactiveEmployeeChattingHistory(inactiveUsersIds, employeeId, ref data);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(data, ResourcesManager.TranslateKey(MessagesConstants.Desc_Saved_Successfully, languageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_Happend, languageId));
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpPost]
        [ActionName("DownloadFile")]
        public async Task<FileStream> DownloadFile(string Id, string fileName)
        {
            string operationFileName = "";
            try
            {
                if (string.IsNullOrEmpty(fileName))
                {
                    return null;
                }

                operationFileName = "ChattingMedia";
                string folderName = Path.Combine("wwwroot\\", operationFileName, Id, fileName);
                string rootPath = _webHostEnvironment.ContentRootPath;
                var path = Path.Combine(rootPath, folderName);


                return new FileStream(path, FileMode.Open, FileAccess.Read);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return null;
            }
        }

   
        //[HttpPost]
        //public JsonResult CheckIfChattingIsAvailableForOperator([FromBody] EmployeeFilter filter)
        //{
        //    GlobalErrors result = GlobalErrors.NotInitialized;
        //    try
        //    {
        //        if (!string.IsNullOrEmpty(this.Request.Headers["Origin"].ToString()))
        //        {
        //            var originFromHeader = this.Request.Headers["Origin"].ToString().Replace("'", "").Replace("\"", "").ToLower();
        //            if (LocalUtilities.AllowedOriginsList != null
        //                && LocalUtilities.AllowedOriginsList.Count > 0
        //                && LocalUtilities.AllowedOriginsList.FindAll(x => x.Equals("*")).Count <= 0
        //                && !string.IsNullOrEmpty(originFromHeader)
        //                && !LocalUtilities.AllowedOriginsList.Contains(originFromHeader))
        //            {
        //                return JSonResultResponse.GetUnauthorized("1");
        //            }
        //        }
        //        else
        //        {
        //            return JSonResultResponse.GetUnauthorized("1");
        //        }

        //        bool isAvailable = false;

        //        result = _chattingService.CheckIfChattingIsAvailableForOperator(filter.EmployeeId, ref isAvailable);
        //        if (result == GlobalErrors.Success)
        //        {
        //            return JSonResultResponse.GetSuccessrJSon(isAvailable, ResourcesManager.TranslateKey(MessagesConstants.Desc_Saved_Successfully, filter.LanguageId));
        //        }
        //        else
        //        {
        //            return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_Happend, filter.LanguageId));
        //        }

        //    }
        //    catch (Exception ex)
        //    {
        //        ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
        //        return JSonResultResponse.GetErrorJSon();
        //    }
        //}
    }
}
