﻿using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Mvc;
using Sonic.Web.DAL;
using Sonic.Web.Licensing.Licensing;
using Sonic.Web.Model;
using Sonic.Web.Models;
using Sonic.Web.PL.SystemModels;
using Sonic.Web.Resources;
using Sonic.Web.Service;
using System;
using System.Collections.Generic;
using System.Reflection;

namespace Sonic.Web.PL.Controllers
{
    [Route("api/[controller]/[action]")]
    [Authorize]
    public class ConfigurationController : BaseController
    {
        private readonly IRequestRepository _requestRepository;
        private readonly ConfigurationService _configurationService;
        private readonly IActiveTokens _activeToken;
        public ConfigurationController(IRequestRepository requestRepository,ILicensing licensing, IActiveTokens activeToken) : base(requestRepository, licensing, activeToken)
        {
            _requestRepository = requestRepository;
            
            _configurationService = new ConfigurationService(requestRepository);
            _activeToken = activeToken;
        }
        #region GET
        [HttpPost]
        [ActionName("GetAllConfigurations")]
        public JsonResult GetAllConfigurations([FromBody] ConfigurationModel configuration)
        {
            List<ConfigurationModel> allConfigurations = new List<ConfigurationModel>();
            try
            {
                GlobalErrors result = GlobalErrors.Success;
                if (configuration.LevelId == (int)ConfigurationLevels.SystemLevel)
                    result = _configurationService.GetAllConfigurations(ref allConfigurations);
                else
                    result = _configurationService.GetLevelConfigurations(configuration.LevelId, configuration.Filter, ref allConfigurations);
                if (result == GlobalErrors.Success)
                {

                    return JSonResultResponse.GetSuccessrJSon(allConfigurations, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpPost]
        [ActionName("GetConfigurationValue")]
        public JsonResult GetConfigurationValue([FromBody] ConfigurationFilter filter)
        {
            try
            {
                string keyName = string.Empty;
                int divisionId = -1;
                string keyValue = string.Empty;
                if(filter != null)
                {
                    keyName = filter.KeyName;
                    divisionId = filter.DivisionId;
                }
                GlobalErrors result = _configurationService.GetConfigurationValue(keyName, divisionId.ToString(), ref keyValue);
                if (result == GlobalErrors.Success && !string.IsNullOrEmpty(keyValue))
                {
                    return JSonResultResponse.GetSuccessrJSon(keyValue, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        #endregion

        #region INSERT
        [HttpPost]
        [ActionName("InsertLevelConfigurations")]
        public JsonResult InsertLevelConfigurations([FromBody] ConfigurationLevelData configLevelData)
        {
            try
            {
                if (configLevelData == null) return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Saving, _requestRepository.LanguageId));

                GlobalErrors result = _configurationService.SaveLevelConfigurations(configLevelData.changedConfigurations, configLevelData.ConfigLevel);

                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(result, ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Saving, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        #endregion
        #region UPDATE

        [HttpPost]
        [ActionName("UpdateSystemConfigurations")]
        public JsonResult UpdateSystemConfigurations([FromBody] List<ConfigurationModel> changedConfigurationsList)
        {
            try
            {
                GlobalErrors result = _configurationService.UpdateSystemConfigurations(changedConfigurationsList);

                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(result, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Update_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Saving, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        #endregion
    }
}