﻿using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Mvc;
using Sonic.Web.DAL;
using Sonic.Web.Licensing.Licensing;
using Sonic.Web.Model;
using Sonic.Web.PL.SystemModels;
using Sonic.Web.Resources;
using Sonic.Web.Service;
using System;
using System.Collections.Generic;

namespace Sonic.Web.PL.Controllers
{
    [Route("api/[controller]/[action]")]
    [Authorize]
    public class DashboardController : BaseController
    {

        private readonly IRequestRepository _requestRepository;
        private readonly DashboardService _dashboardService;
        public DashboardController(IRequestRepository requestRepository, ILicensing licensing, IActiveTokens activeToken) : base(requestRepository, licensing, activeToken)
        {
            _requestRepository = requestRepository;
            _dashboardService = new DashboardService(_requestRepository);
        }

        [HttpPost]
        [ActionName("GetEndOfDayReoports")]
        public JsonResult GetEndOfDayReoports([FromBody] int routeHistoryId)
        {
            try
            {
                var data = new List<Category>();
                GlobalErrors result = _dashboardService.GetEndOfDayReoports(routeHistoryId , ref data);
                if (result != GlobalErrors.Success)
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
                else
                    return JSonResultResponse.GetSuccessrJSon(data, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
            }
            catch (Exception ex)
            {
                return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
            }
        }
        [HttpPost]
        [ActionName("GetEndorsementDashboards")]
        public JsonResult GetEndorsementDashboards([FromBody] int routeHistoryId)
        {
            try
            {
                var data = new List<Dashboard>();
                GlobalErrors result = _dashboardService.GetEndorsementDashboards(routeHistoryId, ref data);
                if (result != GlobalErrors.Success)
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
                else
                    return JSonResultResponse.GetSuccessrJSon(data, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
            }
            catch (Exception ex)
            {
                return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
            }
        }
        [HttpPost]
        [ActionName("GetOperationDashboardId")]
        public JsonResult GetOperationDashboardId([FromBody] int operation)
        {
            try
            {
                int id = _dashboardService.GetOperationDashboardId((DashboardOperations)operation);
                return JSonResultResponse.GetSuccessrJSon(id, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
            }
            catch (Exception ex)
            {
                return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
            }
        }
        [HttpPost]
        [ActionName("GetAvailableDashboard")]
        public JsonResult GetAvailableDashboard()
        {
            try
            {
                var data = new List<Category>();
                GlobalErrors result = _dashboardService.GetAvailableDashboard(ref data);
                if (result != GlobalErrors.Success)
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
                else
                    return JSonResultResponse.GetSuccessrJSon(data, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
            }
            catch (Exception ex)
            {
                return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
            }
        }


        [HttpPost]
        [ActionName("GetAvailableReport")]
        public JsonResult GetAvailableReport()
        {
            try
            {
                var data = new List<Category>();
                GlobalErrors result =_dashboardService.GetAvailableReport(ref data);
                if (result != GlobalErrors.Success)
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
                else
                    return JSonResultResponse.GetSuccessrJSon(data, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
            }
            catch (Exception ex)
            {
                return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
            }
        }
        [HttpPost]
        [ActionName("GetAvailableAdvancedToolReport")]
        public JsonResult GetAvailableAdvancedToolReport()
        {
            try
            {
                var data = new List<Category>();
                GlobalErrors result = _dashboardService.GetAvailableAdvancedToolReport(ref data);
                if (result != GlobalErrors.Success)
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
                else
                    return JSonResultResponse.GetSuccessrJSon(data, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
            }
            catch (Exception ex)
            {
                return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
            }
        }
    }
}
