﻿using System;
using System.Collections.Generic;
using System.Reflection;
using DinkToPdf.Contracts;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Hosting;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Newtonsoft.Json;
using Sonic.Web.DAL;
using Sonic.Web.Licensing.Licensing;
using Sonic.Web.Model;
using Sonic.Web.PL.SystemModels;
using Sonic.Web.Resources;
using Sonic.Web.Service;

namespace Sonic.Web.PL.Controllers
{
    [Route("api/[controller]/[action]")]
    [Authorize]
    public class DynamicTemplateController : BaseController
    {
        private readonly IRequestRepository _requestRepository;
        private readonly EmailService _emailService;

        public DynamicTemplateController(IRequestRepository requestRepository, ILicensing licensing, IActiveTokens activeToken) : base(requestRepository, licensing, activeToken)
        {
            _requestRepository = requestRepository;
            _emailService = new EmailService(requestRepository);
        }
        #region [GET]
        [HttpPost]
        [ActionName("GetDynamicTemplates")]
        public JsonResult GetDynamicTemplates([FromBody] int dynamicTemplateEmailType)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                List<DynamicTemplateModel> dynamicTemplates = new List<DynamicTemplateModel>();
                result = _emailService.GetDynamicTemplates(ref dynamicTemplates, dynamicTemplateEmailType);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(dynamicTemplates, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpPost]
        [ActionName("GetDynamicTemplateData")]
        public JsonResult GetDynamicTemplateData([FromBody] int templateId)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DynamicTemplateModel dynamicTemplateObj = new DynamicTemplateModel();
                result = _emailService.GetDynamicTemplateData(templateId, ref dynamicTemplateObj);

                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(dynamicTemplateObj, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        [HttpPost]
        [ActionName("GetReportTypes")]
        public JsonResult GetReportTypes()
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {

                if (result == GlobalErrors.Success)
                {
                    List<DynamicTemplateReportTypeModel> emailTypes = new List<DynamicTemplateReportTypeModel>();
                    //result = _emailService.GetReportTypes(ref emailTypes);
                    return JSonResultResponse.GetSuccessrJSon(emailTypes, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        [HttpPost]
        [ActionName("GetDynamicTemplateEmailTypes")]
        public JsonResult GetDynamicTemplateEmailTypes([FromBody] int emailTypeId)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {

                List<DynamicTemplateReportTypeModel> emailTypes = new List<DynamicTemplateReportTypeModel>();
                result = _emailService.GetDynamicTemplateEmailTypes(emailTypeId, ref emailTypes);

                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(emailTypes, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpPost]
        [ActionName("GetDynamicTemplateReportFiles")]
        public JsonResult GetDynamicTemplateReportFiles([FromBody] int transactionTypeId)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                List<DynamicTemplateReportFileModel> reportFiles = new List<DynamicTemplateReportFileModel>();
                result = _emailService.GetDynamicTemplateReportFiles(transactionTypeId, ref reportFiles);

                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(reportFiles, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }

        }
        #endregion
        #region [INSERT]

        [HttpPost]
        [ActionName("InsertDynamicTemplate")]
        public JsonResult InsertDynamicTemplate([FromBody] DynamicTemplateModel dynamicTemplate)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                if (!ModelState.IsValid)
                {
                    return JSonResultResponse.GetErrorJSon(MessagesConstants.MessageSavingFailed);
                }
                result = _emailService.SaveDynamicTemplate(dynamicTemplate);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(result, ResourcesManager.TranslateKey(MessagesConstants.Desc_Saved_Successfully, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Saving, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        #endregion
        #region [UPDATE]
        [HttpPost]
        [ActionName("UpdateDynamicTemplateActiveStatus")]
        public JsonResult UpdateDynamicTemplateActiveStatus([FromBody] DynamicTemplateModel dynamicTemplate)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                if (!ModelState.IsValid)
                {
                    return JSonResultResponse.GetErrorJSon(MessagesConstants.Desc_Error_Happend);
                }
                result = _emailService.UpdateDynamicTemplateActiveStatus(dynamicTemplate);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(result, ResourcesManager.TranslateKey(MessagesConstants.Desc_Saved_Successfully, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Saving, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        #endregion

    }
}
