﻿using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Hosting;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Newtonsoft.Json;
using Sonic.Web.DAL;
using Sonic.Web.Licensing.Licensing;
using Sonic.Web.Model;
using Sonic.Web.Model.Customer;
using Sonic.Web.PL.SystemModels;
using Sonic.Web.Resources;
using Sonic.Web.Service;
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Data;
using System.IO;
using System.Linq;
using System.Reflection;
using System.Threading.Tasks;

namespace Sonic.Web.PL.Controllers
{
    [Route("api/[controller]/[action]")]
    [Authorize]
    public class EchoNotificationController : BaseController
    {

        private readonly IRequestRepository _requestRepository;
        private readonly IHostingEnvironment _hostingEnvironment;
        private readonly IWebHostEnvironment _webHostEnvironment;
        private readonly CustomerService _customerService;
        public EchoNotificationController(IRequestRepository requestRepository, IWebHostEnvironment webHostEnvironment, ILicensing licensing, IHostingEnvironment hostingEnvironment, IActiveTokens activeToken) : base(requestRepository, licensing, activeToken)
        {
            _requestRepository = requestRepository;
            _hostingEnvironment = hostingEnvironment;
            _webHostEnvironment = webHostEnvironment;
            _customerService = new CustomerService(_requestRepository);
        }

        #region GET

        #endregion

        #region UPDATE

        #endregion

        #region INSERT
        [HttpPost]
        [ActionName("InsertCustomerNotifications")]
        public JsonResult InsertCustomerNotifications([FromForm] ICollection<IFormFile> Files, [FromForm] string Notification)
        {
            GlobalErrors result = GlobalErrors.Error;
            try
            {
                if (!ModelState.IsValid)
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Provide_UserName_Password, _requestRepository.LanguageId));
                }
                NotificaitonsModel CustomerNotificaitons = JsonConvert.DeserializeObject<NotificaitonsModel>(Notification);
                int maxId = -1;
                result = _customerService.GetMaxNotificationId(ref maxId);
                if (result == GlobalErrors.Success)
                {
                    CustomerNotificaitons.NotificationId = maxId;
                }
                if (Files != null && Files.Count > 0 && result == GlobalErrors.Success)
                {
                    foreach (IFormFile file in Files)
                    {
                        if (file.ContentType.ToString().ToLower().Contains("image/"))
                        {
                            result = UploadNotificationImage(file, ref CustomerNotificaitons);
                            if (result != GlobalErrors.Success)
                            {
                                return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Saving, _requestRepository.LanguageId));
                            }
                        }
                        else if (file.ContentType.ToString().ToLower().Contains("video/"))
                        {
                            result = UploadNotificationVideo(file, ref CustomerNotificaitons);
                            if (result != GlobalErrors.Success)
                            {
                                return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Saving, _requestRepository.LanguageId));
                            }
                        }
                    }
                }
                result = _customerService.SaveCustomerNotifications(CustomerNotificaitons);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(CustomerNotificaitons, ResourcesManager.TranslateKey(MessagesConstants.Desc_Saved_Successfully, _requestRepository.LanguageId));
                }
                else if (result == GlobalErrors.ValueIsMoreThanRequested)
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Cannot_Insert_Same_Method_Befroe_And_After, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Saving, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        #endregion

        #region DELETE

        #endregion

        #region METHODS
        public GlobalErrors UploadNotificationImage(IFormFile image, ref NotificaitonsModel CustomerNotificaitons)
        {
            try
            {
                if (image == null)
                {
                    return GlobalErrors.Error;
                }

                string path = string.Format(@"{0}", LocalUtilities.CustomerAppServicePath);
                string folderName = "wwwroot\\notifications\\images";
                string newPath = Path.Combine(path, folderName);
                var file = image;

                if (!Directory.Exists(newPath))
                {
                    Directory.CreateDirectory(newPath);
                }

                if (file.Length > 0)
                {
                    //string fileName = file.FileName;// ContentDispositionHeaderValue.Parse(file.ContentDisposition).FileName.Trim('"');
                    string extension = Path.GetExtension(file.FileName).ToLowerInvariant();
                    if (!string.IsNullOrEmpty(extension))
                    {
                        string fileName = CustomerNotificaitons.NotificationId + extension;
                        string fullPath = Path.Combine(newPath, fileName);
                        using (var stream = new FileStream(fullPath, FileMode.Create))
                        {
                            file.CopyTo(stream);
                        }
                        CustomerNotificaitons.ImageName = fileName;
                    }
                    else
                    {
                        return GlobalErrors.Error;
                    }

                }
                return GlobalErrors.Success;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        public GlobalErrors UploadNotificationVideo(IFormFile video, ref NotificaitonsModel CustomerNotificaitons)
        {
            try
            {
                if (video == null)
                {
                    return GlobalErrors.Error;
                }
                var file = video;

                string path = string.Format(@"{0}", LocalUtilities.CustomerAppServicePath);
                string folderName = "wwwroot\\notifications\\videos";

                string newPath = Path.Combine(path, folderName);
                if (!Directory.Exists(newPath))
                {
                    Directory.CreateDirectory(newPath);
                }

                if (file.Length > 0)
                {
                    string extension = Path.GetExtension(file.FileName).ToLowerInvariant();
                    if (!string.IsNullOrEmpty(extension))
                    {
                        //string fileName = file.FileName;// ContentDispositionHeaderValue.Parse(file.ContentDisposition).FileName.Trim('"');
                        string fileName = CustomerNotificaitons.NotificationId + extension;
                        string fullPath = Path.Combine(newPath, fileName);
                        using (var stream = new FileStream(fullPath, FileMode.Create))
                        {
                            file.CopyTo(stream);
                        }
                        CustomerNotificaitons.VideoName = fileName;
                    }
                    else
                    {
                        return GlobalErrors.Error;
                    }

                }
                return GlobalErrors.Success;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        #endregion
    }
}