﻿using System;
using System.Collections.Generic;
using System.Reflection;
using DinkToPdf.Contracts;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Hosting;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Newtonsoft.Json;
using Sonic.Web.DAL;
using Sonic.Web.Licensing.Licensing;
using Sonic.Web.Model;
using Sonic.Web.PL.SystemModels;
using Sonic.Web.Resources;
using Sonic.Web.Service;

namespace Sonic.Web.PL.Controllers
{
    [Route("api/[controller]/[action]")]
    [Authorize]
    public class EmailController : BaseController
    {
        private readonly IRequestRepository _requestRepository;
        private readonly EmailService _emailService;

        public EmailController(IRequestRepository requestRepository, ILicensing licensing, IActiveTokens activeToken) : base(requestRepository, licensing, activeToken)
        {
            _requestRepository = requestRepository;
            _emailService = new EmailService(requestRepository);
        }

        [HttpPost]
        [ActionName("GetEmailTemplatesList")]
        public JsonResult GetEmailTemplatesList([FromBody]bool showActiveOnly)
        {
            try
            {
                SharedTableResult<EmailTemplateModel> emailTempList = new SharedTableResult<EmailTemplateModel>();
                GlobalErrors result = _emailService.GetEmailTemplatesList(showActiveOnly, ref emailTempList);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(emailTempList, MessagesConstants.MessageSuccess);
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon();
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpPost]
        [ActionName("GetReportScheduleTemplateDetail")]
        public JsonResult GetReportScheduleTemplateDetail()
        {
            try
            {
                EmailTemplateModel emailTemp = new EmailTemplateModel();
                GlobalErrors result = GlobalErrors.NotInitialized;
                result = _emailService.GetReportScheduleTemplateDetail(ref emailTemp);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(emailTemp, MessagesConstants.MessageSuccess);
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon();
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        
        [HttpPost]
        [ActionName("GetEmailTemplateDetail")]
        public JsonResult GetEmailTemplateDetail([FromBody]int emailTempId)
        {
            try
            {
                if (emailTempId <= 0)
                    return JSonResultResponse.GetErrorJSon();
                EmailTemplateModel emailTemp = new EmailTemplateModel();
                GlobalErrors result = GlobalErrors.NotInitialized;
                result = _emailService.GetEmailTemplateDetail(emailTempId, ref emailTemp);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(emailTemp, MessagesConstants.MessageSuccess);
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon();
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpPost]
        [ActionName("InsertReportScheduleTemplate")]
        public JsonResult InsertReportScheduleTemplate([FromBody] EmailTemplateModel emailModel)
        {
            try
            {
                var result = _emailService.InsertReportScheduleTemplate(emailModel);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(null, MessagesConstants.MessageSavingSuccessfully);
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(MessagesConstants.MessageSavingFailed);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon(MessagesConstants.MessageSavingFailed);
            }
        }

        [HttpPost]
        [ActionName("GetEmailTypes")]
        public JsonResult GetEmailTypes([FromBody] EmailTypeModel emailType)
        {
            try
            {
                List<EmailTypeModel> emailTypes = new List<EmailTypeModel>();
                GlobalErrors result = GlobalErrors.NotInitialized;
                result = _emailService.GetEmailTypes(emailType.IsExcludedTypeCRM,ref emailTypes);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(emailTypes, MessagesConstants.MessageSuccess);
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon();
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        
        [HttpPost]
        [ActionName("ModifyEmailTemplate")]
        public JsonResult ModifyEmailTemplate([FromBody] EmailTemplateModel emailModel)
        {
            try
            {
                if (!ModelState.IsValid)
                    return JSonResultResponse.GetErrorJSon(MessagesConstants.MessageSavingFailed);

                var result = _emailService.ModifyEmailTemplate(emailModel);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(null, MessagesConstants.MessageSavingSuccessfully);
                }
                else if (result == GlobalErrors.ValueIsMoreThanRequested)
                {
                    return JSonResultResponse.GetErrorJSon(MessagesConstants.MessageEmailTypeAlreadyExist);
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(MessagesConstants.MessageSavingFailed);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon(MessagesConstants.MessageSavingFailed);
            }
        }

        [HttpPost]
        [ActionName("UploadFiles")]
        public JsonResult UploadFiles([FromForm] ICollection<IFormFile> file, [FromForm] string email)
        {
            try
            {
                EmailModel emailObj = JsonConvert.DeserializeObject<EmailModel>(email);
                if (emailObj != null)
                {
                    _emailService.SendEmail(file, emailObj);
                }
                return JSonResultResponse.GetSuccessrJSon();
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        //[HttpPost]
        //[ActionName("InsertDynamicTemplate")]
        //public JsonResult InsertDynamicTemplate([FromBody] DynamicTemplateModel dynamicTemplate)
        //{
        //    GlobalErrors result = GlobalErrors.NotInitialized;
        //    try
        //    {
        //        if (!ModelState.IsValid)
        //        {
        //            return JSonResultResponse.GetErrorJSon(MessagesConstants.MessageSavingFailed);
        //        }
        //        result = _emailService.SaveDynamicTemplate(dynamicTemplate);
        //        if (result == GlobalErrors.Success)
        //        {
        //            return JSonResultResponse.GetSuccessrJSon(result, ResourcesManager.TranslateKey(MessagesConstants.Desc_Saved_Successfully, _requestRepository.LanguageId));
        //        }
        //        else
        //        {
        //            return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Saving, _requestRepository.LanguageId));
        //        }
        //    }
        //    catch (Exception ex)
        //    {
        //        ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
        //        return JSonResultResponse.GetErrorJSon();
        //    }
        //}
        //[HttpPost]
        //[ActionName("GetDynamicTemplates")]
        //public JsonResult GetDynamicTemplates([FromBody]int dynamicTemplateEmailType)
        //{
        //    GlobalErrors result = GlobalErrors.NotInitialized;
        //    try
        //    {
        //        List<DynamicTemplateModel> dynamicTemplates = new List<DynamicTemplateModel>();
        //        result = _emailService.GetDynamicTemplates(ref dynamicTemplates, dynamicTemplateEmailType);
        //        if (result == GlobalErrors.Success)
        //        {
        //            return JSonResultResponse.GetSuccessrJSon(dynamicTemplates, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
        //        }
        //        else
        //        {
        //            return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
        //        }

        //    }
        //    catch (Exception ex)
        //    {
        //        ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
        //        return JSonResultResponse.GetErrorJSon();
        //    }
        //}

        //[HttpPost]
        //[ActionName("GetDynamicTemplateData")]
        //public JsonResult GetDynamicTemplateData([FromBody]int templateId)
        //{
        //    GlobalErrors result = GlobalErrors.NotInitialized;
        //    try
        //    {
        //        DynamicTemplateModel dynamicTemplateObj = new DynamicTemplateModel();
        //        result = _emailService.GetDynamicTemplateData(templateId, ref dynamicTemplateObj);

        //        if (result == GlobalErrors.Success)
        //        {
        //            return JSonResultResponse.GetSuccessrJSon(dynamicTemplateObj, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
        //        }
        //        else
        //        {
        //            return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
        //        }

        //    }
        //    catch (Exception ex)
        //    {
        //        ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
        //        return JSonResultResponse.GetErrorJSon();
        //    }
        //}
        //[HttpPost]
        //[ActionName("GetReportTypes")]
        //public JsonResult GetReportTypes()
        //{
        //    GlobalErrors result = GlobalErrors.NotInitialized;
        //    try
        //    {

        //        if (result == GlobalErrors.Success)
        //        {
        //            List<DynamicTemplateReportTypeModel> emailTypes = new List<DynamicTemplateReportTypeModel>();
        //            //result = _emailService.GetReportTypes(ref emailTypes);
        //            return JSonResultResponse.GetSuccessrJSon(emailTypes, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
        //        }
        //        else
        //        {
        //            return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
        //        }
        //    }
        //    catch (Exception ex)
        //    {
        //        ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
        //        return JSonResultResponse.GetErrorJSon();
        //    }
        //}
        //[HttpPost]
        //[ActionName("GetDynamicTemplateEmailTypes")]
        //public JsonResult GetDynamicTemplateEmailTypes([FromBody]int emailTypeId)
        //{
        //    GlobalErrors result = GlobalErrors.NotInitialized;
        //    try
        //    {

        //        List<DynamicTemplateReportTypeModel> emailTypes = new List<DynamicTemplateReportTypeModel>();
        //        result = _emailService.GetDynamicTemplateEmailTypes(emailTypeId, ref emailTypes);

        //        if (result == GlobalErrors.Success)
        //        {
        //            return JSonResultResponse.GetSuccessrJSon(emailTypes, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
        //        }
        //        else
        //        {
        //            return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
        //        }
        //    }
        //    catch (Exception ex)
        //    {
        //        ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
        //        return JSonResultResponse.GetErrorJSon();
        //    }
        //}

        //[HttpPost]
        //[ActionName("GetDynamicTemplateReportFiles")]
        //public JsonResult GetDynamicTemplateReportFiles([FromBody]int transactionTypeId)
        //{
        //    GlobalErrors result = GlobalErrors.NotInitialized;
        //    try
        //    {
        //        List<DynamicTemplateReportFileModel> reportFiles = new List<DynamicTemplateReportFileModel>();
        //        result = _emailService.GetDynamicTemplateReportFiles(transactionTypeId, ref reportFiles);

        //        if (result == GlobalErrors.Success)
        //        {
        //            return JSonResultResponse.GetSuccessrJSon(reportFiles, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
        //        }
        //        else
        //        {
        //            return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
        //        }
        //    }
        //    catch (Exception ex)
        //    {
        //        ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
        //        return JSonResultResponse.GetErrorJSon();
        //    }

        //}
        //[HttpPost]
        //[ActionName("UpdateDynamicTemplateActiveStatus")]
        //public JsonResult UpdateDynamicTemplateActiveStatus([FromBody] DynamicTemplateModel dynamicTemplate)
        //{
        //    GlobalErrors result = GlobalErrors.NotInitialized;
        //    try
        //    {
        //        if (!ModelState.IsValid)
        //        {
        //            return JSonResultResponse.GetErrorJSon(MessagesConstants.Desc_Error_Happend);
        //        }
        //        result = _emailService.UpdateDynamicTemplateActiveStatus(dynamicTemplate);
        //        if (result == GlobalErrors.Success)
        //        {
        //            return JSonResultResponse.GetSuccessrJSon(result, ResourcesManager.TranslateKey(MessagesConstants.Desc_Saved_Successfully, _requestRepository.LanguageId));
        //        }
        //        else
        //        {
        //            return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Saving, _requestRepository.LanguageId));
        //        }
        //    }
        //    catch (Exception ex)
        //    {
        //        ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
        //        return JSonResultResponse.GetErrorJSon();
        //    }
        //}

    }
}