﻿using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Hosting;
using Microsoft.AspNetCore.Mvc;
using Sonic.Web.DAL;
using Sonic.Web.Model;
using Sonic.Web.PL.SystemModels;
using Sonic.Web.Resources;
using Sonic.Web.Service;
using System;
using System.Collections.Generic;
using System.IO;
using System.Reflection;
using System.Linq;
using Sonic.Web.Models;
using Sonic.Web.Licensing.Licensing;
using Newtonsoft.Json;
using Sonic.Web.PL.Helper;
using InCube.Security;
using System.Dynamic;
using Sonic.Web.SecureLibrary;
using Newtonsoft.Json.Serialization;

namespace Sonic.Web.PL.Controllers
{
    [Route("api/[controller]/[action]")]
    [Authorize]
    public class EmployeeController : BaseController
    {

        private readonly IRequestRepository _requestRepository;
        private readonly IHostingEnvironment _hostingEnvironment;
        private readonly EmployeeService _employeeService;
        private readonly MasterDataService _masterDataService;
        private readonly IWebHostEnvironment _webHostEnvironment;
        private readonly LoginService _loginService;
        private readonly IActiveTokens _activeTokens;

        public EmployeeController(IRequestRepository requestRepository , IWebHostEnvironment webHostEnvironment, IHostingEnvironment hostingEnvironment, ILicensing licensing, IActiveTokens activeToken) : base(requestRepository,licensing, activeToken)
        {
            _activeTokens = activeToken;
            _hostingEnvironment = hostingEnvironment;
            _requestRepository = requestRepository;
            _employeeService = new EmployeeService(_requestRepository);
            _masterDataService = new MasterDataService(_requestRepository);
            _webHostEnvironment = webHostEnvironment;
            _loginService = new LoginService(_requestRepository, activeToken);
        }
        #region GET

        #region OPERATOR & MENUS
        [HttpPost]
        [ActionName("FillOperatorData")]
        public JsonResult FillOperatorData([FromBody] int languageId)
        {
            try
            {
                List<MenuModel> allAvailableMenus = new List<MenuModel>();
                List<MenuModel> addedMenus = new List<MenuModel>();
                _requestRepository.LanguageId = languageId;
                GlobalErrors result = _employeeService.FillOperatorConfigurations();
                if (result == GlobalErrors.Success)
                {
                    result = _employeeService.FillOperatorRelatedData();
                }
                if (result == GlobalErrors.Success)
                {
                    result = _employeeService.FillMenuData(ref allAvailableMenus, ref addedMenus, -1, FormMode.None);
                }
                if (result == GlobalErrors.Success)
                {
                    var data = new
                    {
                        configurationsList = _requestRepository.ConfigurationsList,
                        // configurationsListOnDivisionLevel = CoreSession.Instance.ConfigurationsListOnDivisionLevel,
                        menusList = allAvailableMenus,
                        addedList = addedMenus,
                        encryptedEmployeeId = _requestRepository.CurrentOperator.EncryptedEmployeeId,

                    };

                    var serializerSettings = new JsonSerializerSettings();
                    serializerSettings.ContractResolver = new CamelCasePropertyNamesContractResolver();
                    var json = JsonConvert.SerializeObject(data, serializerSettings);
                    string encryptString = AESEncryption.EncryptDataAESE(json, _requestRepository.CurrentOperator.EmployeeId);
                    if(encryptString != null && !string.IsNullOrEmpty(encryptString))
                    {
                        return JSonResultResponse.GetSuccessrJSon(encryptString, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                    }
                    else
                    {
                        return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                    }

                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        [HttpGet]
        [ActionName("FillOperatorConfigurations")]
        public JsonResult FillOperatorConfigurations()
        {
            try
            {

                GlobalErrors result = _employeeService.FillOperatorConfigurations();
                if (result == GlobalErrors.Success)
                {
                    var data = new
                    {
                        configurationsList = _requestRepository.ConfigurationsList,
                        // configurationsListOnDivisionLevel = CoreSession.Instance.ConfigurationsListOnDivisionLevel,
                        encryptedEmployeeId = _requestRepository.CurrentOperator.EncryptedEmployeeId,
                    };
                    var serializerSettings = new JsonSerializerSettings();
                    serializerSettings.ContractResolver = new CamelCasePropertyNamesContractResolver();
                    var json = JsonConvert.SerializeObject(data, serializerSettings);
                    string encryptString = AESEncryption.EncryptDataAESE(json, _requestRepository.CurrentOperator.EmployeeId);
                    if (encryptString != null && !string.IsNullOrEmpty(encryptString))
                    {
                        return JSonResultResponse.GetSuccessrJSon(encryptString, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                    }
                    else
                    {
                        return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                    }
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        [HttpPost]
        [ActionName("FillMenuData")]
        public JsonResult FillMenuData([FromBody] int securityGroupId)
        {
            List<MenuModel> allAvailableMenus = new List<MenuModel>();
            List<MenuModel> addedMenus = new List<MenuModel>();
            try
            {
                GlobalErrors result = _employeeService.FillMenuData(ref allAvailableMenus, ref addedMenus, securityGroupId, FormMode.None);
                if (result == GlobalErrors.Success)
                {
                    var data = new
                    {
                        menusList = allAvailableMenus,
                        addedList = addedMenus
                    };
                    return JSonResultResponse.GetSuccessrJSon(data, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        [HttpGet]
        [ActionName("GetParentMenus")]
        public JsonResult GetParentMenus()
        {
            try
            {
                List<MenuModel> menus = new List<MenuModel>();
                GlobalErrors result = _employeeService.GetParentMenus(ref menus);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(menus, ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        [HttpGet]
        [ActionName("GetLandingMenu")]
        public JsonResult GetLandingMenu()
        {
            try
            {
                MenuModel menuModel = null;
                GlobalErrors result = _employeeService.GetLandingMenu(ref menuModel);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(menuModel, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        #endregion

        #region EMPLOYEES
        [HttpPost]
        [ActionName("GetOrganizationEmployees")]
        public JsonResult GetOrganizationEmployees([FromBody]string organizationIds)
        {
            try
            {
                List<EmployeeModel> employeeList = new List<EmployeeModel>();
                List<EmployeeModel> routeEmployeeList = new List<EmployeeModel>();
                List<EmployeeModel> foEmployeeList = new List<EmployeeModel>();
                var result = _employeeService.GetOrganizationEmployees(organizationIds, ref employeeList, ref routeEmployeeList, ref foEmployeeList);
                dynamic data = new ExpandoObject();
                data.employeeList = employeeList;
                data.routeEmployeeList = routeEmployeeList;
                data.foEmployeeList = foEmployeeList;
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(data, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                return JSonResultResponse.GetErrorJSon();
            }
        }
        [HttpPost]
        [ActionName("GetEmployeesList")]
        public JsonResult GetEmployeesList([FromBody] EmployeeFilter employeeFilter)
        {
            try
            {
                SharedTableResult<EmployeeModel> employeesList = new SharedTableResult<EmployeeModel>();
                GlobalErrors result = _employeeService.GetEmployeesList(employeeFilter, ref employeesList);


                if (result == GlobalErrors.Success)
                {
                    if (employeesList != null && employeesList.Data != null && employeesList.Data.ToList().Count > 0)
                    {
                        return JSonResultResponse.GetSuccessrJSon(employeesList, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                    }
                    else
                    {
                        return JSonResultResponse.GetSuccessrJSon(employeesList, ResourcesManager.TranslateKey(MessagesConstants.Desc_No_Data_Found, _requestRepository.LanguageId));
                    }
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        [HttpPost]
        [ActionName("GetEmployeeData")]
        public JsonResult GetEmployeeData([FromBody] EmployeeModel employee)
        {
            try
            {
                if (!ModelState.IsValid)
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Provide_UserName_Password, _requestRepository.LanguageId));
                }
                int employeeId = Int32.Parse(EncryptionManager.Instance.DecryptData(employee.EmployeeIdSignature).Trim());
                if (employeeId != -1)
                {
                    EmployeeModel selectedEmployee = new EmployeeModel();
                    GlobalErrors result = _employeeService.GetEmployeeData(employeeId, ref selectedEmployee);
                    if (result == GlobalErrors.Success)
                    {
                        var serializerSettings = new JsonSerializerSettings();
                        serializerSettings.ContractResolver = new CamelCasePropertyNamesContractResolver();

                        if (!string.IsNullOrEmpty(selectedEmployee.OperatorPassword))
                        {
                            selectedEmployee.OperatorPassword = AESEncryption.EncryptDataAESE(JsonConvert.SerializeObject(selectedEmployee.OperatorPassword, serializerSettings), _requestRepository.CurrentOperator.EmployeeId);
                        }
                        if (!string.IsNullOrEmpty(selectedEmployee.OperatorName))
                        {
                            selectedEmployee.OperatorName = AESEncryption.EncryptDataAESE(JsonConvert.SerializeObject(selectedEmployee.OperatorName, serializerSettings), _requestRepository.CurrentOperator.EmployeeId);
                        }
                        
                        return JSonResultResponse.GetSuccessrJSon(selectedEmployee, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                    }
                    else
                    {
                        return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                    }
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        [HttpPost]
        [ActionName("GetEmployeesFilterData")]
        public JsonResult GetEmployeesFilterData([FromBody] EmployeeFilter filter)
        {
            try
            {
                var employeeList = new List<EmployeeModel>();
                var result = _employeeService.GetEmployeesFilterData(filter, ref employeeList);

                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(employeeList, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                return JSonResultResponse.GetErrorJSon();
            }
        }
        #endregion

        #region EMPLOYEES RELATED DATA
        [HttpPost]
        [ActionName("GetEmployeeLoadingVehicle")]
        public JsonResult GetEmployeeLoadingVehicle([FromBody] EmployeeModel employeeVehicle)
        {
            try
            {
                var result = new List<EmployeeModel>();
                result = _employeeService.GetEmployeeLoadingVehicle(employeeVehicle.VehicleId, employeeVehicle.OrganizationId);
                return JSonResultResponse.GetSuccessrJSon(result, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
            }
            catch (Exception ex)
            {
                return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
            }
        }
        [HttpPost]
        [ActionName("GetWarehouseStoreKeeper")]
        public JsonResult GetWarehouseStoreKeeper([FromBody] EmployeeModel warehouseStoreKeeper)
        {
            try
            {
                var result = new List<EmployeeModel>();
                result = _employeeService.GetWarehouseStoreKeeper(warehouseStoreKeeper.WarehouseId, warehouseStoreKeeper.OrganizationId);
                return JSonResultResponse.GetSuccessrJSon(result, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
            }
            catch (Exception ex)
            {
                return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
            }
        }

        [HttpPost]
        [ActionName("CheckEmployeeAccount")]
        public JsonResult CheckEmployeeAccount([FromBody] int employeeId)
        {
            try
            {
                bool isAccountExist = false;
                GlobalErrors result = _employeeService.CheckEmployeeAccount(employeeId, ref isAccountExist);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(isAccountExist, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        [HttpGet]
        [ActionName("GetEmployeeProfileData")]
        public JsonResult GetEmployeeProfileData()
        {
            try
            {
                EmployeeModel employee = new EmployeeModel();
                GlobalErrors result = _employeeService.GetEmployeeProfileData(ref employee, _webHostEnvironment.WebRootPath);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(employee, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        [HttpPost]
        [ActionName("GetNotConnectedHelpersOrDrivers")]
        public JsonResult GetNotConnectedHelpersOrDrivers([FromBody] EmployeeFilter employeeFilter)
        {
            try
            {
                List<EmployeeModel> freeEmployeesList = new List<EmployeeModel>();
                int employeeId = -1;
                int organizationId = -1;
                EmployeeTypes employeeType = EmployeeTypes.None;

                if(employeeFilter != null)
                {
                    employeeId = employeeFilter.EmployeeId;
                    organizationId = employeeFilter.OrganizationId;
                    employeeType = employeeFilter.EmployeeType;
                }

                GlobalErrors result = _employeeService.GetNotConnectedHelpersOrDrivers(employeeId, organizationId, employeeType, ref freeEmployeesList);

                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(freeEmployeesList, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpGet]
        [ActionName("GetRegions")]
        public JsonResult GetRegions()
        {
            try
            {
                List<RegionModel> freeRegionsList = new List<RegionModel>();
                GlobalErrors result = _employeeService.GetRegions(ref freeRegionsList);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(freeRegionsList, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        [HttpPost]
        [ActionName("GetRelatedEmployees")]
        public JsonResult GetRelatedEmployees([FromBody] EmployeeFilter employeeFilter)
        {
            try
            {
                List<EmployeeModel> freeEmployeesList = new List<EmployeeModel>();
                GlobalErrors result = _employeeService.GetRelatedEmployees(employeeFilter.EmployeeId, employeeFilter.OrganizationId, employeeFilter.EmployeeTypeId, ref freeEmployeesList);

                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(freeEmployeesList, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpGet]
        [ActionName("GetEmployeeTypes")]
        public JsonResult GetEmployeeTypes()
        {
            try
            {
                List<EmployeeTypeModel> employeeTypesList = new List<EmployeeTypeModel>();
                GlobalErrors result = _employeeService.GetEmployeeTypes(ref employeeTypesList);

                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(employeeTypesList, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        [HttpPost]
        [ActionName("GetCustomerRouteEmployees")]
        public JsonResult GetCustomerRouteEmployees([FromBody] EmployeeFilter filter)
        {
            try
            {
                var employeeList = new List<EmployeeModel>();
                var result = _employeeService.GetCustomerRouteEmployees(filter, ref employeeList);

                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(employeeList, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpPost]
        [ActionName("AllowChangePassword")]
        public JsonResult AllowChangePassword([FromBody] int operatorID)
        {
            string errorMessage = string.Empty;
            bool allowChangePassword = true;
            try
            {
                allowChangePassword = _employeeService.AllowChangePassword(operatorID, ref errorMessage);
                if (!allowChangePassword)
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(errorMessage, _requestRepository.LanguageId));
                }
                return JSonResultResponse.GetSuccessrJSon(allowChangePassword, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        [HttpPost]
        [ActionName("GetAllInspectors")]
        public JsonResult GetAllInspectors([FromBody] EmployeeModel inspector)
        {
            try
            {
                var inspectorList = new List<EmployeeModel>();
                var result = _employeeService.GetAllInspectors(inspector.OrganizationIds, ref inspectorList);

                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(inspectorList, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                return JSonResultResponse.GetErrorJSon();
            }
        }
        [HttpPost]
        [ActionName("GetAllSurveyEmployees")]
        public JsonResult GetAllSurveyEmployees([FromBody] EmployeeModel surveyEmployee)
        {
            try
            {
                var employeeList = new List<EmployeeModel>();
                var result = _employeeService.GetAllSurveyEmployees(surveyEmployee.OrganizationIds, ref employeeList);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(employeeList, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                return JSonResultResponse.GetErrorJSon();
            }
        }
        [HttpPost]
        [ActionName("FillSecurityGroupsList")]
        public JsonResult FillSecurityGroupsList([FromBody] SecurityGroupModel securityGroup)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                List<SecurityGroupModel> securityGroups = new List<SecurityGroupModel>();
                result = _employeeService.FillSecurityGroupsList(securityGroup.OrganizationIds, false, ref securityGroups);

                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(securityGroups, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        [HttpGet]
        [ActionName("GetAllSecurityGroupsList")]
        public JsonResult GetAllSecurityGroupsList()
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                List<SecurityGroupModel> securityGroups = new List<SecurityGroupModel>();
                result = _employeeService.FillSecurityGroupsList(string.Empty, true, ref securityGroups);

                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(securityGroups, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        [HttpGet]
        [ActionName("GetItemsList")]
        public JsonResult GetItemsList()
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                List<ItemListModel> itemsList = new List<ItemListModel>();
                result = _employeeService.GetItemsList(ref itemsList);

                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(itemsList, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        [HttpPost]
        [ActionName("GetEmployeeBranches")]
        public JsonResult GetEmployeeBranches([FromBody] EmployeeBranchModel employeeFilter)
        {
            try
            {
                List<EmployeeBranchModel> EmployeeBranchesList = new List<EmployeeBranchModel>();
                int organizationId = -1;
                if (employeeFilter != null)
                {
                    organizationId = employeeFilter.OrganizationId;
                }
                GlobalErrors result = _employeeService.GetEmployeeBranches(organizationId, ref EmployeeBranchesList);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(EmployeeBranchesList, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpPost]
        [ActionName("GetContactCountrys")]
        public JsonResult GetContactCountrys()
        {
            try
            {
                List<ContactCountryModel> ContactCountrysList = new List<ContactCountryModel>();
                
                GlobalErrors result = _employeeService.GetContactCountrys(ref ContactCountrysList);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(ContactCountrysList, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        #endregion

        #endregion

        #region UPDATE
        [HttpPost]
        [ActionName("UpdateOperatorDataFromProfile")]
        public JsonResult UpdateOperatorDataFromProfile([FromBody] OperatorProfileModel operatorObj)
        {
            try
            {
                List<string> errors = new List<string>();
                GlobalErrors result = GlobalErrors.NotInitialized;
                //  var file = operatorModel.ImageFile;//Request.Form.Files[0];


                //string rootPath = _hostingEnvironment.ContentRootPath;
                // GlobalErrors result = EmployeeService.UpdateUserProfileImage(rootPath, file);
                //if(result!= GlobalErrors.Success)
                //{
                //    errors.Add("Error Occured While Saving User Image \n");
                //}
                result = _employeeService.UpdateOperatorDataFromProfile(operatorObj, ref errors);
                if (result == GlobalErrors.Success && errors.Count == 0)
                {
                    return JSonResultResponse.GetSuccessrJSon(true, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Update_Data, _requestRepository.LanguageId));
                }
                else
                {
                    string errMsg = ResourcesManager.TranslateKey(MessagesConstants.Desc_Following_Errors_Occured, _requestRepository.LanguageId) + ": \n ";
                    for (int i = 0; i < errors.Count; i++)
                    {
                        errMsg += errors[i] + "\n ";
                    }
                    return JSonResultResponse.GetErrorJSon(errMsg);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpPost]
        [ActionName("UpdateEmployeeActiveStatus")]
        public JsonResult UpdateEmployeeActiveStatus([FromBody] EmployeeModel filter)
        {
            try
            {
                if (!ModelState.IsValid)
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Provide_UserName_Password, _requestRepository.LanguageId));
                }
                GlobalErrors result = _employeeService.UpdateEmployeeActiveStatus(filter.EmployeeId, filter.IsActive);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(result, ResourcesManager.TranslateKey(MessagesConstants.Desc_Saved_Successfully, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Saving, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        
        

        [HttpPost]
        [ActionName("UpdateEmployee")]
        public JsonResult UpdateEmployee([FromBody] EmployeeModel employee)
        {
            try
            {
                if (!ModelState.IsValid)
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Provide_UserName_Password, _requestRepository.LanguageId));
                }


                bool isValid = true;
                string errorMessage = string.Empty;
                GlobalErrors result = _employeeService.ValidateEmployeeToSave(employee, ref isValid, ref errorMessage);

                if (result == GlobalErrors.Success)
                {
                    if (isValid)
                    {
                        result = _employeeService.SaveEmployee(employee);
                        if (result == GlobalErrors.Success)
                        {
                            if (employee.EmployeeId > -1 &&
                                (employee.EmployeeId == _requestRepository.CurrentOperator.EmployeeId || _requestRepository.CurrentOperator.EmployeeTypeId == EmployeeTypes.Supervisor.GetHashCode()) ||
                                employee.EmployeeId == _requestRepository.CurrentOperator.EmployeeId
                                )
                            {
                                result = _employeeService.FillOperatorRelatedData(true, true, true);
                                if (result != GlobalErrors.Success) return JSonResultResponse.GetErrorJSon("Desc_Saving_Faild");
                                string tokenString = WorkExtension.GenerateToken(_requestRepository.CurrentOperator, HttpContext.Session.Id, employee.ExpirationDate);
                                string httpToken = this.Request.Headers["Authorization"].ToString();
                                if (!string.IsNullOrEmpty(httpToken) && !string.IsNullOrEmpty(tokenString))
                                {
                                    _activeTokens.DeleteActiveTokens(httpToken);
                                    _activeTokens.AddActiveTokens(tokenString);
                                }
                                if (!string.IsNullOrEmpty(tokenString))
                                {
                                    var data = new
                                    {
                                        EmployeeId = employee.EmployeeId,
                                        tokenString = tokenString,
                                        currentOperator = _requestRepository.CurrentOperator,
                                        IsValid = isValid,
                                    };
                                    return JSonResultResponse.GetSuccessrJSon(data, ResourcesManager.TranslateKey(MessagesConstants.Desc_Saved_Successfully, _requestRepository.LanguageId));
                                }
                                else
                                {
                                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey("Token Error", _requestRepository.LanguageId));
                                }
                            }
                            else
                            {
                                var data = new
                                {
                                    EmployeeId = employee.EmployeeId,
                                    IsValid = isValid,
                                };
                                return JSonResultResponse.GetSuccessrJSon(data, ResourcesManager.TranslateKey(MessagesConstants.Desc_Saved_Successfully, _requestRepository.LanguageId));

                            }
                        }
                        else
                        {
                            return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Saving, _requestRepository.LanguageId));
                        }
                    }
                    else
                    {
                        var data = new
                        {
                            IsValid = isValid,
                            ErrorMessage = errorMessage
                        };
                        return JSonResultResponse.GetSuccessrJSon(data, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                    }
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Saving, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        #endregion

        #region INSERT
        [HttpPost]
        [ActionName("UploadImage")]
        public JsonResult UploadImage()
        {
            try
            {
                var file = Request.Form.Files[0];

                string folderName = "Users-Img";
                string rootPath = _webHostEnvironment.WebRootPath;

                string newPath = Path.Combine(rootPath, folderName);
                if (!Directory.Exists(newPath))
                {
                    Directory.CreateDirectory(newPath);
                }

                if (file.Length > 0)
                {
                    string fileName = _requestRepository.CurrentOperator.EmployeeId + ".jpg";// ContentDispositionHeaderValue.Parse(file.ContentDisposition).FileName.Trim('"');
                    string fullPath = Path.Combine(newPath, fileName);

                    if (Directory.Exists(fullPath))
                    {
                        System.IO.File.Delete(fullPath);
                    }

                    using (var stream = new FileStream(fullPath, FileMode.Create))
                    {
                        file.CopyTo(stream);
                    }
                }
                return JSonResultResponse.GetSuccessrJSon(true, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Update_Data, _requestRepository.LanguageId));
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpPost]
        [ActionName("InsertEmployee")]
        public JsonResult InsertEmployee([FromBody] EmployeeModel employee)
        {
            try
            {
                if (!ModelState.IsValid)
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Provide_UserName_Password, _requestRepository.LanguageId));
                }


                bool isValid = true;
                string errorMessage = string.Empty;
                GlobalErrors result = _employeeService.ValidateEmployeeToSave(employee, ref isValid, ref errorMessage);
                var data = new
                {
                    IsValid = isValid,
                    ErrorMessage = errorMessage
                };

                if(result == GlobalErrors.Success)
                {
                    if (isValid)
                    {
                        result = _employeeService.SaveEmployee(employee);
                        if (result == GlobalErrors.Success)
                        {
                            if (employee.EmployeeId > -1 &&
                                (employee.EmployeeId == _requestRepository.CurrentOperator.EmployeeId || _requestRepository.CurrentOperator.EmployeeTypeId == EmployeeTypes.Supervisor.GetHashCode()) ||
                                employee.EmployeeId == _requestRepository.CurrentOperator.EmployeeId
                                )
                            {
                                result = _employeeService.FillOperatorRelatedData(true, true, true);
                                if (result != GlobalErrors.Success) return JSonResultResponse.GetErrorJSon("Desc_Saving_Faild");
                                string tokenString = WorkExtension.GenerateToken(_requestRepository.CurrentOperator, HttpContext.Session.Id, employee.ExpirationDate);
                                string httpToken = this.Request.Headers["Authorization"].ToString();
                                if (!string.IsNullOrEmpty(httpToken) && !string.IsNullOrEmpty(tokenString))
                                {
                                    _activeTokens.DeleteActiveTokens(httpToken);
                                    _activeTokens.AddActiveTokens(tokenString);
                                }

                                if (!string.IsNullOrEmpty(tokenString))
                                {
                                    var savedEmployeeData = new
                                    {
                                        EmployeeId = employee.EmployeeId,
                                        tokenString = tokenString,
                                        currentOperator = _requestRepository.CurrentOperator,
                                        IsValid = isValid,
                                    };
                                    return JSonResultResponse.GetSuccessrJSon(savedEmployeeData, ResourcesManager.TranslateKey(MessagesConstants.Desc_Saved_Successfully, _requestRepository.LanguageId));
                                }
                                else
                                {
                                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey("Token Error", _requestRepository.LanguageId));
                                }
                            }
                            else
                            {
                                var savedEmployeeData = new
                                {
                                    EmployeeId = employee.EmployeeId,
                                    IsValid = isValid,
                                };
                                return JSonResultResponse.GetSuccessrJSon(savedEmployeeData, ResourcesManager.TranslateKey(MessagesConstants.Desc_Saved_Successfully, _requestRepository.LanguageId));

                            }
                        }
                        else
                        {
                            return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Saving, _requestRepository.LanguageId));
                        }
                    }
                    else
                    {
                        return JSonResultResponse.GetSuccessrJSon(data, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                    }
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Saving, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        #endregion

        #region DELETE


        #endregion

        #region METHODS
        //[HttpPost]
        //[ActionName("ValidateEmployeeToSave")]
        //public JsonResult ValidateEmployeeToSave([FromBody] EmployeeModel employee)
        //{
        //    try
        //    {
        //        bool isValid = true;
        //        string errorMessage = string.Empty;
        //        GlobalErrors result = _employeeService.ValidateEmployeeToSave(employee, ref isValid, ref errorMessage);
        //        var data = new
        //        {
        //            IsValid = isValid,
        //            ErrorMessage = errorMessage
        //        };
        //        if (result == GlobalErrors.Success)
        //        {
        //            return JSonResultResponse.GetSuccessrJSon(data, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
        //        }
        //        else
        //        {
        //            return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Saving, _requestRepository.LanguageId));
        //        }
        //    }
        //    catch (Exception ex)
        //    {
        //        ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
        //        return JSonResultResponse.GetErrorJSon();
        //    }
        //}
        #endregion

       
    }

}