﻿using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Mvc;
using Newtonsoft.Json;
using Sonic.Web.DAL;
using Sonic.Web.Licensing.Licensing;
using Sonic.Web.Model;
using Sonic.Web.Model.General;
using Sonic.Web.Model.MasterData;
using Sonic.Web.Models;
using Sonic.Web.PL.SystemModels;
using Sonic.Web.Resources;
using Sonic.Web.Service;
using System;
using System.Collections.Generic;
using System.Dynamic;
using System.Reflection;

namespace Sonic.Web.PL.Controllers
{
    [Route("api/[controller]/[action]")]
    [Authorize]
    public class ExcelSheetTemplatesController : BaseController
    {
        private readonly IRequestRepository _requestRepository;
        private readonly SettingService _settingService;
        public ExcelSheetTemplatesController(IRequestRepository requestRepository, ILicensing licensing, IActiveTokens activeToken) : base(requestRepository, licensing, activeToken)
        {
            _requestRepository = requestRepository;
            _settingService = new SettingService(requestRepository);
        }
        #region GET

        [HttpPost]
        [ActionName("GetExcelSheetDynamicTemplateListSharedTable")]
        public JsonResult GetExcelSheetDynamicTemplateListSharedTable([FromBody] GeneralFilter filter)
        {
            try
            {
                SharedTableResult<ExcelSheetDynamicTemplateModel> excelSheetTemplatesListTable = new SharedTableResult<ExcelSheetDynamicTemplateModel>();
                GlobalErrors result = _settingService.GetExcelSheetDynamicTemplateListSharedTable(filter, ref excelSheetTemplatesListTable);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(excelSheetTemplatesListTable, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else if (result == GlobalErrors.NoMoreRows)
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_No_Data_Found, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpPost]
        [ActionName("GetExcelSheet")]
        public JsonResult GetExcelSheetSharedTable([FromBody] ExcelSheetDynamicTemplateModel templateObject)
        {
            List<ExcelSheetDynamicTemplateModel> excelSheetlistSharedTable = new List<ExcelSheetDynamicTemplateModel>();
            try
            {
                GlobalErrors result = GlobalErrors.NotInitialized;
                result = _settingService.GetExcelSheetSharedTable(templateObject, ref excelSheetlistSharedTable);
                if (result == GlobalErrors.Success)
                {

                    return JSonResultResponse.GetSuccessrJSon(excelSheetlistSharedTable, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpPost]
        [ActionName("GetExcelSheetTemplateData")]
        public JsonResult GetExcelSheetTemplateData([FromBody] ExcelSheetDynamicTemplateModel excelTemplate)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {

                var excelSheetTemplate = new ExcelSheetDynamicTemplateModel();
                result = _settingService.GetExcelSheetTemplateData(excelTemplate, ref excelSheetTemplate);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(excelSheetTemplate, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.MessageErrorHappened, _requestRepository.LanguageId));
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        #endregion

        #region INSERT

        [HttpPost]
        [ActionName("InsertExcelSheetDynamicTemplate")]
        public JsonResult InsertExcelSheetDynamicTemplate([FromBody] ExcelSheetDynamicTemplateModel templateObject)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                result = _settingService.InsertExcelSheetDynamicTemplate(templateObject);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(true, ResourcesManager.TranslateKey(MessagesConstants.Desc_Saved_Successfully, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.MessageErrorHappened, _requestRepository.LanguageId));
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        [HttpPost]
        [ActionName("UpdateExcelSheetDynamicTemplate")]
        public JsonResult UpdateExcelSheetDynamicTemplate([FromBody] ExcelSheetDynamicTemplateModel templateObject)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                result = _settingService.UpdateExcelSheetDynamicTemplate(templateObject);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(true, ResourcesManager.TranslateKey(MessagesConstants.Desc_Saved_Successfully, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.MessageErrorHappened, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        #endregion

        #region DELETE
        [HttpPost]
        [ActionName("DeleteExcelSheetData")]
        public JsonResult DeleteExcelSheetData([FromBody] ExcelSheetDynamicTemplateModel templateObject)
        {
            try
            {
                string errorMessage = string.Empty;
                var result = _settingService.DeleteExcelSheetData(templateObject.VendorId, templateObject.ExcelSheetTypeId, ref errorMessage);
                if (result == GlobalErrors.Success)
                {

                    return JSonResultResponse.GetSuccessrJSon(true, ResourcesManager.TranslateKey(MessagesConstants.Desc_Delete_Successfully, _requestRepository.LanguageId));
                }
                else
                {
                    if (string.IsNullOrEmpty(errorMessage))
                    {
                        return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.MessageErrorHappened, _requestRepository.LanguageId));
                    }
                    else
                    {
                        return JSonResultResponse.GetErrorJSon(errorMessage);
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        #endregion
    }
}
