﻿using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Hosting;
using Microsoft.AspNetCore.Mvc;
using Sonic.Web.DAL;
using Sonic.Web.Licensing.Licensing;
using Sonic.Web.Model;
using Sonic.Web.PL.SystemModels;
using Sonic.Web.Resources;
using Sonic.Web.Service;
using System;
using System.Collections.Generic;
using System.Reflection;

namespace Sonic.Web.PL.Controllers
{
    [Route("api/[controller]/[action]")]
    [Authorize]
    public class HeaderDiscountController : BaseController
    {
        private readonly IRequestRepository _requestRepository;
        private readonly PricesAndOffersService _pricesAndOffersService;
        private readonly IHostingEnvironment _hostingEnvironment;
        private readonly IWebHostEnvironment _webHostEnvironment;

        public HeaderDiscountController(IRequestRepository requestRepository,
        IWebHostEnvironment webHostEnvironment, ILicensing licensing, IActiveTokens activeTokens)
            : base(requestRepository, licensing, activeTokens)
        {
            _requestRepository = requestRepository;
            _pricesAndOffersService = new PricesAndOffersService(null, requestRepository, _hostingEnvironment);
            _webHostEnvironment = webHostEnvironment;
        }

        #region GET

        [HttpPost]
        [ActionName("GetHeaderDiscounts")]
        public JsonResult GetHeaderDiscounts([FromBody] GeneralFilter filter)
        {
            try
            {
                SharedTableResult<HeaderDiscountModel> Headerdiscounts = new SharedTableResult<HeaderDiscountModel>();
                GlobalErrors result = _pricesAndOffersService.GetHeaderDiscounts(filter, ref Headerdiscounts);

                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(Headerdiscounts, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpPost]
        [ActionName("GetHeaderDiscountData")]
        public JsonResult GetHeaderDiscountData([FromBody] int headerDiscountId)
        {
            try
            {
                List<CustomerChannelModel> appliedChannels = new List<CustomerChannelModel>();
                List<CustomerGroupModel> appliedGroups = new List<CustomerGroupModel>();
                List<SimpleCustomerModel> appliedCustomers = new List<SimpleCustomerModel>();
                GlobalErrors result = _pricesAndOffersService.GetHeaderDiscountAppliedChannels(headerDiscountId, ref appliedChannels);
                if (result == GlobalErrors.Success)
                    result = _pricesAndOffersService.GetHeaderDiscountAppliedGroups(headerDiscountId, ref appliedGroups);
                if (result == GlobalErrors.Success)
                    result = _pricesAndOffersService.GetHeaderDiscountAppliedCustomers(headerDiscountId, ref appliedCustomers);
                if (result == GlobalErrors.Success)
                {
                    var data = new
                    {
                        appliedChannels = appliedChannels,
                        appliedGroups = appliedGroups,
                        appliedCustomers = appliedCustomers,
                    };
                    return JSonResultResponse.GetSuccessrJSon(data, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpPost]
        [ActionName("GetSalesMode")]
        public JsonResult GetSalesMode()
        {
            try
            {
                List<SalesModeModel> SalesMode = new List<SalesModeModel>();

                GlobalErrors result = _pricesAndOffersService.GetSalesMode(ref SalesMode);

                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(SalesMode, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }


        #endregion

        #region INSERT
        [HttpPost]
        [ActionName("InsertHeaderDiscount")]
        public JsonResult InsertHeaderDiscount([FromBody] HeaderDiscountModel HeaderDiscountObj)
        {
            try
            {
                
                var result = _pricesAndOffersService.SaveHeaderDiscount(HeaderDiscountObj);

                if (result == GlobalErrors.Success)
                {
                    var data = new
                    {
                        HeaderDiscountId = HeaderDiscountObj.HeaderDiscountId,
                    };
                    return JSonResultResponse.GetSuccessrJSon(data, ResourcesManager.TranslateKey(MessagesConstants.Desc_Saved_Successfully, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Saving, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        #endregion

        #region UPDATE
        [HttpPost]
        [ActionName("UpdateHeaderDiscount")]
        public JsonResult UpdateHeaderDiscount([FromBody] HeaderDiscountModel HeaderDiscountObj)
        {
            try
            {

                var  result = _pricesAndOffersService.SaveHeaderDiscount(HeaderDiscountObj);

                if (result == GlobalErrors.Success)
                {
                    var data = new
                    {
                        HeaderDiscountID = HeaderDiscountObj.HeaderDiscountId,
                    };
                    return JSonResultResponse.GetSuccessrJSon(data, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Update_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_Update_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        #endregion

        #region DELETE
        [HttpPost]
        [ActionName("DeleteHeaderDiscount")]
        public JsonResult DeleteHeaderDiscount([FromBody] int HeaderDiscountId)
        {
            try
            {
                GlobalErrors result = _pricesAndOffersService.DeleteHeaderDiscount(HeaderDiscountId);

                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(result, ResourcesManager.TranslateKey(MessagesConstants.Desc_Deleted_Successfully, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Delete_Failed, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        #endregion

    }
}
