﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Net.Http.Headers;
using System.Reflection;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Hosting;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Sonic.Web.DAL;
using Sonic.Web.Licensing;
using Sonic.Web.Licensing.Licensing;
using Sonic.Web.Model;
using Sonic.Web.PL.SystemModels;
using Sonic.Web.Resources;
using Sonic.Web.Service;

namespace Sonic.Web.PL.Controllers
{
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class ImageController : BaseController
    {
        private IHostingEnvironment _hostingEnvironment;
        private readonly IRequestRepository _requestRepository;

        public ImageController(IHostingEnvironment hostingEnvironment, IRequestRepository requestRepository, ILicensing licensing, IActiveTokens activeToken) : base(requestRepository, licensing, activeToken)
        {
            _requestRepository = requestRepository;
            _hostingEnvironment = hostingEnvironment;
        }

        [HttpPost]
        [ActionName("UploadImage")]
        public JsonResult UploadImage()
        {
            try
            {
                var file = Request.Form.Files[0];
                string folderName = "ClientApp\\src\\assets\\img\\users-img";
                string distFolderName = "ClientApp\\dist\\assets\\img\\users-img";
                string rootPath = _hostingEnvironment.ContentRootPath;
         
                string newPath = Path.Combine(rootPath, folderName);
                string distNewPath = Path.Combine(rootPath, distFolderName);
                if (!Directory.Exists(newPath))
                {
                    Directory.CreateDirectory(newPath);
                }
                if (!Directory.Exists(distNewPath))
                {
                    Directory.CreateDirectory(distNewPath);
                }
                if (file.Length > 0)
                {
                    string fileName = _requestRepository.CurrentOperator.EmployeeCode+".jpg";// ContentDispositionHeaderValue.Parse(file.ContentDisposition).FileName.Trim('"');
                    string fullPath = Path.Combine(newPath, fileName);
                    using (var stream = new FileStream(fullPath, FileMode.Create))
                    {
                        file.CopyTo(stream);
                    }

                    fullPath = Path.Combine(distNewPath, fileName);
                    using (var stream = new FileStream(fullPath, FileMode.Create))
                    {
                        file.CopyTo(stream);
                    }

                }
                return JSonResultResponse.GetSuccessrJSon(true, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Update_Data, _requestRepository.LanguageId));
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        [HttpGet]
        [ActionName("Test")]
        public JsonResult Test()
        {
            try
            {
                return JSonResultResponse.GetSuccessrJSon(true, "Success Getting List");
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
    }
}