﻿using ClosedXML.Excel;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Newtonsoft.Json;
using Sonic.Web.Core;
using Sonic.Web.DAL;
using Sonic.Web.Licensing.Licensing;
using Sonic.Web.Model;
using Sonic.Web.Models;
using Sonic.Web.PL.SystemModels;
using Sonic.Web.Resources;
using Sonic.Web.Service;
using System;
using System.Collections.Generic;
using System.Data;
using System.IO;
using System.Reflection;
using System.Text;

namespace Sonic.Web.PL.Controllers
{
    [Route("api/[controller]/[action]")]
    [Authorize]
    public class ImportController : BaseController
    {

        private readonly IRequestRepository _requestRepository;
        private readonly ImportService _importService;
        public ImportController(IRequestRepository requestRepository, ILicensing licensing, IActiveTokens activeToken) : base(requestRepository, licensing,activeToken)
        {
            _requestRepository = requestRepository;
            _importService = new ImportService(_requestRepository);
        }

        [HttpPost]
        [ActionName("DownloadFile")]
        public IActionResult DownloadFile(int fileType)
        {
            try
            {
                if (string.IsNullOrEmpty(fileType.ToString()))
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
                var memory = new MemoryStream();
                string contentType = string.Empty;
                string fileName = string.Empty;
                GlobalErrors result = ImportManager.DownloadFile((ImportDataTypes)fileType, ref contentType, ref fileName, ref memory);
                if (result == GlobalErrors.Success && memory != null)
                {
                    return File(memory, contentType, fileName);
                }
                else
                {
                    return null;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return null;
            }
        }

        [HttpPost]
        [ActionName("ImportFile")]
        public JsonResult ImportFile([FromForm] IFormFile file, [FromForm] int importDataTypeId, [FromForm] int entryFormId)
        {
            try
            {
                int importedRecordsCount = 0;
                int notImportedRecordsCount = 0;
                bool isValid = true;
                List<dynamic> items = null;
                List<ImportedExcelErrorModel> importedExcelErrors = new List<ImportedExcelErrorModel>();
                List<ImportErrorData> importErrorDataModel = new List<ImportErrorData>();
                var path = Path.Combine(
                 Directory.GetCurrentDirectory(), "wwwroot",
                 file.FileName);
                // Delete the file if it exists.
                if (System.IO.File.Exists(path))
                {
                    System.IO.File.Delete(path);
                }
                using (var stream = new FileStream(path, FileMode.Create))
                {
                    file.CopyTo(stream);
                }
                string errorMessage = string.Empty;
                
                GlobalErrors result = _importService.ImportFromExcelSheet((ImportDataTypes)importDataTypeId,path,ref importedRecordsCount, ref notImportedRecordsCount,ref items, ref isValid, ref importedExcelErrors, ref errorMessage, entryFormId,ref importErrorDataModel);
                if (result == GlobalErrors.Success)
                {
                    if (System.IO.File.Exists(path))
                    {
                        System.IO.File.Delete(path);
                    }
                    var data = new
                    {
                        importedRecordsCount = importedRecordsCount,
                        notImportedRecordsCount = notImportedRecordsCount,
                        isValid = isValid,
                        itemsList = items,
                        importedExcelErrors = importedExcelErrors,
                        importErrorsData = importErrorDataModel
                    };
                    return JSonResultResponse.GetSuccessrJSon(data,ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else if (result == GlobalErrors.SomeInvalidPrices){
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_The_End_Range_Must_Be_Larger_Than_Start_Range, _requestRepository.LanguageId));
                }
                else if (result == GlobalErrors.DataAlreadyExists && importDataTypeId != ImportDataTypes.MustSellItems.GetHashCode() && importDataTypeId != ImportDataTypes.CustomerPromotion.GetHashCode() && importDataTypeId != ImportDataTypes.ExcludeCustomerPromotion.GetHashCode() && importDataTypeId != (int)ImportDataTypes.CustomerOutletPromotion && importDataTypeId != (int)ImportDataTypes.ExcludeCustomerOutletPromotion) 
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Duplicate_Packs, _requestRepository.LanguageId));
                }else if(result == GlobalErrors.DataAlreadyExists && importDataTypeId == ImportDataTypes.MustSellItems.GetHashCode())
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Duplicate_Items, _requestRepository.LanguageId));
                }else if (result == GlobalErrors.DataAlreadyExists && (importDataTypeId == ImportDataTypes.CustomerPromotion.GetHashCode() || importDataTypeId == (int)ImportDataTypes.CustomerOutletPromotion))
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Duplicate_Records, _requestRepository.LanguageId));

                }
                else if (result == GlobalErrors.DataAlreadyExists && (importDataTypeId == ImportDataTypes.ExcludeCustomerPromotion.GetHashCode() || importDataTypeId == (int)ImportDataTypes.ExcludeCustomerOutletPromotion))
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Duplicate_Records, _requestRepository.LanguageId));

                }
                else
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(string.IsNullOrEmpty(errorMessage) ? MessagesConstants.Desc_Error_While_Saving : errorMessage, _requestRepository.LanguageId));
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }


        #region[Import From AppData Screens]
        [HttpPost]
        [ActionName("DownloadDynamicExcelTemplate")] 
        public IActionResult DownloadDynamicExcelTemplate(int entryFormId)
        {
            try
            {
                string errorMessage = string.Empty;
                MemoryStream memory = new MemoryStream();
                string contentType = string.Empty;
                string fileName = string.Empty;

                GlobalErrors result = _importService.DownloadDynamicExcelTemplate(entryFormId, ref errorMessage, ref contentType, ref fileName, ref memory);
                if (result == GlobalErrors.Success && memory != null)
                {
                    return File(memory, contentType, fileName);
                }
                else
                {
                    return null;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return null;
            }
        }
        #endregion
    }
}
