﻿using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Hosting;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Newtonsoft.Json;
using Sonic.Web.Core;
using Sonic.Web.DAL;
using Sonic.Web.Licensing.Licensing;
using Sonic.Web.Model;
using Sonic.Web.Models;
using Sonic.Web.PL.SystemModels;
using Sonic.Web.Resources;
using Sonic.Web.Service;
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Diagnostics;
using System.IO;
using System.Linq;
using System.Reflection;
using Sonic.Web.PL.Helper;

namespace Sonic.Web.PL.Controllers
{
    [Route("api/[controller]/[action]")]
    [Authorize]
    public class ItemController : BaseController
    {

        private readonly IRequestRepository _requestRepository;
        private IHostingEnvironment _hostingEnvironment;
        private readonly ItemService _itemService;
        private readonly MasterDataService _masterDataService;
        private readonly EmployeeService _employeeService;

        public ItemController(IHostingEnvironment hostingEnvironment, IRequestRepository requestRepository, ILicensing licensing, IActiveTokens activeToken) : base(requestRepository, licensing, activeToken)
        {
            _hostingEnvironment = hostingEnvironment;
            _requestRepository = requestRepository;
            _itemService = new ItemService(_requestRepository);
            _masterDataService = new MasterDataService(requestRepository);
            _employeeService = new EmployeeService(_requestRepository);
        }

        //[HttpPost]
        //[ActionName("FillItemImages")]
        //public JsonResult FillItemImages()
        //{
        //    try
        //    {
        //        GlobalErrors result = _itemService.FillItemsImages(_hostingEnvironment.WebRootPath);
        //        if (result == GlobalErrors.Success)
        //        {
        //            return JSonResultResponse.GetSuccessrJSon();
        //        }
        //        else
        //        {
        //            return JSonResultResponse.GetErrorJSon();
        //        }
        //    }
        //    catch (Exception ex)
        //    {
        //        ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
        //        return JSonResultResponse.GetErrorJSon();
        //    }
        //}

        //[HttpPost]
        //[ActionName("saveItem")]
        //public JsonResult saveItem([FromBody] ItemPackModel itemPackModel)
        //{
        //    GlobalErrors result = GlobalErrors.NotInitialized;
        //    try
        //    {
        //        bool isCodeExist = false;
        //        result = _itemService.CheckCodeIsExist("item","ItemCode",itemPackModel.ItemCode,"ItemId",-1,ref isCodeExist);
        //        if (result == GlobalErrors.Success)
        //        {
        //            if (isCodeExist)
        //            {
        //                return JSonResultResponse.GetErrorJSon("Desc_Unique_Code");
        //            }
        //            result = _itemService.saveItemPack(itemPackModel);
        //        }
        //        if (result == GlobalErrors.Success)
        //        {
        //            return JSonResultResponse.GetSuccessrJSon();
        //        }
        //        else 
        //        {
        //            return JSonResultResponse.GetErrorJSon();
        //        }
        //    }
        //    catch (Exception ex)
        //    {
        //        ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
        //        return JSonResultResponse.GetErrorJSon();
        //    }
        //}

        [HttpPost]
        [ActionName("GetAllItems")]
        public JsonResult GetAllItems([FromBody] GeneralFilter itemsFilter)
        {
            try
            {
                SharedTableResult<ItemPackModel> itemList = new SharedTableResult<ItemPackModel>();
                //GeneralFilter generalFilter = JsonConvert.DeserializeObject<GeneralFilter>(itemsFilter);
                GlobalErrors result = _itemService.GetAllItems(itemsFilter, ref itemList);

                if (result == GlobalErrors.Success)
                {
                    if (itemList != null && itemList.Data != null && itemList.Data.ToList().Count > 0)
                    {
                        return JSonResultResponse.GetSuccessrJSon(itemList, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                    }
                    else
                    {
                        return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_No_Data_Found, _requestRepository.LanguageId));
                    }
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        [HttpPost]
        [ActionName("GetAllItemsForItemsLists")]
        public JsonResult GetAllItemsForItemsLists([FromBody] ItemPackModel allItems)
        {
            try
            {
                List<ItemPackModel> itemList = new List<ItemPackModel>();
                //GeneralFilter generalFilter = JsonConvert.DeserializeObject<GeneralFilter>(paginateSetting);
                GlobalErrors result = _itemService.GetAllItemsForItemsLists(ref itemList, allItems.DivisionId, allItems.BrandId, allItems.ItemCategoryId, allItems.PaginateSetting);

                if (result == GlobalErrors.Success)
                {
                    if (itemList != null && itemList.Count > 0)
                    {
                        return JSonResultResponse.GetSuccessrJSon(itemList, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                    }
                    else
                    {
                        return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_No_Data_Found, _requestRepository.LanguageId));
                    }
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpPost]
        [ActionName("GetAllItemsLazyLoading")]
        public JsonResult GetAllItemsLazyLoading([FromBody] GeneralFilter filter)
        {
            try
            {
                SharedTableResult<ItemPackModelSimple> itemListTable = new SharedTableResult<ItemPackModelSimple>();
                //GeneralFilter filter = JsonConvert.DeserializeObject<GeneralFilter>(itemsFilter);
                GlobalErrors result = _itemService.GetItemsLazyLoading(filter, ref itemListTable);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(itemListTable, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else if (result == GlobalErrors.NoMoreRows)
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_No_Data_Found, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        [HttpPost]
        [ActionName("GetSearchedItem")]
        public JsonResult GetSearchedItem([FromBody] GeneralFilter itemsFilter)
        {
            try
            {
                SharedTableResult<ItemPackModel> itemList = new SharedTableResult<ItemPackModel>();
                //GeneralFilter generalFilter = JsonConvert.DeserializeObject<GeneralFilter>(itemFilter);
                GlobalErrors result = _itemService.GetAllItems(itemsFilter, ref itemList);

                if (result == GlobalErrors.Success)
                {
                    if (itemList != null && itemList.Data != null && itemList.Data.ToList().Count > 0)
                    {
                        return JSonResultResponse.GetSuccessrJSon(itemList.Data.First(), ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                    }
                    else
                    {
                        return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_No_Data_Found, _requestRepository.LanguageId));
                    }
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        #region [Prices]

        [HttpPost]
        [ActionName("GetPriceList")]
        public JsonResult GetPriceList([FromBody] GeneralFilter filter)
        {
            try
            {
                Stopwatch st = new Stopwatch();
                st.Start();

                List<PriceModel> itemList = new List<PriceModel>();
                GlobalErrors result = _itemService.GetPriceList(filter, ref itemList);

                st.Stop();
                long i = st.ElapsedMilliseconds;

                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(itemList, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        #endregion [Prices]



        [HttpGet]
        [ActionName("GetAllActiveItems")]
        public JsonResult GetAllActiveItems()
        {
            try
            {
                List<ItemPackModel> itemsList = new List<ItemPackModel>();

                var result = _itemService.GetAllActiveItems(ref itemsList);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(itemsList, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpGet]
        [ActionName("InitiateSearchList")]
        public JsonResult InitiateSearchList()
        {
            try
            {
                var divisionsList = new List<DivisionModel>();
                GlobalErrors err = GlobalErrors.NotInitialized;
                DivisionFilter filter = new DivisionFilter();
                err = _itemService.GetAllDivisions(filter, ref divisionsList);
                if (err != GlobalErrors.Success)
                {
                    return JSonResultResponse.GetErrorJSon(MessagesConstants.Desc_Error_While_Getting_Data);
                }
                List<ItemCategoryModel> categoryList = new List<ItemCategoryModel>();
                err = _itemService.GetItemCategoryList(ref categoryList);
                if (err != GlobalErrors.Success)
                {
                    return JSonResultResponse.GetErrorJSon(MessagesConstants.Desc_Error_While_Getting_Data);
                }

                var data = new
                {
                    divisionList = divisionsList,
                    categoryList = categoryList
                };
                if (err == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(data, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_No_Data_Found, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpPost]
        [ActionName("GetDivisionCategories")]
        public JsonResult GetDivisionCategories([FromBody] ItemCategoryFilter filter)
        {
            try
            {
                var data = new List<CategoryModel>();
                string message = ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId);
                GlobalErrors result = _itemService.GetAlllCategories(filter, ref data);
                if (result != GlobalErrors.Success)
                {
                    message = ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId);
                    return JSonResultResponse.GetErrorJSon(message);
                }
                else
                    return JSonResultResponse.GetSuccessrJSon(data, message);
            }
            catch (Exception ex)
            {
                return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
            }
        }

        public static byte[] ReadFully(Stream input)
        {
            byte[] buffer = new byte[16 * 1024];
            using (MemoryStream ms = new MemoryStream())
            {
                int read;
                while ((read = input.Read(buffer, 0, buffer.Length)) > 0)
                {
                    ms.Write(buffer, 0, read);
                }
                return ms.ToArray();
            }
        }



        [HttpPost]
        [ActionName("getGroupPacks")]
        public JsonResult getGroupPacks([FromBody] int groupID)
        {
            try
            {
                List<PackModel> packs = new List<PackModel>();
                GlobalErrors result = _itemService.getGroupPacks(groupID, ref packs);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(packs, "");
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon("");
                }
            }
            catch (Exception ex)
            {
                return JSonResultResponse.GetErrorJSon("");
            }
        }

        [HttpGet]
        [ActionName("GetAllPacks")]
        public JsonResult GetAllPacks()
        {
            try
            {
                List<PackModel> packs = new List<PackModel>();
                string message = "Success Getting Items";
                GlobalErrors result = _itemService.GetAllPacks(ref packs);

                if (result != GlobalErrors.Success)
                    return JSonResultResponse.GetErrorJSon("Error in Getting Items");

                //List<ItemsModel> itemCode = new List<ItemsModel>();
                //GlobalErrors resultCode = ItemService.GetAllItemCode(ref itemCode, 1);

                //if (result != GlobalErrors.Success)
                //    return JSonResultResponse.GetErrorJSon("Error in Getting Items");

                //var data = new
                //{
                //    itemName = itemName,
                //    itemCode = itemCode,

                //};
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(packs, "");
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon("Error in Getting Items");
                }
            }
            catch (Exception ex)
            {
                return JSonResultResponse.GetErrorJSon("Error in Getting Items");
            }
        }




        [HttpPost]
        [ActionName("getItemsLists")]
        public JsonResult getItemsLists([FromBody] ItemListModel item)
        {
            try
            {
                List<ItemListModel> data = new List<ItemListModel>();
                //GeneralFilter generalFilter = JsonConvert.DeserializeObject<GeneralFilter>(item.Filter);
                GlobalErrors result = _itemService.getItemsLists(item.ItemListTypeId, item.Filter, ref data);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(data, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.MessageErrorHappened, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpPost]
        [ActionName("getItemsListData")]
        public JsonResult getItemsListData([FromBody] ItemListModel itemData)
        {
            try
            {
                ItemListModel itemListdata = new ItemListModel();
                var result = _itemService.getItemsListData(itemData.ItemListId, itemData.ItemListTypeId, ref itemListdata, itemData.OOSListMode);
                if (result == GlobalErrors.Success)
                {
                    var data = new
                    {

                        languageDescriptions = itemListdata.DescriptionLanguages,
                        appliedChannels = itemListdata.AppliedChannels,
                        appliedGroups = itemListdata.AppliedGroups,
                        appliedCustomers = itemListdata.AppliedCustomers,
                        appliedEmployees = itemListdata.AppliedEmployees,
                        appliedSecurityGroups = itemListdata.AppliedSecurityGroups,
                        items = itemListdata.items,
                        allCustomers = itemListdata.AllCustomers,
                        allEmployees = itemListdata.AllEmployees,
                        appliedOrganizations = itemListdata.AppliedOrganizations
                    };
                    return JSonResultResponse.GetSuccessrJSon(data, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.MessageErrorHappened, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        [HttpPost]
        [ActionName("GetAllItemsNew")]
        public JsonResult GetAllItemsNew([FromBody] ItemsFilter filter)
        {
            try
            {
                GlobalErrors result = GlobalErrors.NotInitialized;
                List<ItemPackModel> itemslist = new List<ItemPackModel>();
                List<ItemStockBatches> itemsStock = new List<ItemStockBatches>();
                List<ROIPackModel> roiPackList = new List<ROIPackModel>();
                List<PriceRangeModel> priceRangeList = new List<PriceRangeModel>();
                string warehouseIds = string.Empty;
                if (filter.TransactionMainTypes == TransactionMainTypes.CustomerTransaction)
                {
                    if (filter.ProcessMode == ItemFormProcessMode.ConsignmentOrder && filter.CustomerId != -1 && filter.OutletId <= 0)
                    {
                        filter.OutletId = CustomerManager.GetMainOutletID(filter.CustomerId);
                        if (filter.OutletId == -1)
                            filter.OutletId = 1;
                    }
                    if (filter.CustomerId <= 0 || filter.OutletId <= 0)
                    {
                        return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_No_Data_Found, _requestRepository.LanguageId));
                    }
                    if (filter.ProcessMode == ItemFormProcessMode.Orders && filter.RequestedBy != -1)
                    {
                        result = OrderManager.GetLoadingWarehousesForEmployeeAsString(filter.RequestedBy, null, ref warehouseIds);
                    }
                    if (filter.ProcessMode == ItemFormProcessMode.ExchangeReturn && _requestRepository.Configurations.LimitBOSalesToWarehouseStock && _requestRepository.Configurations.RestoreBOReturnToWarehouse)
                    {
                        warehouseIds = filter.RefWarehouseId.ToString();
                    }
                    result = _itemService.GetAllItemsWithCustomerOperations(filter.DivisionId, filter.StockWarehouseId, filter.CustomerId, filter.OutletId, filter.ProcessMode, ref itemslist, ref itemsStock,ref priceRangeList, filter.IncludeTax, filter.EditedTransactionItemIds, filter.EditedTransactionPackIds, filter.OrderSignature, warehouseIds, filter.ExcludedOrderId, filter.ShowQuantityInOrder, filter.OrderTypeId, filter.RestrictReturnFromInvoices,filter.SDCId , filter.RequestedBy);
                }
                else
                {
                    result = _itemService.GetAllItemsWarehouseOperations(filter.SelectedEmployeeId, filter.DivisionId, filter.StockWarehouseId, filter.DetailsWarehouseId, filter.RefWarehouseId, filter.ProcessMode, ref itemslist, ref itemsStock, ref priceRangeList, filter.EditedTransactionId, filter.Status, filter.EditedTransactionItemIds, filter.EditedTransactionPackIds, filter.VendorId, filter.IsQualityControl, filter.AllowAddingNewItems, filter.IsExecuteOperation, filter.RequestedBy, string.Empty, string.Empty, ref roiPackList, filter.SsccBarcode, filter.IsFullyOffload);
                }

                if (result == GlobalErrors.Success)
                {
                    var data = new
                    {
                        Itemslist = itemslist,
                        ItemsStock = itemsStock,
                        roiPackList = roiPackList,
                        priceRangeList = priceRangeList
                    };
                    return JSonResultResponse.GetSuccessrJSon(data, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpPost]
        [ActionName("GetPacksHierarchy")]
        public JsonResult GetPacksHierarchy([FromBody] ItemsFilter filter)
        {
            try
            {

                GlobalErrors result = GlobalErrors.NotInitialized;
                ItemPackModel pack = new ItemPackModel();
                pack.PiecesInPack = filter.PiecesInPack;
                pack.ItemId = filter.ItemId;
                pack.ChildPackId = filter.ChildPackId;
                result = _itemService.GetPacksHierarchy(filter.CustomerId, filter.OutletId, ref pack);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(pack, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        [HttpPost]
        [ActionName("GetFieldsStartAndEndIndexTemplate")]
        public JsonResult GetFieldsStartAndEndIndexTemplate([FromBody] int templateId)
        {
            try
            {
                GlobalErrors result = GlobalErrors.NotInitialized;
                ItemPackModel pack = new ItemPackModel();
                pack.TemplateId = templateId;
                result = _itemService.GetGS1TemplateDetail(templateId, ref pack);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(pack, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpPost]
        [ActionName("GetPackItemsWithPrice")]
        public JsonResult GetPackItemsWithPrice([FromBody] GeneralFilter filter)
        {
            var result = GlobalErrors.NotInitialized;
            var items = new List<ItemPackModel>();
            var name = string.Empty;
            try
            {
                result = _itemService.GetPackItemsWithPrice(filter.CustomerId, filter.OutletId, filter.PackGroupId, ref items, filter.IncludeTax, filter.IsSkipPromotion);
                if (result == GlobalErrors.Success)
                {
                    result = _itemService.GetPackGroupName(filter.PackGroupId, ref name);
                }
                if (result == GlobalErrors.Success)
                {
                    var packGroupData = new
                    {
                        PackGroupItems = items,
                        packGroupNames = name
                    };
                    return JSonResultResponse.GetSuccessrJSon(packGroupData, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }

            }
            catch (Exception ex)
            {
                return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
            }
        }



        [HttpPost]
        [ActionName("GetAllVendors")]
        public JsonResult GetAllVendors([FromBody] GeneralFilter filter)
        {
            try
            {
                List<VendorModel> vendorList = new List<VendorModel>();
                GlobalErrors result = _itemService.GetAllVendors(filter.IncludeInactive, ref vendorList);

                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(vendorList, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
            }
        }

        #region[Item Definition]

        [HttpGet]
        [ActionName("GetPackTypesList")]
        public JsonResult GetPackTypesList()
        {
            try
            {
                List<PackTypeModel> itemPack = new List<PackTypeModel>();
                var result = _itemService.GetPackTypeList(ref itemPack);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(itemPack, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        [HttpGet]
        [ActionName("GetPackType")]
        public JsonResult GetPackTypeOfPackGroup()
        {
            try
            {
                List<PackTypeModel> itemPack = new List<PackTypeModel>();
                var result = _itemService.GetPackTypeOfPackGroup(ref itemPack);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(itemPack, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        [HttpGet]
        [ActionName("GetKPIPackTypes")]
        public JsonResult GetKPIPackTypes()
        {
            try
            {
                List<PackTypeModel> itemPack = new List<PackTypeModel>();
                var result = _itemService.GetKPIPackTypes(ref itemPack);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(itemPack, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        [HttpPost]
        [ActionName("UpdateItemFromActiveToInactive")]
        public JsonResult UpdateItemFromActiveToInactive([FromBody] int itemId)
        {
            try
            {
                if (!ModelState.IsValid)
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Provide_UserName_Password, _requestRepository.LanguageId));
                }
                GlobalErrors result = _itemService.UpdateItemActiveStatus(itemId, true);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(result, ResourcesManager.TranslateKey(MessagesConstants.Desc_Saved_Successfully, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.MessageErrorHappened, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpPost]
        [ActionName("UpdateItemFromInactiveToActive")]
        public JsonResult UpdateItemFromInactiveToActive([FromBody] int promotionId)
        {
            try
            {
                if (!ModelState.IsValid)
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Provide_UserName_Password, _requestRepository.LanguageId));
                }
                GlobalErrors result = _itemService.UpdateItemActiveStatus(promotionId, false);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(result, ResourcesManager.TranslateKey(MessagesConstants.Desc_Saved_Successfully, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.MessageErrorHappened, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpPost]
        [ActionName("SetAsNewSelectedItems")]
        public JsonResult SetAsNewSelectedItems([FromBody] ItemAction itemAction)
        {
            try
            {
                if (!ModelState.IsValid)
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Provide_UserName_Password, _requestRepository.LanguageId));
                }

                GlobalErrors result = _itemService.UpdateSelectedItemsProperities(itemAction);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(result, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Update_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_Update_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpPost]
        [ActionName("SetAsPowerSKUSelectedItems")]
        public JsonResult SetAsPowerSKUSelectedItems([FromBody] ItemAction itemAction)
        {
            try
            {
                if (!ModelState.IsValid)
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Provide_UserName_Password, _requestRepository.LanguageId));
                }

                GlobalErrors result = _itemService.UpdateSelectedItemsProperities(itemAction);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(result, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Update_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_Update_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpPost]
        [ActionName("SetAsInitiativeSelectedItems")]
        public JsonResult SetAsInitiativeSelectedItems([FromBody] ItemAction itemAction)
        {
            try
            {
                if (!ModelState.IsValid)
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Provide_UserName_Password, _requestRepository.LanguageId));
                }

                GlobalErrors result = _itemService.UpdateSelectedItemsProperities(itemAction);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(result, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Update_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_Update_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpPost]
        [ActionName("IsPackValidToErase")]
        public JsonResult IsPackValidToErase([FromBody] int packId)
        {
            try
            {
                string msg = string.Empty;
                msg = _itemService.IsPackValidToDelete(packId);
                if (string.IsNullOrEmpty(msg))
                {
                    return JSonResultResponse.GetSuccessrJSon(true, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(msg, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        [HttpPost]
        [ActionName("GetItemData")]
        public JsonResult GetItemData([FromBody] int ItemId)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                ItemPackModel item = new ItemPackModel();
                item.ItemId = ItemId;
                result = _itemService.GetItemData(ItemId, ref item);
                if (result == GlobalErrors.Success)
                {
                    List<string> imagesNames = new List<string>();
                    List<string> attachementNames = new List<string>();
                    FileManagerModel model = new FileManagerModel();
                    string folderName = Path.Combine(LocalUtilities.ItemAttachFolderPath, ItemId.ToString());
                    string rootPath = _hostingEnvironment.ContentRootPath;
                    var userImagesPath = Path.Combine(rootPath, folderName);
                    DirectoryInfo dir = new DirectoryInfo(userImagesPath);
                    if (dir.Exists)
                    {
                        FileInfo[] files = dir.GetFiles();
                        model.Files = files;
                        if (files != null && files.Length > 0)
                        {
                            foreach (FileInfo file in files)
                            {
                                imagesNames.Add(file.Name);
                            }
                        }
                    }
                    if (imagesNames != null && imagesNames.Count > 0)
                    {
                        item.AttachmentList = imagesNames;
                    }
                }
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(item, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpPost]
        [ActionName("InsertOrUpdatePackType")]
        public JsonResult InsertOrUpdatePackType([FromBody] PackTypeModel packType)
        {
            try
            {
                GlobalErrors result = _itemService.SaveNewPackType(packType);

                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(packType.PackTypeId, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.MessageErrorHappened, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpGet]
        [ActionName("GetAllMasterGroup")]
        public JsonResult GetAllMasterGroup()
        {
            try
            {
                List<MasterItemGroupModel> masterGroupList = new List<MasterItemGroupModel>();
                var result = _itemService.GetAllMasterGroup(ref masterGroupList);

                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(masterGroupList, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                return JSonResultResponse.GetErrorJSon(ex.Message);
            }
        }

        [HttpGet]
        [ActionName("GetItemModel")]
        public JsonResult GetItemModel()
        {
            try
            {
                List<Item_Model> itemModel = new List<Item_Model>();
                GlobalErrors result = _itemService.GetItemModel(ref itemModel);

                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(itemModel, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }



        [HttpGet]
        [ActionName("GetItemTypes")]
        public JsonResult GetItemTypes()
        {
            try
            {
                List<ItemTypeModel> typesList = new List<ItemTypeModel>();
                GlobalErrors result = _itemService.GetItemTypes(ref typesList);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(typesList, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.MessageErrorHappened, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpPost]
        [ActionName("InsertItem")]
        public JsonResult InsertItem([FromForm] Collection<IFormFile> image, [FromForm] string item, [FromForm] Collection<IFormFile> attahcedImages)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                ItemPackModel itemPackModel = JsonConvert.DeserializeObject<ItemPackModel>(item);
                if (itemPackModel != null)
                {
                    string hostingEnvironment = _hostingEnvironment.ContentRootPath;
                    result = _itemService.SaveItem(itemPackModel, image, hostingEnvironment, attahcedImages);


                    if (result == GlobalErrors.Success)
                    {
                        return JSonResultResponse.GetSuccessrJSon(true, ResourcesManager.TranslateKey(MessagesConstants.Desc_Saved_Successfully, _requestRepository.LanguageId));
                    }
                    else if (result == GlobalErrors.CustomerAppPath)
                    {
                        return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.MessageErrorAppPath, _requestRepository.LanguageId));
                    }
                    else
                    {
                        return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.MessageErrorHappened, _requestRepository.LanguageId));
                    }
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.MessageErrorHappened, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        
        [HttpPost]
        [ActionName("UpdateItem")]
        public JsonResult UpdateItem([FromForm] Collection<IFormFile> image, [FromForm] string item, [FromForm] Collection<IFormFile> attahcedImages)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                ItemPackModel itemPackModel = JsonConvert.DeserializeObject<ItemPackModel>(item);
                if (itemPackModel != null)
                {
                    string hostingEnvironment = _hostingEnvironment.ContentRootPath;
                    result = _itemService.SaveItem(itemPackModel, image, hostingEnvironment, attahcedImages);

                    if (result == GlobalErrors.Success)
                    {
                        return JSonResultResponse.GetSuccessrJSon(true, ResourcesManager.TranslateKey(MessagesConstants.Desc_Saved_Successfully, _requestRepository.LanguageId));
                    }
                    else if (result == GlobalErrors.CustomerAppPath)
                    {
                        return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.MessageErrorAppPath, _requestRepository.LanguageId));
                    }
                    else
                    {
                        return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.MessageErrorHappened, _requestRepository.LanguageId));
                    }
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.MessageErrorHappened, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }



        [HttpPost]
        [ActionName("GetItemsListSharedTable")]
        public JsonResult GetItemsListSharedTable([FromBody] ItemsFilter filter)
        {
            try
            {
                SharedTableResult<ItemPackModel> itemList = new SharedTableResult<ItemPackModel>();
                GlobalErrors result = _itemService.GetItemsListSharedTable(filter, ref itemList);

                if (result == GlobalErrors.Success)
                {
                    if (itemList != null && itemList.Data != null && itemList.Data.ToList().Count > 0)
                    {
                        return JSonResultResponse.GetSuccessrJSon(itemList, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                    }
                    else
                    {
                        return JSonResultResponse.GetSuccessrJSon(itemList, ResourcesManager.TranslateKey(MessagesConstants.Desc_No_Data_Found, _requestRepository.LanguageId));
                    }
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpPost]
        [ActionName("UpdateItemsListIsNewExpireDate")]
        public JsonResult UpdateItemsListIsNewExpireDate([FromBody] List<ItemPackModel> itemList)
        {
            try
            {
                GlobalErrors result = _itemService.UpdateItemsListIsNewExpireDate(ref itemList);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(result, ResourcesManager.TranslateKey(MessagesConstants.Desc_Saved_Successfully, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.MessageErrorHappened, _requestRepository.LanguageId));
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }



        [HttpGet]
        [ActionName("GetItemsTemplate")]
        public JsonResult GetItemsTemplate()
        {
            try
            {
                List<BarcodeTemplateModel> data = new List<BarcodeTemplateModel>();
                GlobalErrors result = _itemService.GetItemsTemplate(ref data);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(data, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.MessageErrorHappened, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        #endregion







        [HttpGet]
        [ActionName("CheckIfItemSerialsAvailable")]
        public JsonResult CheckIfItemSerialsAvailable()
        {
            try
            {
                bool exist = false;
                bool isAnyPackHasTrimRule = false;
                var result = _itemService.CheckIfItemSerialsAvailable(ref exist, ref isAnyPackHasTrimRule);
                var data = new
                {
                    isExist = exist,
                    isAnyPackHasTrimRule = isAnyPackHasTrimRule
                };

                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(data, "");
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon();
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpPost]
        [ActionName("GetSecondaryPacks")]
        public JsonResult GetSecondaryPacks([FromBody] int itemId)
        {
            try
            {
                List<SecondaryPackModel> secondaryPacks = null;
                var result = _itemService.GetSecondaryPacks(itemId, ref secondaryPacks);

                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(secondaryPacks, "");
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon();
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        [HttpPost]
        [ActionName("IsSecondaryPackValidToRemove")]
        public JsonResult IsSecondaryPackValidToRemove([FromBody] int secondaryPackId)
        {
            string msg = string.Empty;
            try
            {
                msg = _itemService.IsSecondaryPackValidToDelete(secondaryPackId);
                if (string.IsNullOrEmpty(msg))
                {
                    return JSonResultResponse.GetSuccessrJSon(true, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(msg, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpGet]
        [ActionName("GetCompetitorsList")]
        public JsonResult GetCompetitorsList()
        {
            try
            {
                List<CompetitorModel> competitorsList = new List<CompetitorModel>();
                GlobalErrors result = _itemService.GetCompetitorsList(ref competitorsList);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(competitorsList, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.MessageErrorHappened, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        [HttpPost]
        [ActionName("GetAvailableCompetitorItemList")]
        public JsonResult GetAvailableCompetitorItemList([FromBody] int itemId)
        {
            try
            {
                List<CompetitorModel> competitorItemList = new List<CompetitorModel>();
                GlobalErrors result = _itemService.GetAvailableCompetitorItemList(itemId, ref competitorItemList);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(competitorItemList, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.MessageErrorHappened, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpGet]
        [ActionName("fillDataInItemExtraInfo")]
        public JsonResult fillDataInItemExtraInfo()
        {
            try
            {
                GlobalErrors result = _itemService.fillDataInItemExtraInfo();
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(result, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }


        [HttpPost]
        [ActionName("UpdateItemSerialOperations")]
        public JsonResult UpdateItemSerialOperations([FromBody] List<ItemSerialOperations> serialOperations)
        {
            try
            {
                var result = _itemService.UpdateItemSerialOperations(serialOperations);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(result, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Update_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Saving, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        [HttpGet]
        [ActionName("CheckIfItemsWithUpperLimitAvailable")]
        public JsonResult CheckIfItemsWithUpperLimitAvailable()
        {
            bool allowCheckUpperLimit = false;
            try
            {
                GlobalErrors result = _itemService.CheckIfItemsWithUpperLimitAvailable(ref allowCheckUpperLimit);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(allowCheckUpperLimit, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Update_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Saving, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }



    }
}