﻿using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Hosting;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Newtonsoft.Json;
using Sonic.Web.DAL;
using Sonic.Web.Licensing.Licensing;
using Sonic.Web.Model;
using Sonic.Web.Model.Customer;
using Sonic.Web.PL.SystemModels;
using Sonic.Web.Resources;
using Sonic.Web.Service;
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Data;
using System.IO;
using System.Linq;
using System.Reflection;
using System.Threading.Tasks;

namespace Sonic.Web.PL.Controllers
{
    [Route("api/[controller]/[action]")]
    [Authorize]
    public class ItemGroupController : BaseController
    {

        private readonly IRequestRepository _requestRepository;
        private readonly CustomerService _customerService;
        private readonly MasterDataService _masterDataService;
        private readonly IHostingEnvironment _hostingEnvironment;
        private readonly IWebHostEnvironment _webHostEnvironment;
        private readonly ItemService _itemService;

        public ItemGroupController(IRequestRepository requestRepository, IWebHostEnvironment webHostEnvironment, ILicensing licensing, IHostingEnvironment hostingEnvironment, IActiveTokens activeTokens) : base(requestRepository, licensing,activeTokens )
        {
            _requestRepository = requestRepository;
            _customerService = new CustomerService(_requestRepository);
            _masterDataService = new MasterDataService(requestRepository);
            _hostingEnvironment = hostingEnvironment;
            _webHostEnvironment = webHostEnvironment;
            _itemService = new ItemService(_requestRepository);
        }

        #region GET
        [HttpPost]
        [ActionName("GetAllItemGroupLazyLoading")]
        public JsonResult GetAllItemGroupLazyLoading([FromBody] GeneralFilter filter)
        {
            try
            {
                SharedTableResult<ItemGroupModel> itemListTable = new SharedTableResult<ItemGroupModel>();
                //GeneralFilter filter = JsonConvert.DeserializeObject<GeneralFilter>(itemsFilter);
                GlobalErrors result = _itemService.GetItemGroupLoading(filter, ref itemListTable);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(itemListTable, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else if (result == GlobalErrors.NoMoreRows)
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_No_Data_Found, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpPost]
        [ActionName("GetItemGroupInEdit")]
        public JsonResult GetItemGroupInEdit([FromBody] int itemGroupId)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {

                var itemGroup = new ItemGroupEntryModel();
                result = _itemService.getItemGroupData(itemGroupId, ref itemGroup);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(itemGroup, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.MessageErrorHappened, _requestRepository.LanguageId));
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        #endregion

        #region UPDATE
        [HttpPost]
        [ActionName("UpdateItemGroup")]
        public JsonResult UpdateItemGroup([FromForm] Collection<IFormFile> image, [FromForm] string group)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                ItemGroupEntryModel itemGroupEntryModel = JsonConvert.DeserializeObject<ItemGroupEntryModel>(group);
                if (itemGroupEntryModel != null)
                {
                    string hostingEnvironment = _hostingEnvironment.ContentRootPath;
                    bool uniqueCode = true;
                    var insertedValue = itemGroupEntryModel.languageDescriptions.Where(x => x.LanguageId == _requestRepository.LanguageId).Select(x => x.Description)?.FirstOrDefault();
                    result = _masterDataService.CheckIfUniqueValue("ItemGroupLanguage", "Description", insertedValue, itemGroupEntryModel.ItemGroupId > 0 ? "and ItemGroupID != " + itemGroupEntryModel.ItemGroupId : "", ref uniqueCode);

                    if (uniqueCode)
                    {
                        result = _itemService.InsertOrUpdateItemGroup(itemGroupEntryModel, image, hostingEnvironment);
                        if (result == GlobalErrors.Success)
                        {
                            return JSonResultResponse.GetSuccessrJSon(true, ResourcesManager.TranslateKey(MessagesConstants.Desc_Saved_Successfully, _requestRepository.LanguageId));
                        }
                        else if (result == GlobalErrors.CustomerAppPath)
                        {
                            return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.MessageErrorAppPath, _requestRepository.LanguageId));
                        }
                        else
                        {
                            return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.MessageErrorHappened, _requestRepository.LanguageId));
                        }
                    }
                    else
                    {
                        return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey("Desc_Unique_ItemGroup", _requestRepository.LanguageId));
                    }
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.MessageErrorHappened, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        #endregion

        #region INSERT
        [HttpPost]
        [ActionName("InsertItemGroup")]
        public JsonResult InsertItemGroup([FromForm] Collection<IFormFile> image, [FromForm] string group)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                ItemGroupEntryModel itemGroupEntryModel = JsonConvert.DeserializeObject<ItemGroupEntryModel>(group);
                if (itemGroupEntryModel != null)
                {
                    string hostingEnvironment = _hostingEnvironment.ContentRootPath;
                    bool uniqueCode = true;
                    var insertedValue = itemGroupEntryModel.languageDescriptions.Where(x => x.LanguageId == _requestRepository.LanguageId).Select(x => x.Description)?.FirstOrDefault();
                    result = _masterDataService.CheckIfUniqueValue("ItemGroupLanguage", "Description", insertedValue, itemGroupEntryModel.ItemGroupId > 0 ? "and ItemGroupID != " + itemGroupEntryModel.ItemGroupId : "", ref uniqueCode);

                    if (uniqueCode)
                    {
                        result = _itemService.InsertOrUpdateItemGroup(itemGroupEntryModel, image, hostingEnvironment);
                        if (result == GlobalErrors.Success)
                        {
                            return JSonResultResponse.GetSuccessrJSon(true, ResourcesManager.TranslateKey(MessagesConstants.Desc_Saved_Successfully, _requestRepository.LanguageId));
                        }
                        else if (result == GlobalErrors.CustomerAppPath)
                        {
                            return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.MessageErrorAppPath, _requestRepository.LanguageId));
                        }
                        else
                        {
                            return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.MessageErrorHappened, _requestRepository.LanguageId));
                        }
                    }
                    else
                    {
                        return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey("Desc_Unique_ItemGroup", _requestRepository.LanguageId));
                    }
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.MessageErrorHappened, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        #endregion

        #region DELETE
        [HttpPost]
        [ActionName("DeleteItemGroupData")]
        public JsonResult DeleteItemGroupData([FromBody] int itemGroupID)
        {
            try
            {
                string errorMessage = string.Empty;
                var result = _itemService.deleteItemGroupData(itemGroupID, ref errorMessage);
                if (result == GlobalErrors.Success)
                {

                    return JSonResultResponse.GetSuccessrJSon(true, ResourcesManager.TranslateKey(MessagesConstants.Desc_Delete_Successfully, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(string.IsNullOrEmpty(errorMessage) ? MessagesConstants.Desc_Delete_Faild : errorMessage, _requestRepository.LanguageId));

                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        #endregion
    }
}