﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Reflection;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Mvc;
using Newtonsoft.Json;
using Sonic.Web.DAL;
using Sonic.Web.Licensing.Licensing;
using Sonic.Web.Model;
using Sonic.Web.Model.Location;
using Sonic.Web.PL.SystemModels;
using Sonic.Web.Resources;
using Sonic.Web.Service;

namespace Sonic.Web.PL.Controllers
{
    [Route("api/[controller]/[action]")]
    public class LocationController : BaseController
    {
        private readonly IRequestRepository _requestRepository;
        private readonly LocationService _locationService;
        public LocationController(IRequestRepository requestRepository, ILicensing licensing, IActiveTokens activeToken) : base(requestRepository, licensing, activeToken)
        {
            _requestRepository = requestRepository;
            _locationService = new LocationService(requestRepository);
        }

        [HttpPost]
        [ActionName("GetCountries")]
        public JsonResult GetCountries()
        {
            try
            {
                if (!ModelState.IsValid)
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_Happend, _requestRepository.LanguageId));
                }
                var countries = new List<Country>();
                var result = _locationService.GetCountries(ref countries);

                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(countries, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                return JSonResultResponse.GetErrorJSon(ex.Message);
            }
        }
        [HttpPost]
        [ActionName("GetStates")]
        public JsonResult GetStates([FromBody]State filter)
        {
            try
            {
                if (!ModelState.IsValid)
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_Happend, _requestRepository.LanguageId));
                }
                var states = new List<State>();
                var result = _locationService.GetStates(filter.CountryId, ref states);

                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(states, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                return JSonResultResponse.GetErrorJSon(ex.Message);
            }
        }

        [HttpPost]
        [ActionName("GetCities")]
        public JsonResult GetCities([FromBody]City filter)
        {
            try
            {
                if (!ModelState.IsValid)
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_Happend, _requestRepository.LanguageId));
                }
                var cities = new List<City>();
                var result = _locationService.GetCities(filter.CountryId, filter.StateId, ref cities);

                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(cities, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                return JSonResultResponse.GetErrorJSon(ex.Message);
            }
        }

        [HttpPost]
        [ActionName("GetAreas")]
        public JsonResult GetAreas([FromBody] Area filter)
        {
            try
            {
                if (!ModelState.IsValid)
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_Happend, _requestRepository.LanguageId));
                }
                var areas = new List<Area>();
                var result = _locationService.GetAreas(filter.CountryId, filter.StateId, filter.CityId, ref areas);

                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(areas, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                return JSonResultResponse.GetErrorJSon(ex.Message);
            }
        }

        [HttpPost]
        [ActionName("GetStreets")]
        public JsonResult GetStreets([FromBody] Street filter)
        {
            try
            {
                if (!ModelState.IsValid)
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_Happend, _requestRepository.LanguageId));
                }
                var areas = new List<Street>();
                var result = _locationService.GetStreets(filter.CountryId, filter.StateId, filter.CityId, filter.AreaId, ref areas);

                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(areas, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                return JSonResultResponse.GetErrorJSon(ex.Message);
            }
        }

        [HttpPost]
        [ActionName("GetLocatoinLists")]
        public JsonResult GetLocatoinLists()
        {
            try
            {
                List<LocationModel> LocationsList = new List<LocationModel>();
                GlobalErrors result = _locationService.GetLocatoinLists(ref LocationsList);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(LocationsList, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else if (result == GlobalErrors.NoMoreRows)
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_No_Data_Found, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        #region Locations Hierarchy 
        [HttpPost]
        [ActionName("GetGeoLocationHierarchyData")]
        public JsonResult GetGeoLocationHierarchyData([FromBody]LocationHierarchyFilter locationHierarchyFilter)
        {
            try
            {
                dynamic locationsHierarchyData = null;
                var result = _locationService.GetGeoLocationHierarchyData(ref locationsHierarchyData, locationHierarchyFilter);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(locationsHierarchyData, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpPost]
        [ActionName("SaveUpdateLocationHierarchyData")]
        public JsonResult SaveUpdateLocationHierarchyData([FromBody] LocationHierarchyModel locationHierarchyModel)
        {
            try
            {
                string errorMessage = string.Empty;
                LocationHierarchyModel parentNode = null;
                var result = _locationService.SaveUpdateLocationHierarchyData(locationHierarchyModel,ref parentNode,ref errorMessage);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(parentNode,ResourcesManager.TranslateKey(MessagesConstants.Desc_Saved_Successfully, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(string.IsNullOrEmpty(errorMessage) ? MessagesConstants.Desc_Error_While_Saving : errorMessage, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpPost]
        [ActionName("DeletLocationHierarchyData")]
        public JsonResult DeletLocationHierarchyData([FromBody] LocationHierarchyModel locationHierarchyModel)
        {
            try
            {
                LocationHierarchyModel parentNode = null;
                var result = _locationService.DeletLocationHierarchyData(locationHierarchyModel,ref parentNode);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(parentNode, ResourcesManager.TranslateKey(MessagesConstants.Desc_Deleted_Successfully, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Delete_Failed, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        #endregion

    }
}