﻿using Microsoft.AspNetCore.Hosting;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Microsoft.IdentityModel.Tokens;
using Newtonsoft.Json;
using Sonic.Web.DAL;
using Sonic.Web.Licensing.Licensing;
using Sonic.Web.Model;
using Sonic.Web.PL.SystemModels;
using Sonic.Web.Resources;
using Sonic.Web.Service;
using System;
using System.Collections.Generic;
using System.IdentityModel.Tokens.Jwt;
using System.Net.NetworkInformation;
using System.Reflection;
using System.Security.Claims;
using System.Text;
using Sonic.Web.PL.Helper;
using InCube.Security;
using Sonic.Web.SecureLibrary;
using Newtonsoft.Json.Serialization;
using Microsoft.Extensions.Primitives;
using System.Linq;
using Microsoft.Extensions.DependencyInjection;
using Microsoft.AspNetCore.SignalR;
using Sonic.Web.Core;
using System.DirectoryServices.Protocols;
using System.Net;

namespace Sonic.Web.PL.Controllers
{
    [Route("api/[controller]/[action]")]
    public class LoginController : ControllerBase
    {
        private readonly ILicensing _licensing;
        private readonly IHostingEnvironment _hostingEnvironment;

        private readonly IRequestRepository _requestRepository;
        private readonly LoginService _loginService;
        private readonly EmployeeService _employeeService;
        private readonly SystemConfigService _systemConfigService;
        private readonly SettingService _settingService;
        private readonly IActiveTokens _IactiveToken;
        private readonly ChattingService _chattingService;

        //private readonly ChattingService _chattingService;
        private static SharedMethod _sharedMethod;
        private IHttpContextAccessor HttpContextAccessor { get; }
        public LoginController( IHttpContextAccessor httpContextAccessor, ILicensing licensing, IHostingEnvironment env, IRequestRepository requestRepository, IActiveTokens activeToken, IHubContext<MessageHub> hubContext)
        {
            _licensing = licensing;
            _hostingEnvironment = env;
            _requestRepository = requestRepository;
            _IactiveToken = activeToken;
            _loginService = new LoginService(requestRepository, activeToken);
            _employeeService = new EmployeeService(requestRepository);
            _systemConfigService = new SystemConfigService(requestRepository);
            _settingService = new SettingService(requestRepository);
            HttpContextAccessor = httpContextAccessor;
            _sharedMethod = new SharedMethod(requestRepository);
                    _chattingService = new ChattingService(hubContext);

        }
        



        [HttpGet]
        [ActionName("GetAllLanguages")]
        public JsonResult GetAllLanguages()
        {
            var langauges = new List<LanguageModel>();
            try
            {
                var result = SettingService.GetAllLanguages(ref langauges, false);

                if (result == GlobalErrors.Success && langauges.Count > 0)
                {
                    return JSonResultResponse.GetSuccessrJSon(langauges, "getting language successfully");
                }
                else
                {
                    langauges = new List<LanguageModel>();
                    var language = new LanguageModel()
                    {
                        LanguageId = 1,
                        Description = "English",
                        Code = "EN",
                        RTL = false,
                        Active = true
                    };
                    langauges.Add(language);
                    return JSonResultResponse.GetSuccessrJSon(langauges, "getting language successfully");
                }
            }
            catch (Exception ex)
            {
                return JSonResultResponse.GetErrorJSon("Error while get languages");
            }
        }



        [HttpPost]
        [ActionName("Login")]
        public JsonResult Login([FromBody] OperatorForLogin operatorData, int languageId)
        {
            var licenseResult = Licensing.Enums.LicenseResult.Unauthorized;
            string errorMessage = string.Empty;
            string successMessage = string.Empty;
            try
            {
                if (operatorData != null)
                {
                    //_requestRepository.CurrentOperator.password = _requestRepository.CurrentOperator.password.Replace("'", "''");
                    //_requestRepository.CurrentOperator.username = _requestRepository.CurrentOperator.username.Replace("'", "''");
                    if (!string.IsNullOrEmpty(operatorData.Username))
                        operatorData.Username = operatorData.Username.Replace("'", "''");
                    if (!string.IsNullOrEmpty(operatorData.Password))
                        operatorData.Password = operatorData.Password.Replace("'", "''");
                    if (!string.IsNullOrEmpty(operatorData.DeviceInfo))
                        operatorData.DeviceInfo = operatorData.DeviceInfo.Replace("'", "''");
                }
                string remoteIpAddress = HttpContext.Connection.RemoteIpAddress.MapToIPv4().ToString(); 
                if (!string.IsNullOrEmpty(this.Request.Headers["Origin"].ToString()))
                {
                    var originFromHeader = this.Request.Headers["Origin"].ToString().Replace("'", "").Replace("\"", "").ToLower();
                    if (LocalUtilities.AllowedOriginsList != null
                        && LocalUtilities.AllowedOriginsList.Count > 0
                        && LocalUtilities.AllowedOriginsList.FindAll(x => x.Equals("*")).Count <= 0
                        && !string.IsNullOrEmpty(originFromHeader)
                        && !LocalUtilities.AllowedOriginsList.Contains(originFromHeader))
                    {
                        return JSonResultResponse.GetUnauthorized("1");
                    }
                }
                else
                {
                    return JSonResultResponse.GetUnauthorized("1");
                }

                List<MenuModel> AllAvailableMenus = new List<MenuModel>();
                List<MenuModel> addedMenus = new List<MenuModel>();

                if (!ModelState.IsValid)
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Provide_UserName_Password, languageId));
                }
                //if (IPGlobalProperties.GetIPGlobalProperties().DomainName.ToLower() == LocalUtilities.DomainName)
                //{
                //    licenseResult = Licensing.Enums.LicenseResult.Licensed;
                //}
                //else
                //{
                //    licenseResult = _licensing.CheckLicense();
                //}
                //if (licenseResult != Licensing.Enums.LicenseResult.Licensed
                //    && licenseResult != Licensing.Enums.LicenseResult.NearToExpired)
                //{
                //    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(_licensing.GetErrorMessage(), languageId));
                //}

                GlobalErrors result = GlobalErrors.NotInitialized;
                OperatorModel operatorModel = null;
                List<OrganizationModel> operatorOrganizations = new List<OrganizationModel>();
                CachedGeneralData generalData = new CachedGeneralData();
                bool showPrivacy = false;
                bool CheckEnableActiveDirectoryLogin = false;
                bool ValidADLogin = true;
                //string domain = string.Empty;
                string EnableActiveDirectoryLogin = null;
                string browserName = HttpContext.Request.Headers["User-Agent"].ToString();

                if (string.IsNullOrEmpty(operatorData.Username) || string.IsNullOrEmpty(operatorData.Password))
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Invalid_UserName_Password, languageId));
                }

                result = ConfigurationManager.GetConfigurationGeneralValue("EnableActiveDirectoryLogin", ref EnableActiveDirectoryLogin);
               
                if (result == GlobalErrors.Success && !string.IsNullOrEmpty(EnableActiveDirectoryLogin))
                {
                    CheckEnableActiveDirectoryLogin = Convert.ToBoolean(EnableActiveDirectoryLogin);
                    //domain = System.Net.NetworkInformation.IPGlobalProperties.GetIPGlobalProperties().DomainName;
                }

                //if (CheckEnableActiveDirectoryLogin)
                //{
                //    if (!CheckActiveDirectoryLogin(operatorData.Username, operatorData.Password, domain, ref ValidADLogin))
                //    {
                //        errorMessage = ResourcesManager.TranslateKey(MessagesConstants.Desc_Check_AD_Admin_Login, languageId);
                //    }
                //}

                result = _loginService.Login(operatorData, _licensing, ref operatorModel, ref AllAvailableMenus, ref addedMenus, ref errorMessage, languageId, ref showPrivacy, ref operatorOrganizations , remoteIpAddress , CheckEnableActiveDirectoryLogin , ValidADLogin , browserName);
                

                if (result == GlobalErrors.NeedOrganizationSelection)
                {
                    var OrgList = new
                    {
                        NeedOrganizationSelection = result,
                        operatorOrganizations,
                    };
                    return JSonResultResponse.GetSuccessrJSon(OrgList, errorMessage);
                }

                if (result == GlobalErrors.Success && operatorModel != null)
                {
                    HttpContext.Session.SetString(SessionsConstants.CurrentSession, operatorModel.OperatorId + "-" + HttpContext.Session.Id);
                    _requestRepository.CurrentOperator = operatorModel;
                    _requestRepository.LanguageId = operatorData.LanguageId;
                    result = _employeeService.FillOperatorConfigurations();
                    if (result == GlobalErrors.Success)
                    {
                        result = _employeeService.FillOperatorRelatedData(true , true , true , operatorData.SelectedOrganizationId,true);
                    }
#if !DEBUG
                        if (_requestRepository.Configurations.WebVersion != LocalUtilities.AppVersion)
                        {
                            return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.MsgUpdateWebVersion, languageId));
                        }
#endif


                    if (result != GlobalErrors.Success)
                    {
                        return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, languageId));
                    }

                    #region [Token]
                    string tokenString = WorkExtension.GenerateToken(operatorModel, HttpContext.Session.Id);
                    if (string.IsNullOrEmpty(tokenString.Trim()))
                    {
                        return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_Generating_Token_Key, languageId));
                    }
                    else
                    {
                        result = _IactiveToken.AddActiveTokens(tokenString);
                        if (result != GlobalErrors.Success)
                            return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Saving, languageId));
                    }
                    #endregion

                    #region [Session]
                    if (result == GlobalErrors.Success && _requestRepository.CurrentOperator.EmployeeId > 0 && (IPGlobalProperties.GetIPGlobalProperties().DomainName == null || IPGlobalProperties.GetIPGlobalProperties().DomainName.ToLower() != LocalUtilities.DomainName))
                    {
                        string SessionId = operatorModel.OperatorId + "-" + HttpContext.Session.Id;
                        if (_licensing.GetActiveSessions(Licensing.Enums.SonicModules.SonicWeb).Any(x => x.EmployeeId == operatorModel.EmployeeId && x.MachineName == Environment.MachineName && x.BrowserName == browserName))
                        {
                            var RemoveSessionId = _licensing.GetActiveSessions(Licensing.Enums.SonicModules.SonicWeb).Where(x => 
                            x.EmployeeId == operatorModel.EmployeeId && 
                            x.MachineName == Environment.MachineName && 
                            x.BrowserName == browserName)
                            .Select(x => x.SessionId).FirstOrDefault();

                            if(RemoveSessionId != null)
                            {
                                result = (GlobalErrors)_licensing.RemoveSessionFromDB(RemoveSessionId, Licensing.Enums.SonicModules.SonicWeb);
                            } 
                            else
                            {
                                return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Remove_Session, languageId));
                            }
                        }
                        result = _loginService.InsertSessionToDB(_licensing, SessionId , operatorModel.EmployeeId, Licensing.Enums.SonicModules.SonicWeb , browserName);
                        if (result != GlobalErrors.Success)
                        {
                            return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Saving_Session, languageId));
                        }
                    }
                    #endregion

                    string privacyText = string.Empty;
                    if (showPrivacy)
                    {
                        if (languageId == 2)
                        {
                            privacyText = PrivacyModel.PrivacyAr;
                        }
                        else
                        {
                            privacyText = PrivacyModel.PrivacyEn;
                        }
                    }
                    generalData = _systemConfigService.GetCachedGeneralData();

                    string allAvailableMenusEncrypted = string.Empty;
                    string addedMenusEncrypted = string.Empty;
                    string configurationsListEncrypted = string.Empty;

                    var serializerSettings = new JsonSerializerSettings();

                    #region[Encrypt All Available Menus]
                    serializerSettings.ContractResolver = new CamelCasePropertyNamesContractResolver();
                    var json = JsonConvert.SerializeObject(AllAvailableMenus, serializerSettings);
                    string encryptString = AESEncryption.EncryptDataAESE(json, _requestRepository.CurrentOperator.EmployeeId);
                    if (encryptString != null && !string.IsNullOrEmpty(encryptString))
                    {
                        allAvailableMenusEncrypted = encryptString;
                    }
                    #endregion


                    #region[SupervisorApp Token]

                    if (_requestRepository.Configurations.hasSupervisorApp && operatorData.DeviceToken != null)
                    {
                        result = _loginService.SaveDeviceToken(_requestRepository.CurrentOperator.EmployeeId, operatorData.DeviceToken);
                    }

                    #endregion

                    #region[Encrypt Added Menus]
                    serializerSettings = new JsonSerializerSettings();
                    serializerSettings.ContractResolver = new CamelCasePropertyNamesContractResolver();
                    json = JsonConvert.SerializeObject(addedMenus, serializerSettings);
                    encryptString = AESEncryption.EncryptDataAESE(json, _requestRepository.CurrentOperator.EmployeeId);
                    if (encryptString != null && !string.IsNullOrEmpty(encryptString))
                    {
                        addedMenusEncrypted = encryptString;
                    }
                    #endregion

                    #region[Encrypt Configurations List]
                    serializerSettings = new JsonSerializerSettings();
                    serializerSettings.ContractResolver = new CamelCasePropertyNamesContractResolver();
                    json = JsonConvert.SerializeObject(_requestRepository.ConfigurationsList, serializerSettings);
                    encryptString = AESEncryption.EncryptDataAESE(json, _requestRepository.CurrentOperator.EmployeeId);
                    if (encryptString != null && !string.IsNullOrEmpty(encryptString))
                    {
                        configurationsListEncrypted = encryptString;
                    }
                    #endregion

                    bool isInternetConnect = _employeeService.CheckForInternetConnection();

                    var data = new
                    {
                        key = tokenString,
                        operatorModel,
                        generalData = generalData,
                        menuList = allAvailableMenusEncrypted,
                        addedList = addedMenusEncrypted,
                        configurationsList = configurationsListEncrypted,
                        isNearToExpired = _licensing.IsNearToExpired(),
                        showPrivacy = showPrivacy,
                        privacyText = privacyText,
                        isInternetConnect = isInternetConnect
                        // configurationsListOnDivisionLevel = CoreSession.Instance.ConfigurationsListOnDivisionLevel,
                    };
                    if (_licensing.IsNearToExpired())
                    {
                        if (_licensing.NumberOfDaysToExpired() == 0)
                        {
                            successMessage = ResourcesManager.TranslateKey(MessagesConstants.Desc_Expired_Today, languageId);
                        }
                        else
                        {
                            successMessage = string.Format(ResourcesManager.TranslateKey(MessagesConstants.Desc_Near_To_Expired, languageId), _licensing.NumberOfDaysToExpired());
                        }
                    }
                    else
                    {
                        successMessage = ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, languageId);
                    }
                    LocalUtilities.IsSonic = true;
                    return JSonResultResponse.GetSuccessrJSon(data, successMessage);
                }
                else if (result == GlobalErrors.PasswordShouldBeChanged && operatorModel != null)
                {
                    return JSonResultResponse.GetSuccessrJSon(result, ResourcesManager.TranslateKey(errorMessage, languageId));
                }
                else if (result == GlobalErrors.LoggedInOtherSession && operatorModel != null)
                {
                    return JSonResultResponse.GetSuccessrJSon(result, ResourcesManager.TranslateKey(errorMessage, languageId));
                }
                else
                {
                    if (string.IsNullOrEmpty(errorMessage))
                        errorMessage = ResourcesManager.TranslateKey(MessagesConstants.Desc_Invalid_UserName_Password, languageId);
                    return JSonResultResponse.GetErrorJSon(errorMessage);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpPost]
        [ActionName("Logout")]
        public JsonResult Logout(string deviceInfo, int operatorId)
        {
            var result = GlobalErrors.Success;
            try
            {
                if (!string.IsNullOrEmpty(deviceInfo))
                    deviceInfo = deviceInfo.Replace("'", "''");

                if (!string.IsNullOrEmpty(this.Request.Headers["Origin"].ToString()))
                {
                    var originFromHeader = this.Request.Headers["Origin"].ToString().Replace("'", "").Replace("\"", "").ToLower();
                    if (LocalUtilities.AllowedOriginsList != null
                        && LocalUtilities.AllowedOriginsList.Count > 0
                        && LocalUtilities.AllowedOriginsList.FindAll(x => x.Equals("*")).Count <= 0
                        && !string.IsNullOrEmpty(originFromHeader)
                        && !LocalUtilities.AllowedOriginsList.Contains(originFromHeader))
                    {
                        return JSonResultResponse.GetUnauthorized("1");
                    }
                }
                else
                {
                    return JSonResultResponse.GetUnauthorized("1");
                }

                #region[Chatting]

                bool isChattingAvailable = false;
                result = _employeeService.CheckIfChattingIsAvailableForOperator(operatorId, ref isChattingAvailable);
                if (result == GlobalErrors.Success)
                {
                    if (isChattingAvailable)
                    {
                        int employeeId = -1;
                        result = _employeeService.GetEmployeeIdFromOperatorId(operatorId, ref employeeId);
                        if (result == GlobalErrors.Success)
                        {
                            ChattingUserModel user = new ChattingUserModel();
                            user.UserId = employeeId;
                            user.AddRemoveAssignment = false;
                            user.IsBOUser = true;
                            user.Status = ChattingConnectionStatus.Offline;
                            user.ChattingConnectionStatusValue = ChattingConnectionStatus.Offline.GetHashCode();
                            result = _chattingService.UpdateChattingUsers(user, _requestRepository.LanguageId);
                            // do not consider result of UpdateChattingUsers,
                        }
                        else
                        {
                            return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_Logout, _requestRepository.LanguageId));
                        }
                    }
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_Logout, _requestRepository.LanguageId));
                }
                #endregion

                if (operatorId > 0 && (IPGlobalProperties.GetIPGlobalProperties().DomainName == null || IPGlobalProperties.GetIPGlobalProperties().DomainName.ToLower() != LocalUtilities.DomainName))
                {
                    var sessionId = User.FindFirstValue(ClaimTypes.Sid);
                    result = (GlobalErrors)_licensing.RemoveSessionFromDB(User.FindFirstValue(ClaimTypes.Sid), Licensing.Enums.SonicModules.SonicWeb);
                }
                if (result == GlobalErrors.Success)
                {
                    result = _loginService.UpdateLoginStatus(deviceInfo, operatorId);
                    if (result == GlobalErrors.Success)
                    {
                        string token = this.Request.Headers["Authorization"].ToString();
                        result = _IactiveToken.DeleteActiveTokens(token);
                        if (result == GlobalErrors.Success)
                        {
                            return JSonResultResponse.GetSuccessrJSon(true, ResourcesManager.TranslateKey(MessagesConstants.Desc_Logout_Successfully, _requestRepository.LanguageId));
                        }
                        else
                        {
                            return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_Logout, _requestRepository.LanguageId));
                        }

                    }
                    else
                    {
                        return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_Logout, _requestRepository.LanguageId));
                    }
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_Logout, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        

        [HttpPost]
        [ActionName("GetNumberofLoginOperator")]
        public JsonResult GetNumberofLoginOperator([FromBody] int operatorId)
        {
            try
            {
                object objField = 0;
                GlobalErrors result = _loginService.GetNumberofLoginOperator(ref objField, operatorId);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(objField, ResourcesManager.TranslateKey(MessagesConstants.MessageSuccess, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_Logout, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }


        [HttpGet]
        [ActionName("AutoLogout")]
        public JsonResult AutoLogout()
        {
            try
            {
                GlobalErrors result = LoginService.Logout();
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(true, ResourcesManager.TranslateKey(MessagesConstants.Desc_Logout_Successfully, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_Logout, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpGet]
        [ActionName("SetLanguageId")]
        public JsonResult SetLanguageId(int languageId)
        {
            try
            {
                _loginService.SetLanguage(languageId);

                return JSonResultResponse.GetSuccessrJSon(true, ResourcesManager.TranslateKey(MessagesConstants.Desc_Setting_Language_successfully, _requestRepository.LanguageId));
            }
            catch (Exception ex)
            {
                return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_Setting_Language, _requestRepository.LanguageId));
            }
        } 
        [HttpGet]
        [ActionName("GetExternalURLs")]
        public JsonResult GetExternalURLs()
        {
            try
            {
                List<ExternalURLModel> externalURLs = new List<ExternalURLModel>();
                GlobalErrors result = _loginService.GetExternalURLs(ref externalURLs);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(externalURLs, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.MessageErrorHappened, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        //private string GenerateToken(OperatorModel operatorModel)
        //{
        //    try
        //    {
        //        string securityKey = CoreDataBaseConstants.SessionsConstants.SecurityKey;
        //        //symmetric security key
        //        var symmetricSecurityKey = new SymmetricSecurityKey(Encoding.UTF8.GetBytes(securityKey));

        //        //signing credentials
        //        var signingCredentials = new SigningCredentials(symmetricSecurityKey, SecurityAlgorithms.HmacSha256Signature);

        //        //add claims
        //        var claims = new List<Claim>();
        //        claims.Add(new Claim(ClaimTypes.NameIdentifier, operatorModel.EncryptedEmployeeId));
        //        claims.Add(new Claim(ClaimTypes.Name, JsonConvert.SerializeObject(operatorModel)));
        //        claims.Add(new Claim(ClaimTypes.Sid, operatorModel.OperatorId + "-" + HttpContext.Session.Id));
        //        //create token
        //        var token = new JwtSecurityToken(
        //                issuer: CoreDataBaseConstants.SessionsConstants.ValidIssuer,
        //                audience: CoreDataBaseConstants.SessionsConstants.ValidAudience,
        //                expires: DateTime.Now.AddHours(CoreDataBaseConstants.SessionsConstants.ExpiryDateSessionHours),
        //                signingCredentials: signingCredentials
        //                , claims: claims
        //            );
        //        return new JwtSecurityTokenHandler().WriteToken(token);
        //    }
        //    catch (Exception ex)
        //    {
        //        ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
        //        return string.Empty;
        //    }
        //}


        [HttpPost]
        [ActionName("ChangePassword")]
        public JsonResult ChangePassword([FromBody] OperatorProfileModel operatorModel, int languageId)
        {
            try
            {
                if (!string.IsNullOrEmpty(this.Request.Headers["Origin"].ToString()))
                {
                    var originFromHeader = this.Request.Headers["Origin"].ToString().Replace("'", "").Replace("\"", "").ToLower();
                    if (LocalUtilities.AllowedOriginsList != null
                        && LocalUtilities.AllowedOriginsList.Count > 0
                        && LocalUtilities.AllowedOriginsList.FindAll(x => x.Equals("*")).Count <= 0
                        && !string.IsNullOrEmpty(originFromHeader)
                        && !LocalUtilities.AllowedOriginsList.Contains(originFromHeader))
                    {
                        return JSonResultResponse.GetUnauthorized("1");
                    }
                }
                else
                {
                    return JSonResultResponse.GetUnauthorized("1");
                }

                string errorMessage = string.Empty;
                GlobalErrors result = _employeeService.ChangePassword(operatorModel, languageId, ref errorMessage);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Password_Changed_Successfully, languageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(errorMessage);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        #region [Methods]
        static bool CheckActiveDirectoryLogin(string username, string password, string domain ,ref bool Valid)
        {
            using (LdapConnection connection = new LdapConnection(domain))
            {
                try
                {
                    connection.SessionOptions.ProtocolVersion = 3;
                    connection.SessionOptions.ReferralChasing = ReferralChasingOptions.None;
                    connection.AuthType = AuthType.Negotiate;
                    connection.Credential = new NetworkCredential(username, password, domain);
                    connection.Bind();
                    return true;
                }
                catch (LdapException ex)
                {
                    ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                    return Valid = false;
                }
            }
        }
        #endregion
    }
}