﻿using Microsoft.AspNetCore.Mvc;

using Sonic.Web.DAL;
using Sonic.Web.Model;
using Sonic.Web.Service;
using System;
using System.Collections.Generic;
using System.Reflection;

using Sonic.Web.Resources;
using Sonic.Web.PL.SystemModels;
using Sonic.Web.Licensing;
using Sonic.Web.Licensing.Licensing;
using Newtonsoft.Json;
using Sonic.Web.Model.MasterData;

namespace Sonic.Web.PL.Controllers
{
    [Route("api/[controller]/[action]")]
    public class MasterDataController : BaseController
    {
        private readonly IRequestRepository _requestRepository;
        private readonly MasterDataService _masterDataService;

        public MasterDataController(IRequestRepository requestRepository, ILicensing licensing, IActiveTokens activeToken) : base(requestRepository, licensing, activeToken)
        {
            _requestRepository = requestRepository;
            _masterDataService = new MasterDataService(_requestRepository);
        }

        [HttpPost]
        [ActionName("GetDistributorOrganizations")]
        public JsonResult GetDistributorOrganizations()
        {
            try
            {
                List<OrganizationModel> organizationsList = new List<OrganizationModel>();
                GlobalErrors result = _masterDataService.GetDistributorOrganizations(ref organizationsList);

                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(organizationsList, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpPost]
        [ActionName("GetOrganizationList")]
        public JsonResult GetOrganizationList([FromBody] OrganizationRequestModel organizationRequestModel)
        {
            try
            {
                List<OrganizationModel> organizationsList = new List<OrganizationModel>();
                GlobalErrors result = _masterDataService.GetOrganizationList(organizationRequestModel.ExcludedOrganizationId, ref organizationsList , organizationRequestModel.IsFromStaffEmployeeOrgAccess);

                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(organizationsList, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpPost]
        [ActionName("GetSecurityGroupsList")]
        public JsonResult GetSecurityGroupsList([FromBody] GeneralFilter filter)
        {
            try
            {
                List<SecurityGroupModel> securityGroupsList = new List<SecurityGroupModel>();
                GlobalErrors result = _masterDataService.GetSecurityGroupsList(filter.EmployeeId, filter.OrganizationId, ref securityGroupsList , filter.isFromApprovalCyclePromotion);

                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(securityGroupsList, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpPost]
        [ActionName("CheckIfUniqueValue")]
        public JsonResult CheckIfUniqueValue([FromBody] MasterDataFilter filter)
        {
            try
            {
                bool isUniqueValue = false;
                string tableName = string.Empty;
                string columnName = string.Empty;
                string insertedValue = string.Empty;
                string excludedString = string.Empty;
                if(filter != null)
                {
                    tableName = filter.TableName;
                    columnName = filter.ColumnName;
                    insertedValue = filter.InsertedValue;
                    excludedString = filter.ExcludedString;
                }
                GlobalErrors result = _masterDataService.CheckIfUniqueValue(tableName, columnName, insertedValue, excludedString, ref isUniqueValue);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(isUniqueValue, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.MessageErrorHappened, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpPost]
        [ActionName("CheckIfUniqueDescription")]
        public JsonResult CheckIfUniqueDescription([FromBody] UniqueDescriptionModel uniqueDescription)
        {
            try
            {
                bool isUniqueValue = false;
                GlobalErrors result = _masterDataService.CheckIfUniqueDescription(uniqueDescription, ref isUniqueValue);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(isUniqueValue, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.MessageErrorHappened, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        [HttpPost]
        [ActionName("CheckIfUniqueValueOfListOfData")]
        public JsonResult CheckIfUniqueValueOfListOfData([FromBody]List<EntryData> dataList)
        {
            try
            {
                bool isUniqueValue = true;
                GlobalErrors result = GlobalErrors.Success;
                string invalidColumn = string.Empty;
                foreach(EntryData entryData in dataList)
                {
                    result = _masterDataService.CheckIfUniqueValue(entryData.TableName,entryData.ColumnName, entryData.InsertedValue, entryData.ExcludedString, ref isUniqueValue);
                    if(!isUniqueValue || result!= GlobalErrors.Success)
                    {
                        invalidColumn = entryData.ColumnDescription;
                        break;
                    }
                }

                if (result == GlobalErrors.Success)
                {
                    if(!isUniqueValue)
                    {
                        return JSonResultResponse.GetErrorJSon(invalidColumn + " " + ResourcesManager.TranslateKey(MessagesConstants.Desc_Msg_Must_Be_Unique, _requestRepository.LanguageId));
                    }
                    else
                        return JSonResultResponse.GetSuccessrJSon(isUniqueValue, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(invalidColumn+" "+ ResourcesManager.TranslateKey(MessagesConstants.Desc_Msg_Must_Be_Unique, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        
        [HttpPost]
        [ActionName("GetBanks")]
        public JsonResult GetBanks()
        {
            try
            {
                List<BankModel> banks = new List<BankModel>();
                GlobalErrors result = _masterDataService.GetBanks(ref banks);

                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(banks, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpPost]
        [ActionName("GetActivateDeactivateReason")]
        public JsonResult GetActivateDeactivateReason([FromBody] MasterDataFilter filter)
        {
            var result = GlobalErrors.NotInitialized;
            List<dynamic> reasonsList = null;
            MasterDataScreens screen = MasterDataScreens.Employees;
            MasterDataStatus status = MasterDataStatus.Activate;

            if(filter != null)
            {
                screen = filter.Screen;
                status = filter.Status;
            }
            try
            {
                result = _masterDataService.GetActivateDeactivateReason(screen, status, ref reasonsList);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(reasonsList, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpPost]
        [ActionName("InsertAuditMasterReason")]
        public JsonResult InsertAuditMasterReason([FromBody]AuditMasterData auditMaster)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                result = _masterDataService.InsertAuditMasterReason(auditMaster);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(auditMaster, ResourcesManager.TranslateKey(MessagesConstants.Desc_Saved_Successfully, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Saving, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
    }
}