﻿using Microsoft.AspNetCore.Mvc;
using Microsoft.AspNetCore.SignalR;
using Sonic.Web.Core;
using System;
using Microsoft.AspNetCore.Authorization;
using Sonic.Web.PL.SystemModels;
using Sonic.Web.Resources;
using Sonic.Web.DAL;
using Microsoft.AspNetCore.Hosting;
using System.Reflection;
using Sonic.Web.Licensing.Licensing;
using Sonic.Web.Service;
using Sonic.Web.Model;
using System.Collections.Generic;
using System.Linq;

namespace Sonic.Web.PL.Controllers
{
    [Route("api/[controller]/[action]")]
    [Authorize]
    public class NotificationController : BaseController
    {
        private readonly IRequestRepository _requestRepository;
        private readonly IHostingEnvironment _hostingEnvironment;
        private NotificationService _notificationService;
        public NotificationController(IHubContext<NotifyHub, ITypedHubClient> hubContext, IRequestRepository requestRepository, ILicensing licensing, IActiveTokens activeToken) : base(requestRepository, licensing, activeToken)
        {
            _hostingEnvironment = _hostingEnvironment;
            _requestRepository = requestRepository;
            _notificationService = new NotificationService(hubContext, requestRepository);
        }
        [HttpPost]
        public JsonResult SendNotification([FromBody]NotificationModel notification)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                result = _notificationService.SendNotification(notification, null);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(result, ResourcesManager.TranslateKey(MessagesConstants.Desc_Saved_Successfully, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Saving, _requestRepository.LanguageId));
        }
        [HttpPost]
        public JsonResult SetNotificationReadFlag([FromBody]SetNotificationAsReadModel notification)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                result = _notificationService.SetNotificationReadFlag(notification);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(result, ResourcesManager.TranslateKey(MessagesConstants.Desc_Saved_Successfully, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Saving, _requestRepository.LanguageId));
        }
        [HttpPost]
        [ActionName("GetEmployeeNotificationsLazyLoading")]
        public JsonResult GetEmployeeNotificationsLazyLoading([FromBody] int currentNotificationCount)
        {
            try
            {
                List<NotificationModel> notificationsList = new List<NotificationModel>();
                GlobalErrors result = _notificationService.GetEmployeeNotificationsLazyLoading(currentNotificationCount, ref notificationsList);

                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(notificationsList, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        [HttpGet]
        [ActionName("GetEmployeeUnreadNotificationsCount")]
        public JsonResult GetEmployeeUnreadNotificationsCount()
        {
            try
            {
                int unreadNotificationsCoun = 0;
                GlobalErrors result = _notificationService.GetEmployeeUnreadNotificationsCount(ref unreadNotificationsCoun);

                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(unreadNotificationsCoun, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        [HttpPost]
        [ActionName("GetNotificationTemplateListSharedTable")]
        public JsonResult GetNotificationTemplateListSharedTable([FromBody] NotificationTemplateFilterModel recallfilter)
        {
            try
            {
                SharedTableResult<NotificationTemplateModel> templateListSharedTable = new SharedTableResult<NotificationTemplateModel>();
                GlobalErrors result = _notificationService.GetNotificationTemplateListSharedTable(recallfilter, ref templateListSharedTable);

                if (result == GlobalErrors.Success)
                {
                    if (templateListSharedTable != null && templateListSharedTable.Data != null && templateListSharedTable.Data.ToList().Count > 0)
                    {
                        return JSonResultResponse.GetSuccessrJSon(templateListSharedTable, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                    }
                    else
                    {
                        return JSonResultResponse.GetSuccessrJSon(templateListSharedTable, ResourcesManager.TranslateKey(MessagesConstants.Desc_No_Data_Found, _requestRepository.LanguageId));
                    }
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        [HttpPost]
        [ActionName("IsValidToGetCommCalcNotificationType")]
        public JsonResult IsValidToGetCommCalcNotificationType()
        {
            try
            {
                bool isValid = false;
                GlobalErrors result = _notificationService.IsValidToGetCommCalcNotificationType(ref isValid);

                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(isValid, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        [HttpPost]
        [ActionName("GetNotificationTemplateList")]
        public JsonResult GetNotificationTemplateList([FromBody] int notificationTypeId)
        {
            try
            {
                List<NotificationTemplateModel> templateList = new List<NotificationTemplateModel>();
                GlobalErrors result = _notificationService.GetNotificationTemplateList(notificationTypeId, ref templateList);

                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(templateList, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        [HttpPost]
        [ActionName("GetNotificationTemplateData")]
        public JsonResult GetNotificationTemplateData([FromBody] int templateId)
        {
            try
            {
                if (!ModelState.IsValid)
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Provide_UserName_Password, _requestRepository.LanguageId));
                }
                if (templateId > 0)
                {
                    List<TextLanguage> descriptionsList = new List<TextLanguage>();
                    List<TextLanguage> headerDescriptionsList = new List<TextLanguage>();
                    List<TextLanguage> bodyDescriptionsList = new List<TextLanguage>();

                    GlobalErrors result = _notificationService.GetNotificationTemplateData(templateId, ref descriptionsList, ref headerDescriptionsList, ref bodyDescriptionsList);
                    if (result == GlobalErrors.Success)
                    {
                        var data = new
                        {
                            descriptionsList = descriptionsList,
                            headerDescriptionsList = headerDescriptionsList,
                            bodyDescriptionsList = bodyDescriptionsList,
                        };
                        return JSonResultResponse.GetSuccessrJSon(data, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                    }
                    else
                    {
                        return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                    }
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        [HttpPost]
        [ActionName("InsertNotificationTemplate")]
        public JsonResult InsertNotificationTemplate([FromBody] NotificationTemplateModel notificationTemplate)
        {
            try
            {
                if (!ModelState.IsValid)
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Provide_UserName_Password, _requestRepository.LanguageId));
                }
                GlobalErrors result = _notificationService.SaveNotificationTemplate(notificationTemplate);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(result, ResourcesManager.TranslateKey(MessagesConstants.Desc_Saved_Successfully, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Saving, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        [HttpPost]
        [ActionName("UpdateNotificationTemplateActiveStatus")]
        public JsonResult UpdateNotificationTemplateActiveStatus([FromBody] NotificationTemplateModel notificationTemplate)
        {
            try
            {
                if (!ModelState.IsValid)
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Provide_UserName_Password, _requestRepository.LanguageId));
                }
                GlobalErrors result = _notificationService.UpdateNotificationTemplateActiveStatus(notificationTemplate.TemplateId, !notificationTemplate.Inactive);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(result, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Update_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.MessageErrorHappened, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
    }
}