﻿using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Mvc;
using Newtonsoft.Json;
using Sonic.Web.DAL;
using Sonic.Web.Licensing.Licensing;
using Sonic.Web.Model;
using Sonic.Web.Model.General;
using Sonic.Web.Model.MasterData;
using Sonic.Web.Models;
using Sonic.Web.PL.SystemModels;
using Sonic.Web.Resources;
using Sonic.Web.Service;
using System;
using System.Collections.Generic;
using System.Dynamic;
using System.Reflection;

namespace Sonic.Web.PL.Controllers
{
    [Route("api/[controller]/[action]")]
    [Authorize]
    public class OperatorLoginFailuresController : BaseController
    {
        private readonly IRequestRepository _requestRepository;
        private readonly SettingService _settingService;
        public OperatorLoginFailuresController(IRequestRepository requestRepository, ILicensing licensing, IActiveTokens activeToken) : base(requestRepository, licensing, activeToken)
        {
            _requestRepository = requestRepository;
            _settingService = new SettingService(requestRepository);
        }
        #region GET

        [HttpPost]
        [ActionName("GetOperatorLoginFailuresListSharedTable")]
        public JsonResult GetOperatorLoginFailuresListSharedTable([FromBody] GeneralFilter filter)
        {
            try
            {
                SharedTableResult<OperatorLoginFailureModel> operatorListTable = new SharedTableResult<OperatorLoginFailureModel>();
                GlobalErrors result = _settingService.GetOperatorLoginFailuresListSharedTable(filter, ref operatorListTable);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(operatorListTable, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else if (result == GlobalErrors.NoMoreRows)
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_No_Data_Found, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        [HttpPost]
        [ActionName("GetOperatorLoginFailuresDetailsSharedTable")]
        public JsonResult GetOperatorLoginFailuresDetailsSharedTable([FromBody] OperatorLoginFailureModel operatorObject)
        {
            List<OperatorLoginFailureModel> operatorLoginFailuresDetailsSharedTable = new List<OperatorLoginFailureModel>();
            try
            {
                GlobalErrors result = GlobalErrors.NotInitialized;
                result = _settingService.GetOperatorLoginFailuresDetailsSharedTable(operatorObject, ref operatorLoginFailuresDetailsSharedTable);
                if (result == GlobalErrors.Success)
                {

                    return JSonResultResponse.GetSuccessrJSon(operatorLoginFailuresDetailsSharedTable, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        [HttpPost]
        [ActionName("GetOperatorNames")]
        public JsonResult GetOperatorNames()
        {
            try
            {
                List<OperatorLoginFailureModel> operatorName = new List<OperatorLoginFailureModel>();
                GlobalErrors result = _settingService.GetOperatorNames(ref operatorName);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(operatorName, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        #endregion
        #region Unlock
        [HttpPost]
        [ActionName("UnlockOperator")]
        public JsonResult UnlockOperator([FromBody] OperatorLoginFailureModel operatorObject)
        {
            try
            {
                string errorMessage = string.Empty;
                GlobalErrors result = _settingService.UnlockOperator(operatorObject, ref errorMessage);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(result, ResourcesManager.TranslateKey(MessagesConstants.Desc_Saved_Successfully, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Saving, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        #endregion
    }
}
