﻿using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Hosting;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Newtonsoft.Json;
using Sonic.Web.DAL;
using Sonic.Web.Licensing.Licensing;
using Sonic.Web.Model;
using Sonic.Web.Model.Customer;
using Sonic.Web.PL.SystemModels;
using Sonic.Web.Resources;
using Sonic.Web.Service;
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Data;
using System.IO;
using System.Linq;
using System.Reflection;
using System.Threading.Tasks;

namespace Sonic.Web.PL.Controllers
{
    [Route("api/[controller]/[action]")]
    [Authorize]
    public class PackGroupController : BaseController
    {

        private readonly IRequestRepository _requestRepository;
        private readonly CustomerService _customerService;
        private readonly MasterDataService _masterDataService;
        private readonly IHostingEnvironment _hostingEnvironment;
        private readonly IWebHostEnvironment _webHostEnvironment;
        private readonly ItemService _itemService;

        public PackGroupController(IRequestRepository requestRepository, IWebHostEnvironment webHostEnvironment, ILicensing licensing, IHostingEnvironment hostingEnvironment, IActiveTokens activeToken) : base(requestRepository, licensing, activeToken)
        {
            _requestRepository = requestRepository;
            _customerService = new CustomerService(_requestRepository);
            _masterDataService = new MasterDataService(requestRepository);
            _hostingEnvironment = hostingEnvironment;
            _webHostEnvironment = webHostEnvironment;
            _itemService = new ItemService(_requestRepository);
        }

        #region GET
        [HttpGet]
        [ActionName("GetPackGroupsItemDefinition")]
        public JsonResult GetPackGroupsItemDefinition()
        {
            try
            {
                List<PackGroupModel> data = new List<PackGroupModel>();
                GlobalErrors result = _itemService.GetPackGroupsItemDefinition(ref data);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(data, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.MessageErrorHappened, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpPost]
        [ActionName("getPackGroups")]
        public JsonResult getPackGroups([FromBody] PackGroupModel packGroup )
        {
            try
            {
                List<PackGroupModel> data = new List<PackGroupModel>();
                GlobalErrors result = _itemService.getPackGroups(ref data, packGroup.GetGroupsHavingSamePackQuantity, packGroup.SelectedOraganizationIds, packGroup.IncludePacks, packGroup.AllowedPackGroupIds);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(data, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.MessageErrorHappened, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        [HttpPost]
        [ActionName("GetPackGroupsListSharedTable")]
        public JsonResult GetPackGroupsListSharedTable([FromBody] CustomListFilters filter)
        {
            try
            {
                SharedTableResult<PackGroupModel> sharedTableList = new SharedTableResult<PackGroupModel>();
                GlobalErrors result = _itemService.GetPackGroupsListSharedTable(filter, ref sharedTableList);

                if (result == GlobalErrors.Success)
                {
                    if (sharedTableList != null && sharedTableList.Data != null && sharedTableList.Data.ToList().Count > 0)
                    {
                        return JSonResultResponse.GetSuccessrJSon(sharedTableList, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                    }
                    else
                    {
                        return JSonResultResponse.GetSuccessrJSon(sharedTableList, ResourcesManager.TranslateKey(MessagesConstants.Desc_No_Data_Found, _requestRepository.LanguageId));
                    }
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        [HttpPost]
        [ActionName("GetPackGroupsDescriptions")]
        public JsonResult GetPackGroupsDescriptions([FromBody] int packGroupId)
        {
            try
            {
                List<TextLanguage> descriptions = new List<TextLanguage>();
                GlobalErrors result = _itemService.GetPackGroupsDescriptions(packGroupId, ref descriptions);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(descriptions, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.MessageErrorHappened, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpPost]
        [ActionName("GetPackGroupItems")]
        public JsonResult GetPackGroupItems([FromBody] PackGroupModel filter)
        {
            var result = GlobalErrors.NotInitialized;
            var items = new List<ItemPackModel>();
            var name = string.Empty;
            try
            {
                result = _itemService.GetPackGroupItems(filter, ref items);
                if (result == GlobalErrors.Success)
                {
                    result = _itemService.GetPackGroupName(filter.PackGroupId, ref name);
                }
                if (result == GlobalErrors.Success)
                {
                    var packGroupData = new
                    {
                        PackGroupItems = items,
                        packGroupNames = name
                    };
                    return JSonResultResponse.GetSuccessrJSon(packGroupData, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }

            }
            catch (Exception ex)
            {
                return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
            }
        }
        #endregion

        #region UPDATE
        [HttpPost]
        [ActionName("UpdatePackGroup")]
        public JsonResult UpdateItemGroup([FromBody] PackGroupModel packGroup)
        {
            try
            {
                bool isUniqueValue = false;
                string execludedValue = string.Empty;
                execludedValue = packGroup.PackGroupId != -1 ? string.Format(" And PackGroupId !=  {0} AND (PackGroup.Inactive= 0 or PackGroup.Inactive is null) And (PackGroup.IsDeleted <> 1)", packGroup.PackGroupId) : " AND (PackGroup.Inactive= 0 or PackGroup.Inactive is null) And (PackGroup.IsDeleted <> 1)";
                GlobalErrors result = _itemService.CheckIfUniqueValue("PackGroup", "PackGroupCode", packGroup.PackGroupCode, execludedValue, ref isUniqueValue);
                if (!isUniqueValue)
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Unique_Code, _requestRepository.LanguageId));
                }
                result = _itemService.AddEditPackGroup(packGroup);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(result, ResourcesManager.TranslateKey(MessagesConstants.Desc_Saved_Successfully, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Saving, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Saving, _requestRepository.LanguageId));
            }
        }
        #endregion

        #region INSERT
        [HttpPost]
        [ActionName("InsertPackGroup")]
        public JsonResult InsertItemGroup([FromBody] PackGroupModel packGroup)
        {
            try
            {
                bool isUniqueValue = false;
                string execludedValue = string.Empty;
                execludedValue = packGroup.PackGroupId != -1 ? string.Format(" And PackGroupId !=  {0} AND (PackGroup.Inactive= 0 or PackGroup.Inactive is null) And (PackGroup.IsDeleted <> 1)", packGroup.PackGroupId) : " AND (PackGroup.Inactive= 0 or PackGroup.Inactive is null) And (PackGroup.IsDeleted <> 1)";
                GlobalErrors result = _itemService.CheckIfUniqueValue("PackGroup", "PackGroupCode", packGroup.PackGroupCode, execludedValue, ref isUniqueValue);
                if (!isUniqueValue)
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Unique_Code, _requestRepository.LanguageId));
                }
                result = _itemService.AddEditPackGroup(packGroup);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(result, ResourcesManager.TranslateKey(MessagesConstants.Desc_Saved_Successfully, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Saving, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Saving, _requestRepository.LanguageId));
            }
        }
        #endregion

        #region DELETE
        [HttpPost]
        [ActionName("deletePackGroup")]
        public JsonResult deletePackGroup([FromBody] int groupId)
        {
            try
            {
                string errorMessage = string.Empty;
                var result = _itemService.deletePackGroup(groupId, ref errorMessage);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Deleted_Successfully, _requestRepository.LanguageId));
                }
                else
                {

                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(!string.IsNullOrEmpty(errorMessage) ? errorMessage : MessagesConstants.Desc_Delete_Failed, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Delete_Failed, _requestRepository.LanguageId));
            }
        }
        #endregion
    }
}