﻿using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Mvc;
using Sonic.Web.DAL;
using Sonic.Web.Licensing.Licensing;
using Sonic.Web.Model;
using Sonic.Web.PL.SystemModels;
using Sonic.Web.Resources;
using Sonic.Web.Service;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Reflection;
using System.Text;
using static Sonic.Web.Model.PaymentModel;

namespace Sonic.Web.PL.Controllers
{
    [Route("api/[controller]/[action]")]
    [Authorize]
    public class PaymentController : BaseController
    {
        private readonly IRequestRepository _requestRepository;
        private readonly PaymentService _paymentService;
        public PaymentController(IRequestRepository requestRepository, ILicensing licensing, IActiveTokens activeToken) : base(requestRepository, licensing, activeToken)
        {
            _requestRepository = requestRepository;
            _paymentService = new PaymentService(_requestRepository);
        }

        [HttpPost]
        [ActionName("GetPaymentTypes")]
        public JsonResult GetPaymentTypes([FromBody] PaymentTypeFilterModel paymentTypeFilterModel)
        {
            try
            {
                bool isDownPayment = false;
                int customerID = -1;
                int outletID = -1;
                if (paymentTypeFilterModel != null)
                {
                    customerID = paymentTypeFilterModel.customerID;
                    outletID = paymentTypeFilterModel.outletID;
                    isDownPayment = paymentTypeFilterModel.isDownPayment;

                }
                List<PaymentTypeModel> paymentTypesList = new List<PaymentTypeModel>();
                GlobalErrors result = _paymentService.GetPaymentTypes(ref paymentTypesList, isDownPayment, customerID, outletID);


                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(paymentTypesList, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpPost]
        [ActionName("GetALLPaymentTypes")]
        public JsonResult GetALLPaymentTypes()
        {
            try
            {
                List<PaymentTypeModel> PaymentTypes = new List<PaymentTypeModel>();

                GlobalErrors result = _paymentService.GetALLPaymentTypes(ref PaymentTypes);

                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(PaymentTypes, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpPost]
        [ActionName("GetBankWithBranches")]
        public JsonResult GetBankWithBranches()
        {
            try
            {
                List<BankModel> bankList = new List<BankModel>();
                GlobalErrors result = _paymentService.GetBankWithBranches(ref bankList);

                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(bankList, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpPost]
        [ActionName("GetPaymentList")]
        public JsonResult GetPaymentList([FromBody] GeneralFilter filter)
        {
            try
            {
                SharedTableResult<PaymentModel> itemList = new SharedTableResult<PaymentModel>();
                //GeneralFilter generalFilter = JsonConvert.DeserializeObject<GeneralFilter>(filter);
                GlobalErrors result = _paymentService.GetPaymentsList(filter, ref itemList);


                if (result == GlobalErrors.Success)
                {
                    if (itemList != null && itemList.Data != null && itemList.Data.ToList().Count > 0)
                    {
                        return JSonResultResponse.GetSuccessrJSon(itemList, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                    }
                    else
                    {
                        return JSonResultResponse.GetSuccessrJSon(itemList, ResourcesManager.TranslateKey(MessagesConstants.Desc_No_Data_Found, _requestRepository.LanguageId));
                    }
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpPost]
        [ActionName("VoidPayments")]
        public JsonResult VoidPayments([FromBody] List<PaymentModel> selectedPayments)
        {
            try
            {
                StringBuilder voidingMsg = new StringBuilder();
                GlobalErrors result = _paymentService.VoidSelectedPayments(selectedPayments, ref voidingMsg);
                if (result == GlobalErrors.Success)
                {
                    if (string.IsNullOrEmpty(voidingMsg.ToString()))
                    {
                        return JSonResultResponse.GetSuccessrJSon(true, ResourcesManager.TranslateKey(MessagesConstants.Desc_Voided_Successfully, _requestRepository.LanguageId));
                    }
                    else
                    {
                        return JSonResultResponse.GetSuccessrJSon(false, ResourcesManager.TranslateKey(voidingMsg.ToString(), _requestRepository.LanguageId));
                    }
                }
                else
                {
                    string message = string.IsNullOrEmpty(voidingMsg.ToString()) ? ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Saving, _requestRepository.LanguageId) : voidingMsg.ToString();
                    return JSonResultResponse.GetErrorJSon(message);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        [HttpPost]
        [ActionName("BounceCheques")]
        public JsonResult BounceCheques([FromBody] List<PaymentModel> selectedPayments)
        {
            try
            {
                StringBuilder voidingMsg = new StringBuilder();
                GlobalErrors result = _paymentService.BounceCheques(selectedPayments, ref voidingMsg);
                if (result == GlobalErrors.Success)
                {
                    if (string.IsNullOrEmpty(voidingMsg.ToString()))
                    {
                        return JSonResultResponse.GetSuccessrJSon(true, ResourcesManager.TranslateKey(MessagesConstants.Desc_Bounced_Successfully, _requestRepository.LanguageId));
                    }
                    else
                    {
                        return JSonResultResponse.GetSuccessrJSon(false, ResourcesManager.TranslateKey(voidingMsg.ToString(), _requestRepository.LanguageId));
                    }
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Saving, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        //[HttpPost]
        //[ActionName("GetDownPaymentList")]
        //public JsonResult GetDownPaymentList([FromBody] GeneralFilter filter)
        //{
        //    try
        //    {
        //        SharedTableResult<PaymentModel> downPayments = new SharedTableResult<PaymentModel>();
        //        //GeneralFilter generalFilter = JsonConvert.DeserializeObject<GeneralFilter>(filter);
        //        GlobalErrors result = _paymentService.GetDownPaymentsList(filter, ref downPayments);


        //        if (result == GlobalErrors.Success)
        //        {
        //            if (downPayments != null && downPayments.Data != null && downPayments.Data.ToList().Count > 0)
        //            {
        //                return JSonResultResponse.GetSuccessrJSon(downPayments, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
        //            }
        //            else
        //            {
        //                return JSonResultResponse.GetSuccessrJSon(downPayments, ResourcesManager.TranslateKey(MessagesConstants.Desc_No_Data_Found, _requestRepository.LanguageId));
        //            }
        //        }
        //        else
        //        {
        //            return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
        //        }
        //    }
        //    catch (Exception ex)
        //    {
        //        ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
        //        return JSonResultResponse.GetErrorJSon();
        //    }
        //}

        //[HttpPost]
        //[ActionName("InsertDownPayments")]
        //public JsonResult InsertDownPayments([FromBody] List<PaymentModel> paymentsList)
        //{
        //    GlobalErrors result = GlobalErrors.Success;
        //    try
        //    {
        //        if (!ModelState.IsValid)
        //        {
        //            return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Saving, _requestRepository.LanguageId));
        //        }
        //        string paymentIDs = string.Empty;
        //        int divisionId = -1;
        //        bool isExtraPaymentByCollectInvoice = false;
        //        result = _paymentService.SaveDownPayments(paymentsList, ref paymentIDs, ref divisionId, isExtraPaymentByCollectInvoice);
        //        if (result == GlobalErrors.Success)
        //        {
        //            var data = new
        //            {
        //                status = result,
        //                paymentIDs = paymentIDs,
        //                divisionId = divisionId
        //            };
        //            return JSonResultResponse.GetSuccessrJSon(data, ResourcesManager.TranslateKey(MessagesConstants.Desc_Saved_Successfully, _requestRepository.LanguageId));
        //        }
        //        else
        //        {
        //            return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Saving, _requestRepository.LanguageId));
        //        }
        //    }
        //    catch (Exception ex)
        //    {
        //        ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
        //        return JSonResultResponse.GetErrorJSon();
        //    }
        //}

        //[HttpPost]
        //[ActionName("VoidDownPayments")]
        //public JsonResult VoidDownPayments([FromBody] PaymentModel downPayment)
        //{
        //    try
        //    {
        //        string voidingMsg = string.Empty;
        //        GlobalErrors result = _paymentService.VoidDownPayment(downPayment, ref voidingMsg);
        //        if (result == GlobalErrors.Success)
        //        {
        //            return JSonResultResponse.GetSuccessrJSon(result, ResourcesManager.TranslateKey(MessagesConstants.Desc_Saved_Successfully, _requestRepository.LanguageId));
        //        }
        //        else
        //        {
        //            if (!string.IsNullOrEmpty(voidingMsg.ToString()))
        //            {
        //                return JSonResultResponse.GetErrorJSon(voidingMsg.ToString());
        //            }
        //            else
        //            {
        //                return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Saving, _requestRepository.LanguageId));
        //            }
        //        }
        //    }
        //    catch (Exception ex)
        //    {
        //        ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
        //        return JSonResultResponse.GetErrorJSon();
        //    }
        //}
    }
}