﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Threading.Tasks;
using DinkToPdf;
using DinkToPdf.Contracts;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Mvc;
using Razor.Templating.Core;
using Sonic.Web.DAL;
using Sonic.Web.Model;
using Sonic.Web.Service;
using Microsoft.AspNetCore.Hosting;
using System.Reflection;
using Sonic.Web.Resources;
using Sonic.Web.Licensing.Licensing;
using Sonic.Web.Core;
using QRCoder;
using System.Drawing;
using Newtonsoft.Json;

namespace Sonic.Web.PL.Controllers
{
    [Route("api/[controller]/[action]")]
    [Authorize]
    public class PdfCreatorController : BaseController
    {
        private IConverter _converter;
        private readonly IRequestRepository _requestRepository;
        private readonly TemplateGenerator _templateGenerator;
        private IWebHostEnvironment _hostEnvironment;
        private  ILicensing _licensing;
        private readonly TemplateGenerator _templateGeneratorService;
        private readonly EmailManager _emailManager;//is it ok to access manager disrectly from controller?
        private readonly TransactionService _transactionService;
        private readonly SharedMethod _sharedMethod;
        public PdfCreatorController(IConverter converter, IRequestRepository requestRepository, IWebHostEnvironment hostEnvironment, ILicensing licensing, IActiveTokens activeToken)
            : base(requestRepository, licensing, activeToken)
        {
            _converter = converter;
            _requestRepository = requestRepository;
            _hostEnvironment = hostEnvironment;
            _licensing = licensing;
            _templateGenerator = new TemplateGenerator(requestRepository);
            _templateGeneratorService = new TemplateGenerator(requestRepository);
            _emailManager = new EmailManager(requestRepository);
            _transactionService = new TransactionService(requestRepository);
            _sharedMethod = new SharedMethod(_requestRepository);
            //_razorViewEngine = razorViewEngine;
        }

        [HttpPost]
        [ActionName("ExportReport")]
        public IActionResult ExportReport([FromBody] TransactionHistory transaction)
        {
            var result = GlobalErrors.NotInitialized;
            string headerPath = string.Empty;
            try
            {
                double topMargin = 10;
                string path = string.Empty, htmlContent = string.Empty;
                var reportModel = new ReportModel();
                int reportId = transaction.reportMode.GetHashCode();
                result = _templateGenerator.GetReportModel(reportId, ref reportModel);
                if (!transaction.IsReprintReport)
                {
                    if (reportModel.Enabled == 0)
                    {
                        return View();
                    }
                }
                
                result = _templateGenerator.ExportReport(transaction, ref path, ref reportModel, null, false);
                if (transaction.reportMode == ReportMode.Transaction || transaction.reportMode== ReportMode.TestTransaction || transaction.reportMode == ReportMode.Invoiced || transaction.reportMode == ReportMode.Delivered || transaction.reportMode == ReportMode.CreditNote || transaction.reportMode == ReportMode.DebitNote || transaction.reportMode == ReportMode.Return)
                {
                    var QR_str =  _transactionService.GetStringQRCode(transaction.CustomerId, transaction.OutletId, transaction.TransactionId, transaction.reportMode);
                    reportModel.QRCode = GenerateQRCode(QR_str);
                }
                
                if (result == GlobalErrors.Success)
                {
                    string pageFooter = ResourcesManager.TranslateKey(CaptionsConstants.Desc_Report_Page_Footer, _requestRepository.LanguageId);
                    string ofString = ResourcesManager.TranslateKey(CaptionsConstants.Desc_Of_String, _requestRepository.LanguageId);
                    string footer = string.Format("{0} [page] {1} [toPage]", pageFooter, ofString);
                    RazorTemplateEngine.Initialize();
                    htmlContent = RazorTemplateEngine.RenderAsync(path, reportModel).Result;
                    if (_requestRepository.Configurations.PrintHeaderPerPage)
                    {
                        double totalLines = 0;
                        result = _sharedMethod.PrepareCustomHeader(ref htmlContent, ref headerPath);

                        if (reportModel != null && reportModel.TransactionDetails != null && reportModel.TransactionDetails.Count > 0)
                        {
                            var detail = reportModel.TransactionDetails.FirstOrDefault();
                            object value = null;
                            if (((IDictionary<string, object>)detail).ContainsKey("HeaderLines"))
                            {
                                ((IDictionary<string, object>)detail).TryGetValue("HeaderLines", out value);
                            }
                            if (value != null && !string.IsNullOrEmpty(value.ToString()))
                            {
                                totalLines = double.Parse(value.ToString());
                            }
                        }
                        double singleLineMargin = 7;

                        topMargin = (singleLineMargin * (totalLines));
                    }

                    if (result != GlobalErrors.Success) return View();
                   
                    var globalSettings = new GlobalSettings
                    {
                        ColorMode = ColorMode.Color,
                        Orientation = Orientation.Portrait,
                        PaperSize = PaperKind.A4,
                        Margins = new MarginSettings { Top = topMargin, Left = 3, Right = 3 },
                        DocumentTitle = reportModel.ReportTitle,
                        DPI = 500
                        //Out = @"D:\PDFCreator\Employee_Report.pdf"  USE THIS PROPERTY TO SAVE PDF TO A PROVIDED LOCATION
                    };

                    var objectSettings = new ObjectSettings
                    {
                        PagesCount = true,
                        HtmlContent = htmlContent,
                        //Page = "https://code-maze.com/", USE THIS PROPERTY TO GENERATE PDF CONTENT FROM AN HTML PAGE
                        WebSettings = { DefaultEncoding = "utf-8", UserStyleSheet = Path.Combine(Directory.GetCurrentDirectory(), "PDFUtility", "ReportsStyle.css") },
                        HeaderSettings = { FontName = "Arial", FontSize = 9, HtmUrl = headerPath },
                        FooterSettings = { FontName = "Arial", FontSize = 9, Left = DateTime.Now.ToString(), Right = footer, Spacing = 1.8 }
                    };
                    var pdf = new HtmlToPdfDocument()
                    {
                        GlobalSettings = globalSettings,
                        Objects = { objectSettings }
                    };
                    //_converter.Convert(pdf); IF WE USE Out PROPERTY IN THE GlobalSettings CLASS, THIS IS ENOUGH FOR CONVERSION
                    //return File(file, "application/pdf", "EmployeeReport.pdf"); //USE THIS RETURN STATEMENT TO DOWNLOAD GENERATED PDF DOCUMENT
                    return File(_converter.Convert(pdf), "application/pdf");
                }
                else
                {
                    return View();
                }
            }
            catch (Exception ex)
            {

                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return View();
            }
            finally
            {
                // Delete the temporary report header file
                if (!string.IsNullOrEmpty(headerPath) && System.IO.File.Exists(headerPath))
                {
                    System.IO.File.Delete(headerPath);
                }
            }
        }
        [HttpPost]
        [ActionName("ExportOmnitradeReport")]
        public IActionResult ExportOmnitradeReport([FromBody] TransactionHistory transaction)
        {
            var result = GlobalErrors.NotInitialized;
            string headerPath = string.Empty;
            try
            {
                double topMargin = 10;
                string path = string.Empty, htmlContent = string.Empty;
                var reportModel = new ReportModel();
                int reportId = transaction.reportMode.GetHashCode();
                result = _templateGenerator.GetReportModel(reportId, ref reportModel);
                if (!transaction.IsReprintReport)
                {
                    if (reportModel.Enabled == 0)
                    {
                        return View();
                    }
                }

                result = _templateGenerator.ExportReport(transaction, ref path, ref reportModel, null, false);

                List<dynamic> allItemsList = new List<dynamic>();
                allItemsList = reportModel.TransactionDetails;

                int numberOfItemsPerPage = 13;

                List<List<dynamic>> pagesList = new List<List<dynamic>>();
                List<ReportModel> reportModelsList = new List<ReportModel>();
               
                for (int i = 0; i < allItemsList.Count; i += numberOfItemsPerPage)
                {
                    List<dynamic> sublist = allItemsList.Skip(i).Take(numberOfItemsPerPage).ToList();
                    pagesList.Add(sublist);
                }


                if (transaction.reportMode == ReportMode.Transaction || transaction.reportMode == ReportMode.Invoiced || transaction.reportMode == ReportMode.Delivered || transaction.reportMode == ReportMode.CreditNote || transaction.reportMode == ReportMode.DebitNote || transaction.reportMode == ReportMode.Return)
                {
                    var QR_str = _transactionService.GetStringQRCode(transaction.CustomerId, transaction.OutletId, transaction.TransactionId, transaction.reportMode);
                    reportModel.QRCode = GenerateQRCode(QR_str);
                }
                decimal grossTotal = 0;
                decimal tax = 0;
                decimal netTotal = 0;
                for (int j = 0; j < pagesList.Count; j++)
                {
                    var pageModel = new ReportModel();
                    pageModel = reportModel.DeepCopy();
                    pageModel.TransactionDetails = pagesList[j];
                    if (j == (pagesList.Count - 1))
                    {
                        pageModel.ShowTotal = true;
                    }
                    grossTotal += pageModel.TransactionDetails.Sum(i => (decimal)(i.Price * i.Quantity));
                    tax += pageModel.TransactionDetails.Sum(i => (decimal)(i.Tax));
                    netTotal += pageModel.TransactionDetails.Sum(i => (decimal)(i.NetTotal));
                    pageModel.GrossTotal = grossTotal;
                    pageModel.TaxTotal = tax;
                    pageModel.NetTotal = netTotal;
                    pageModel.OrderID = transaction.TransactionId;
                    pageModel.PageString = (j + 1) + " / " + pagesList.Count;
                    reportModelsList.Add(pageModel);
                }
                if (result == GlobalErrors.Success)
                {
                    string pageFooter = ResourcesManager.TranslateKey(CaptionsConstants.Desc_Report_Page_Footer, _requestRepository.LanguageId);
                    string ofString = ResourcesManager.TranslateKey(CaptionsConstants.Desc_Of_String, _requestRepository.LanguageId);
                    string footer = string.Format("{0} [page] {1} [toPage]", pageFooter, ofString);
                    RazorTemplateEngine.Initialize();
                    string htmlPages = string.Empty;
                    for (int k = 0; k < reportModelsList.Count; k++)
                    {
                        htmlContent = RazorTemplateEngine.RenderAsync(path, reportModelsList[k]).Result;
                        htmlPages += htmlContent.ToString();
                    }
                    // htmlContent = RazorTemplateEngine.RenderAsync(path, reportModel).Result;
                    if (_requestRepository.Configurations.PrintHeaderPerPage)
                    {
                        double totalLines = 0;
                        result = _sharedMethod.PrepareCustomHeader(ref htmlContent, ref headerPath);

                        if (reportModel != null && reportModel.TransactionDetails != null && reportModel.TransactionDetails.Count > 0)
                        {
                            var detail = reportModel.TransactionDetails.FirstOrDefault();
                            object value = null;
                            if (((IDictionary<string, object>)detail).ContainsKey("HeaderLines"))
                            {
                                ((IDictionary<string, object>)detail).TryGetValue("HeaderLines", out value);
                            }
                            if (value != null && !string.IsNullOrEmpty(value.ToString()))
                            {
                                totalLines = double.Parse(value.ToString());
                            }
                        }
                        double singleLineMargin = 7;
                        topMargin = (singleLineMargin * (totalLines));
                    }

                    if (result != GlobalErrors.Success) return View();

                    var globalSettings = new GlobalSettings
                    {
                        ColorMode = ColorMode.Color,
                        Orientation = Orientation.Portrait,
                        PaperSize = PaperKind.Letter,
                        Margins = new MarginSettings { Top = topMargin, Left = _requestRepository.Configurations.ReportMargin, Right = 3 },
                        DocumentTitle = reportModel.ReportTitle,
                        DPI = 500
                        //Out = @"D:\PDFCreator\Employee_Report.pdf"  USE THIS PROPERTY TO SAVE PDF TO A PROVIDED LOCATION
                    };

                    var objectSettings = new ObjectSettings
                    {
                        PagesCount = true,
                        HtmlContent = htmlPages,
                        //Page = "https://code-maze.com/", USE THIS PROPERTY TO GENERATE PDF CONTENT FROM AN HTML PAGE
                        WebSettings = { DefaultEncoding = "utf-8", UserStyleSheet = Path.Combine(Directory.GetCurrentDirectory(), "PDFUtility", "ReportsStyle.css") },
                        HeaderSettings = { FontName = "Arial", FontSize = 9, HtmUrl = headerPath },
                        //FooterSettings = { FontName = "Arial", FontSize = 9, Left = DateTime.Now.ToString(), Right = footer, Spacing = 1.8 }
                    };
                    var pdf = new HtmlToPdfDocument()
                    {
                        GlobalSettings = globalSettings,
                        Objects = { objectSettings }
                    };

                    //_converter.Convert(pdf); IF WE USE Out PROPERTY IN THE GlobalSettings CLASS, THIS IS ENOUGH FOR CONVERSION
                    //return File(file, "application/pdf", "EmployeeReport.pdf"); //USE THIS RETURN STATEMENT TO DOWNLOAD GENERATED PDF DOCUMENT
                    return File(_converter.Convert(pdf), "application/pdf");
                    //var merged = PdfDocument.Merge(pdfdoc_a, pdfdoc_b);
                }
                else
                {
                    return View();
                }
            }
            catch (Exception ex)
            {

                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return View();
            }
            finally
            {
                // Delete the temporary report header file
                if (!string.IsNullOrEmpty(headerPath) && System.IO.File.Exists(headerPath))
                {
                    System.IO.File.Delete(headerPath);
                }
            }
        }

        [HttpPost]
        [ActionName("ExportAllOmnitradeReport")]
        public IActionResult ExportAllOmnitradeReport([FromBody] List<TransactionHistory> transactions)
        {
            var result = GlobalErrors.NotInitialized;
            string headerPath = string.Empty;

            try
            {
                
                string printerName = string.Empty;
                double topMargin = 10;
                string reportTitle = string.Empty;
                string htmlPages = string.Empty;
                string path = string.Empty;
                string htmlContent = string.Empty;
                var reportModel = new ReportModel();
                int reportId = -1;
                htmlPages = "<html>\r\n<head>\r\n</head>\r\n<body style=\"height:1225px\">";
                foreach (TransactionHistory transaction in transactions )
                {
                    htmlContent = string.Empty;
                    reportId = transaction.reportMode.GetHashCode();
                    result = _templateGenerator.GetReportModel(reportId, ref reportModel);
                    if (!transaction.IsReprintReport)
                    {
                        if (reportModel.Enabled == 0)
                        {
                            return View();
                        }
                    }

                    result = _templateGenerator.ExportReport(transaction, ref path, ref reportModel, null, false);
                    reportTitle = reportModel.ReportTitle;
                    List<dynamic> allItemsList = new List<dynamic>();
                    allItemsList = reportModel.TransactionDetails;

                    int numberOfItemsPerPage = 13;

                    List<List<dynamic>> pagesList = new List<List<dynamic>>();
                    List<ReportModel> reportModelsList = new List<ReportModel>();

                    for (int i = 0; i < allItemsList.Count; i += numberOfItemsPerPage)
                    {
                        List<dynamic> sublist = allItemsList.Skip(i).Take(numberOfItemsPerPage).ToList();
                        pagesList.Add(sublist);
                    }


                    if (transaction.reportMode == ReportMode.Transaction || transaction.reportMode == ReportMode.Invoiced || transaction.reportMode == ReportMode.Delivered || transaction.reportMode == ReportMode.CreditNote || transaction.reportMode == ReportMode.DebitNote || transaction.reportMode == ReportMode.Return)
                    {
                        var QR_str = _transactionService.GetStringQRCode(transaction.CustomerId, transaction.OutletId, transaction.TransactionId, transaction.reportMode);
                        reportModel.QRCode = GenerateQRCode(QR_str);
                    }
                    decimal grossTotal = 0;
                    decimal tax = 0;
                    decimal netTotal = 0;
                    for (int j = 0; j < pagesList.Count; j++)
                    {
                        var pageModel = new ReportModel();
                        pageModel = reportModel.DeepCopy();
                        pageModel.TransactionDetails = pagesList[j];
                        if (j == (pagesList.Count - 1))
                        {
                            pageModel.ShowTotal = true;
                        }
                        grossTotal += pageModel.TransactionDetails.Sum(i => (decimal)(i.Price * i.Quantity));
                        tax += pageModel.TransactionDetails.Sum(i => (decimal)(i.Tax));
                        netTotal += pageModel.TransactionDetails.Sum(i => (decimal)(i.NetTotal));
                        pageModel.GrossTotal = grossTotal;
                        pageModel.TaxTotal = tax;
                        pageModel.NetTotal = netTotal;
                        pageModel.OrderID = transaction.TransactionId;
                        pageModel.PageString = (j + 1) + " / " + pagesList.Count;
                        reportModelsList.Add(pageModel);
                    }
                    if (result == GlobalErrors.Success)
                    {
                        string pageFooter = ResourcesManager.TranslateKey(CaptionsConstants.Desc_Report_Page_Footer, _requestRepository.LanguageId);
                        string ofString = ResourcesManager.TranslateKey(CaptionsConstants.Desc_Of_String, _requestRepository.LanguageId);
                        string footer = string.Format("{0} [page] {1} [toPage]", pageFooter, ofString);
                        RazorTemplateEngine.Initialize();

                        for (int k = 0; k < reportModelsList.Count; k++)
                        {
                            htmlContent = RazorTemplateEngine.RenderAsync(path, reportModelsList[k]).Result;
                            htmlPages += htmlContent.ToString();
                        }
                       
                    }
                }
                if (result != GlobalErrors.Success) return View();
    
                    var globalSettings = new GlobalSettings
                    {
                        ColorMode = ColorMode.Color,
                        Orientation = Orientation.Portrait,
                        PaperSize = PaperKind.Letter,
                        Margins = new MarginSettings { Top = topMargin, Left = _requestRepository.Configurations.ReportMargin, Right = 3 },
                        DocumentTitle = reportTitle,
                        DPI = 500
                        //Out = @"D:\PDFCreator\Employee_Report.pdf"  USE THIS PROPERTY TO SAVE PDF TO A PROVIDED LOCATION
                    };
              
                    var objectSettings = new ObjectSettings
                    {
                        PagesCount = true,
                        HtmlContent = htmlPages,
                        //Page = "https://code-maze.com/", USE THIS PROPERTY TO GENERATE PDF CONTENT FROM AN HTML PAGE
                        WebSettings = { DefaultEncoding = "utf-8", UserStyleSheet = Path.Combine(Directory.GetCurrentDirectory(), "PDFUtility", "ReportsStyle.css") },
                        HeaderSettings = { FontName = "Arial", FontSize = 9, HtmUrl = headerPath },
                        //FooterSettings = { FontName = "Arial", FontSize = 9, Left = DateTime.Now.ToString(), Right = footer, Spacing = 1.8 }
                    };
                    var pdf = new HtmlToPdfDocument()
                    {
                        GlobalSettings = globalSettings,
                        Objects = { objectSettings }
                    };
                    return File(_converter.Convert(pdf), "application/pdf");
            }
            catch (Exception ex)
            {

                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return View();
            }
            finally
            {
                // Delete the temporary report header file
                if (!string.IsNullOrEmpty(headerPath) && System.IO.File.Exists(headerPath))
                {
                    System.IO.File.Delete(headerPath);
                }
            }
        }
        private string GenerateQRCode(string QR_str)
        {
            try
            {
                if (!string.IsNullOrEmpty(QR_str))
                {
                    QRCodeGenerator qrGenerator = new QRCodeGenerator();
                    QRCodeData qrCodeData;
                    if (_requestRepository.Configurations.UseZatcaQRCode)
                    {
                        string[] arr = QR_str.Split("@@@");
                        string fromStingToASSCI = string.Empty;
                        int tagId = 1;
                        foreach (var val in arr)
                        {
                            fromStingToASSCI += Convert.ToChar(tagId);
                            fromStingToASSCI += Convert.ToChar(val.Length);
                            fromStingToASSCI += val;
                            tagId++;
                        }
                        string base64 = System.Convert.ToBase64String(System.Text.Encoding.UTF8.GetBytes(fromStingToASSCI));
                        qrCodeData = qrGenerator.CreateQrCode(base64, QRCodeGenerator.ECCLevel.Q);
                    }
                    else
                    {
                        qrCodeData = qrGenerator.CreateQrCode(QR_str, QRCodeGenerator.ECCLevel.Q);
                    }
                    QRCode qrCode = new QRCode(qrCodeData);
                    Bitmap qrCodeImage = qrCode.GetGraphic(20);
                    var bytes = BitmapToBytes(qrCodeImage);
                    string QRImg = String.Format("data:image/gif;base64,{0}", Convert.ToBase64String(bytes));
                    return QRImg;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return "";
        }
        private static byte[] BitmapToBytes(Bitmap img)
        {
            try
            {
                using (MemoryStream stream = new MemoryStream())
                {
                    img.Save(stream, System.Drawing.Imaging.ImageFormat.Png);
                    return stream.ToArray();
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return null;
        }
    }
    static class LinqExtensions
    {
        public static IEnumerable<IEnumerable<T>> Split<T>(this IEnumerable<T> list, int parts)
        {
            int i = 0;
            var splits = from item in list
                         group item by i++ % parts into part
                         select part.AsEnumerable();
            return splits;
        }
    }
    public static class ExtensionMethods
    {
        public static T DeepCopy<T>(this T self)
        {
            var serialized = JsonConvert.SerializeObject(self);
            return JsonConvert.DeserializeObject<T>(serialized);
        }
    }
}
