﻿using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Hosting;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Microsoft.AspNetCore.SignalR;
using Newtonsoft.Json;
using Sonic.Web.DAL;
using Sonic.Web.Licensing.Licensing;
using Sonic.Web.Model;
using Sonic.Web.Model.Customer;
using Sonic.Web.PL.SystemModels;
using Sonic.Web.Resources;
using Sonic.Web.Service;
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Data;
using System.IO;
using System.Linq;
using System.Reflection;
using System.Threading.Tasks;

namespace Sonic.Web.PL.Controllers
{
    [Route("api/[controller]/[action]")]
    [Authorize]
    public class PriceController : BaseController
    {

        private readonly IRequestRepository _requestRepository;
        private readonly PricesAndOffersService _pricesAndOffersService;
        private readonly MasterDataService _masterDataService;
        private readonly IHostingEnvironment _hostingEnvironment;
        private readonly IWebHostEnvironment _webHostEnvironment;
        private readonly OrderService _orderService;

        public PriceController(IHubContext<NotifyHub, ITypedHubClient> hubContext, IRequestRepository requestRepository, IWebHostEnvironment webHostEnvironment, ILicensing licensing, IHostingEnvironment hostingEnvironment,IActiveTokens activeTokens) : base(requestRepository, licensing, activeTokens)
        {
            _requestRepository = requestRepository;
            _pricesAndOffersService = new PricesAndOffersService(hubContext,_requestRepository, _hostingEnvironment);
            _masterDataService = new MasterDataService(requestRepository);
            _hostingEnvironment = hostingEnvironment;
            _webHostEnvironment = webHostEnvironment;
            _orderService = new OrderService(requestRepository);
        }

        #region GET
        [HttpPost]
        [ActionName("GetPriceListData")]
        public JsonResult GetPriceListData([FromBody] int priceListId)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                List<PriceListItemsModel> priceListItems = new List<PriceListItemsModel>();
                List<TextLanguage> descriptions = new List<TextLanguage>();

                if (_pricesAndOffersService.CheckIsPriceListPendingExisit(priceListId) && _requestRepository.Configurations.ApplyApprovalCycleInWeb.Contains("4"))
                {
                    result = _pricesAndOffersService.GetPriceListItemsPending(priceListId, ref priceListItems);
                    if (result == GlobalErrors.Success)
                        result = _pricesAndOffersService.GetPriceListDescriptionsPending(priceListId, ref descriptions);
                }
                else
                {
                    result = _pricesAndOffersService.GetPriceListItems(priceListId, ref priceListItems);
                    if (result == GlobalErrors.Success)
                        result = _pricesAndOffersService.GetPriceListDescriptions(priceListId, ref descriptions);
                }
                if (result == GlobalErrors.Success)
                {
                    var data = new
                    {
                        priceListItems = priceListItems,
                        languageDescriptions = descriptions
                    };
                    return JSonResultResponse.GetSuccessrJSon(data, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpPost]
        [ActionName("GetPriceLists")]
        public JsonResult GetPriceLists([FromBody] GeneralFilter filter)
        {
            try
            {
                SharedTableResult<PriceListModel> priceLists = new SharedTableResult<PriceListModel>();
                //GeneralFilter generalFilter = JsonConvert.DeserializeObject<GeneralFilter>(filter);
                GlobalErrors result = _pricesAndOffersService.GetPriceLists(filter, ref priceLists);

                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(priceLists, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        [HttpPost]
        [ActionName("UpdatePendingPriceList")]
        public JsonResult UpdatePendingPriceList([FromBody] PendingPriceListModel priceListObj)//(string priceListObjString)//[FromBody] PriceListModel priceListObj)
        {
            GlobalErrors result = _pricesAndOffersService.UpdatePendingPriceLists(priceListObj);

            if (result == GlobalErrors.Success)
            {
                return JSonResultResponse.GetSuccessrJSon(result, ResourcesManager.TranslateKey(MessagesConstants.Desc_Saved_Successfully, _requestRepository.LanguageId));
            }
            else
            {
                return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Saving, _requestRepository.LanguageId));
            }
        }
        [HttpPost]
        [ActionName("GetSalesOrderStatusTypes")]
        public JsonResult GetSalesOrderStatusTypes([FromBody] List<int> orderStatuses)
        {
            try
            {
                List<OrderModel> salesOrderTypes = new List<OrderModel>();

                GlobalErrors result = _pricesAndOffersService.GetSalesOrderStatusTypes(ref salesOrderTypes, orderStatuses);

                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(salesOrderTypes, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        [HttpPost]
        [ActionName("GetPendingPriceLists")]
        public JsonResult GetPendingPriceLists([FromBody] GeneralFilter filter)
        {
            try
            {
                SharedTableResult<PendingPriceListModel> priceLists = new SharedTableResult<PendingPriceListModel>();
                //GeneralFilter generalFilter = JsonConvert.DeserializeObject<GeneralFilter>(filter);
                GlobalErrors result = _pricesAndOffersService.GetPendingPriceLists(filter, ref priceLists);

                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(priceLists, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }


        [HttpPost]
        [ActionName("InsertCustomersPriceList")]
        public JsonResult InsertCustomersPriceList([FromBody] SimpleCustomerModel priceListObj)//(string priceListObjString)//[FromBody] PriceListModel priceListObj)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;

            string message = string.Empty;
            result = _pricesAndOffersService.SaveCustomerPriceList(priceListObj);

            if (result == GlobalErrors.Success)
            {
                return JSonResultResponse.GetSuccessrJSon(result, ResourcesManager.TranslateKey(MessagesConstants.Desc_Saved_Successfully, _requestRepository.LanguageId));
            }
            else
            {
                return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Saving, _requestRepository.LanguageId));
            }
        }

        [HttpPost]
        [ActionName("GetPriceListHeader")]
        public JsonResult GetPriceListHeader([FromBody] int priceListId)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                PriceListModel priceListModel = new PriceListModel();
                if (_pricesAndOffersService.CheckIsPriceListPendingExisit(priceListId))
                {
                    result = _pricesAndOffersService.GetPriceListHeaderPending(priceListId, ref priceListModel);
                }
                else
                {
                    result = _pricesAndOffersService.GetPriceListHeader(priceListId, ref priceListModel);
                }
                if (result == GlobalErrors.Success)
                {

                    return JSonResultResponse.GetSuccessrJSon(priceListModel, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpPost]
        [ActionName("GetPriceListOriginalData")]
        public JsonResult GetPriceListOriginalData([FromBody] int priceListId)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                List<PriceListItemsModel> priceListItems = new List<PriceListItemsModel>();
                List<TextLanguage> descriptions = new List<TextLanguage>();
                result = _pricesAndOffersService.GetPriceListItems(priceListId, ref priceListItems);
                if (result == GlobalErrors.Success)
                    result = _pricesAndOffersService.GetPriceListDescriptions(priceListId, ref descriptions);
                if (result == GlobalErrors.Success)
                {
                    var data = new
                    {
                        priceListItems = priceListItems,
                        languageDescriptions = descriptions
                    };
                    return JSonResultResponse.GetSuccessrJSon(data, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpPost]
        [ActionName("GetPriceListAppliedLists")]
        public JsonResult GetPriceListAppliedLists([FromBody] int priceListId)
        {
            try
            {
                List<CustomerChannelModel> appliedChannels = new List<CustomerChannelModel>();
                List<CustomerGroupModel> appliedGroups = new List<CustomerGroupModel>();
                List<SimpleCustomerModel> appliedCustomers = new List<SimpleCustomerModel>();
                List<SalesDistributionChannelModel> appliedSDCs = new List<SalesDistributionChannelModel>();

                GlobalErrors result = GlobalErrors.NotInitialized;
                if (_pricesAndOffersService.CheckIsPriceListPendingExisit(priceListId))
                {
                    result = _pricesAndOffersService.GetPriceListAppliedChannelsPending(priceListId, ref appliedChannels);
                    if (result == GlobalErrors.Success)
                        result = _pricesAndOffersService.GetPriceListAppliedGroupsPending(priceListId, ref appliedGroups);
                    if (result == GlobalErrors.Success)
                        result = _pricesAndOffersService.GetPriceListAppliedCustomersPending(priceListId, ref appliedCustomers);
                    if (result == GlobalErrors.Success && _requestRepository.Configurations.EnableSalesDistributionChannel)
                        result = _pricesAndOffersService.GetPriceListAppliedSDCsPending(priceListId, ref appliedSDCs);
                }
                else
                {
                    result = _pricesAndOffersService.GetPriceListAppliedChannels(priceListId, ref appliedChannels);
                    if (result == GlobalErrors.Success)
                        result = _pricesAndOffersService.GetPriceListAppliedGroups(priceListId, ref appliedGroups);
                    if (result == GlobalErrors.Success)
                        result = _pricesAndOffersService.GetPriceListAppliedCustomers(priceListId, ref appliedCustomers);
                    if (result == GlobalErrors.Success && _requestRepository.Configurations.EnableSalesDistributionChannel)
                        result = _pricesAndOffersService.GetPriceListAppliedSDCs(priceListId, ref appliedSDCs);
                }
                if (result == GlobalErrors.Success)
                {
                    var data = new
                    {

                        appliedChannels = appliedChannels,
                        appliedGroups = appliedGroups,
                        appliedCustomers = appliedCustomers,
                        appliedSDCs = appliedSDCs
                    };
                    return JSonResultResponse.GetSuccessrJSon(data, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpPost]
        [ActionName("GetPriceListOriginalAppliedLists")]
        public JsonResult GetPriceListOriginalAppliedLists([FromBody] int priceListId)
        {
            try
            {
                List<CustomerChannelModel> appliedChannels = new List<CustomerChannelModel>();
                List<CustomerGroupModel> appliedGroups = new List<CustomerGroupModel>();
                List<SimpleCustomerModel> appliedCustomers = new List<SimpleCustomerModel>();
                List<SalesDistributionChannelModel> appliedSDCs = new List<SalesDistributionChannelModel>();

                GlobalErrors result = GlobalErrors.NotInitialized;
                if(priceListId>-1)
                result = _pricesAndOffersService.GetPriceListAppliedChannels(priceListId, ref appliedChannels);
                if (result == GlobalErrors.Success)
                    if (priceListId > -1)
                        result = _pricesAndOffersService.GetPriceListAppliedGroups(priceListId, ref appliedGroups);
                if (result == GlobalErrors.Success||priceListId==-1)
                    result = _pricesAndOffersService.GetPriceListAppliedCustomers(priceListId, ref appliedCustomers);
                if (result == GlobalErrors.Success && _requestRepository.Configurations.EnableSalesDistributionChannel)
                    if (priceListId > -1)
                        result = _pricesAndOffersService.GetPriceListAppliedSDCs(priceListId, ref appliedSDCs);

                if (result == GlobalErrors.Success)
                {
                    var data = new
                    {

                        appliedChannels = appliedChannels,
                        appliedGroups = appliedGroups,
                        appliedCustomers = appliedCustomers,
                        appliedSDCs = appliedSDCs
                    };
                    return JSonResultResponse.GetSuccessrJSon(data, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpPost]
        [ActionName("DeleteCustomerAppliedFromPriceList")]
        public JsonResult DeleteCustomerAppliedFromPriceList([FromBody] List<SimpleCustomerModel> appliedCustomers)
        {
            try
            {

                GlobalErrors result = GlobalErrors.NotInitialized;
     

                    result = _pricesAndOffersService.DeleteCustomerApplied(ref appliedCustomers);
            
                if (result == GlobalErrors.Success)
                {
                  
                    return JSonResultResponse.GetSuccessrJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Saved_Successfully, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpPost]
        [ActionName("GetPriceListOriginalHeader")]
        public JsonResult GetPriceListOriginalHeader([FromBody] int priceListId)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                PriceListModel priceList = new PriceListModel();
                result = _pricesAndOffersService.GetPriceListHeader(priceListId, ref priceList);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(priceList, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpGet]
        [ActionName("GetPriceListTypes")]
        public JsonResult GetPriceListTypes()
        {
            try
            {
                List<PriceListTypesModel> priceListTypes = new List<PriceListTypesModel>();

                GlobalErrors result = _pricesAndOffersService.GetPriceListTypes(ref priceListTypes);

                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(priceListTypes, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }



        [HttpPost]
        [ActionName("GetSalesOrderTypes")]
        public JsonResult GetSalesOrderTypes()
        {
            try
            {
                List<DiscountModel> salesOrderTypes = new List<DiscountModel>();

                GlobalErrors result = _pricesAndOffersService.GetSalesOrderTypes(ref salesOrderTypes);

                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(salesOrderTypes, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }


        #endregion

        #region INSERT
        [HttpPost]
        [ActionName("InsertPriceList")]
        public JsonResult InsertPriceList([FromBody] PriceListModel priceListObj)//(string priceListObjString)//[FromBody] PriceListModel priceListObj)
        {
            try
            {
                //  PriceListModel priceListObj = JsonConvert.DeserializeObject<PriceListModel>(priceListObjString);


                string excludedString = string.Empty;
                bool uniqueCode = true;
                if (priceListObj.PriceListId != -1)
                {
                    excludedString = string.Format(" And( (PriceListID != {0}) )", priceListObj.PriceListId);
                }
                GlobalErrors result = GlobalErrors.NotInitialized;
                result = _masterDataService.CheckIfUniqueValue(CoreDataBaseConstants.TableNames.PriceList, CoreDataBaseConstants.QueryColumnsNames.PriceListCode, priceListObj.PriceListCode, excludedString, ref uniqueCode);
                if (uniqueCode)
                {
                    result = _masterDataService.CheckIfUniqueValue(CoreDataBaseConstants.TableNames.PriceList_Pending, CoreDataBaseConstants.QueryColumnsNames.PriceListCode, priceListObj.PriceListCode, excludedString, ref uniqueCode);
                }
                if (!uniqueCode)
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Price_List_Code, _requestRepository.LanguageId) + " " + ResourcesManager.TranslateKey(MessagesConstants.Desc_Msg_Must_Be_Unique, _requestRepository.LanguageId));
                }

                priceListObj.StartDate = new DateTime(priceListObj.StartDateModel.Year, priceListObj.StartDateModel.Month, priceListObj.StartDateModel.Day);
                priceListObj.EndDate = new DateTime(priceListObj.EndDateModel.Year, priceListObj.EndDateModel.Month, priceListObj.EndDateModel.Day);

                result = _pricesAndOffersService.SavePriceList(priceListObj);
                if (result == GlobalErrors.NotInitialized)
                {
                    return JSonResultResponse.GetSuccessrJSon(result, ResourcesManager.TranslateKey(MessagesConstants.Desc_Saved_Successfully, _requestRepository.LanguageId));
                }
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(result, ResourcesManager.TranslateKey(MessagesConstants.Desc_Saved_Successfully, _requestRepository.LanguageId));
                }
                if (result == GlobalErrors.ValueIsMoreThanRequested)
                {
                    return JSonResultResponse.GetSuccessrJSon(result, ResourcesManager.TranslateKey(MessagesConstants.MsgRefreshData, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Saving, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        #endregion

        #region UPDATE
        [HttpPost]
        [ActionName("UpdatePriceList")]
        public JsonResult UpdatePriceList([FromBody] PriceListModel priceListObj)//(string priceListObjString)//[FromBody] PriceListModel priceListObj)
        {
            try
            {
                //  PriceListModel priceListObj = JsonConvert.DeserializeObject<PriceListModel>(priceListObjString);


                string excludedString = string.Empty;
                bool uniqueCode = true;
                if(priceListObj == null)
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Saving, _requestRepository.LanguageId));
                }
                if (priceListObj.PriceListId != -1)
                {
                    excludedString = string.Format(" And( (PriceListID != {0}) )", priceListObj.PriceListId);
                }
                GlobalErrors result = GlobalErrors.NotInitialized;
                result = _masterDataService.CheckIfUniqueValue(CoreDataBaseConstants.TableNames.PriceList, CoreDataBaseConstants.QueryColumnsNames.PriceListCode, priceListObj.PriceListCode, excludedString, ref uniqueCode);
                if (uniqueCode)
                {
                    result = _masterDataService.CheckIfUniqueValue(CoreDataBaseConstants.TableNames.PriceList_Pending, CoreDataBaseConstants.QueryColumnsNames.PriceListCode, priceListObj.PriceListCode, excludedString, ref uniqueCode);
                }
                if (!uniqueCode)
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Price_List_Code, _requestRepository.LanguageId) + " " + ResourcesManager.TranslateKey(MessagesConstants.Desc_Msg_Must_Be_Unique, _requestRepository.LanguageId));
                }

                priceListObj.StartDate = new DateTime(priceListObj.StartDateModel.Year, priceListObj.StartDateModel.Month, priceListObj.StartDateModel.Day);
                priceListObj.EndDate = new DateTime(priceListObj.EndDateModel.Year, priceListObj.EndDateModel.Month, priceListObj.EndDateModel.Day);

                result = _pricesAndOffersService.SavePriceList(priceListObj);
                if (result == GlobalErrors.NotInitialized)
                {
                    return JSonResultResponse.GetSuccessrJSon(result, ResourcesManager.TranslateKey(MessagesConstants.Desc_Saved_Successfully, _requestRepository.LanguageId));
                }
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(result, ResourcesManager.TranslateKey(MessagesConstants.Desc_Saved_Successfully, _requestRepository.LanguageId));
                }
                if (result == GlobalErrors.ValueIsMoreThanRequested)
                {
                    return JSonResultResponse.GetSuccessrJSon(result, ResourcesManager.TranslateKey(MessagesConstants.MsgRefreshData, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Saving, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        #endregion

        #region DELETE
        [HttpPost]
        [ActionName("DeletePriceList")]
        public JsonResult DeletePriceList([FromBody] PriceListModel price)
        {
            try
            {
                GlobalErrors result = _pricesAndOffersService.DeletePriceList(price, null);

                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(result, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Update_Data, _requestRepository.LanguageId));
                }
                else if (result == GlobalErrors.ValueIsMoreThanRequested)
                {
                    return JSonResultResponse.GetSuccessrJSon(result, ResourcesManager.TranslateKey(MessagesConstants.MsgRefreshData, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Saving, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpPost]
        [ActionName("InsertQuantityRange")]
        public JsonResult InsertQuantityRange([FromBody] QuantityRange quantityRange)
        {
            try
            {
                if (!ModelState.IsValid)
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_Happend, _requestRepository.LanguageId));
                }
                int quantityRangeID = -1;
                GlobalErrors result = _pricesAndOffersService.InsertQuantityRange(quantityRange, ref quantityRangeID);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(quantityRangeID, ResourcesManager.TranslateKey(MessagesConstants.Desc_Saved_Successfully, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.MessageErrorHappened, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
    }
}
        #endregion