﻿using System;
using System.Collections.Generic;
using Microsoft.AspNetCore.Mvc;
using System.Linq;
using System.Reflection;
using Microsoft.AspNetCore.Authorization;
using Newtonsoft.Json;
using Sonic.Web.DAL;
using Sonic.Web.Model;
using Sonic.Web.PL.SystemModels;
using Sonic.Web.Resources;
using Sonic.Web.Service;
using Sonic.Web.Licensing.Licensing;
using System.IO;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Hosting;
using System.Threading.Tasks;
using Sonic.Web.Core;
using Microsoft.AspNetCore.SignalR;

namespace Sonic.Web.PL.Controllers
{
   
    [Route("api/[controller]/[action]")]
    [Authorize]
    public class PricesAndOffersController : BaseController
    {
        private readonly MasterDataService _masterDataService;
        private readonly PricesAndOffersService _pricesAndOffersService;
        private readonly IRequestRepository _requestRepository;
        private IHostingEnvironment _hostingEnvironment;
         private readonly CustomerService _customerService;
        public PricesAndOffersController(IHubContext<NotifyHub, ITypedHubClient> hubContext,IHostingEnvironment hostingEnvironment, IRequestRepository requestRepository, ILicensing licensing, IActiveTokens activeToken) : base(requestRepository, licensing, activeToken)
        {
            _requestRepository = requestRepository;
            _masterDataService = new MasterDataService(requestRepository);
            _pricesAndOffersService = new PricesAndOffersService(hubContext,requestRepository, _hostingEnvironment);
            _hostingEnvironment = hostingEnvironment;
            _customerService = new CustomerService(requestRepository);
        }
        #region Price

        [HttpPost]
        [ActionName("GetTaxTypes")]
        public JsonResult GetTaxTypes()
        {
            try
            {
                List<TaxTypesModel> taxTypes = new List<TaxTypesModel>();
                GlobalErrors result = _pricesAndOffersService.GetTaxTypes(ref taxTypes);

                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(taxTypes, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpPost]
        [ActionName("GetCurrentOperationStatus")]
        public JsonResult GetCurrentOperationStatus([FromBody] int OperationId)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                 int status = 0;
                SettingManager settingManager = new SettingManager(_requestRepository);
                result = settingManager.GetCurrentOperationStatus(OperationId, ref status, null);


                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(status, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpPost]
        [ActionName("GetQuantityRangeList")]
        public JsonResult GetQuantityRangeList()
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                var quantityRanges = new List<QuantityRange>();
                result = _pricesAndOffersService.GetQuantityRangeList(ref quantityRanges);

                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(quantityRanges, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }

        


        #endregion


        #region[Promotions]
        
        
        [HttpPost]
        [ActionName("SendNotification")]
        public JsonResult SendNotification([FromBody] Promotion promotion)
        {
            try
            {
                string errorMsg = string.Empty;
                GlobalErrors result = _pricesAndOffersService.SendNotification(promotion,_hostingEnvironment, ref errorMsg);
                if (result != GlobalErrors.Success && promotion.FailedSentToAndroid && promotion.FailedSentToEcho)
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Notification_Sent_Failed, _requestRepository.LanguageId));
                }
                if (string.IsNullOrEmpty(errorMsg))
                {
                    return JSonResultResponse.GetSuccessrJSon(result, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Update_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(errorMsg);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        
        
        [HttpPost]
        [ActionName("IsValidToConfirm")]
        public JsonResult IsValidToConfirm([FromBody] OperationTypeModel OperationTypeModel)
        {
            try
            {
                bool isValid = false;
                GlobalErrors result = _pricesAndOffersService.IsValidToApprove(OperationTypeModel.Status, OperationTypeModel.OperationTypeId, OperationTypeModel.Id, ref isValid );
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(isValid, MessagesConstants.Desc_Success_Getting_Data);
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        [HttpPost]
        [ActionName("IsValidToAffect")]
        public JsonResult IsValidToAffect([FromBody] OperationTypeModel OperationTypeModel)
        {
            try
            {
                bool isValid = false;
                GlobalErrors result = _pricesAndOffersService.IsValidToAffect(OperationTypeModel.Status, OperationTypeModel.OperationTypeId, ref isValid);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(isValid, MessagesConstants.Desc_Success_Getting_Data);
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        [HttpPost]
        [ActionName("IsValidToEditFoc")]
        public JsonResult IsValidToEditFoc([FromBody] ContractedFOCModel contract)
        {
            try
            {
                bool isValid = false;
                string editingMsg = string.Empty;
                var result = _pricesAndOffersService.IsValidToEditFoc(contract, ref isValid, ref editingMsg);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(isValid, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    if (string.IsNullOrEmpty(editingMsg))
                    {
                        return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Saving, _requestRepository.LanguageId));
                    }
                    else
                    {
                        return JSonResultResponse.GetErrorJSon(isValid, editingMsg);
                    }
                }
            }
            catch (Exception)
            {
                return JSonResultResponse.GetErrorJSon();
            }
        }

        [HttpPost]
        [ActionName("ApproveOperation")]
        public JsonResult ApproveOperation([FromBody] OperationTypeModel OperationTypeModel)
        {
            int actualNewLevelId = 0;
            string errorMessage = "";
            try
            {
                GlobalErrors result = GlobalErrors.NotInitialized;
                int newStatus = 0;
                if (OperationTypeModel.OperationTypeId == ApprovalCycleOperations.Price.GetHashCode())
                {
                    int priceStatus = 0;
                    bool isDeleted = false;
                    result = _pricesAndOffersService.GetPriceListStatus(OperationTypeModel.Id, ref priceStatus, ref isDeleted);
                    if (_requestRepository.Configurations.ForcePreviousLevelApproval)
                    {
                        if (OperationTypeModel.Status != priceStatus)
                        {
                            result = GlobalErrors.ValueIsMoreThanRequested;
                            return JSonResultResponse.GetSuccessrJSon(result, ResourcesManager.TranslateKey(MessagesConstants.MsgRefreshData, _requestRepository.LanguageId));
                        }
                    }
                    else
                    {
                        if (priceStatus == -1 || OperationTypeModel.Status < priceStatus && !isDeleted)
                        {
                            result = GlobalErrors.ValueIsMoreThanRequested;
                            return JSonResultResponse.GetSuccessrJSon(result, ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                        }
                    }
                }
                result = _pricesAndOffersService.ApproveOperation(OperationTypeModel.Id, OperationTypeModel.Status, OperationTypeModel.OperationTypeId, ref actualNewLevelId, ref newStatus,null);
                //if (result == GlobalErrors.Success && actualNewLevelId != 0) {
                //     result = _pricesAndOffersService.SendApprovalEmail(OperationTypeId , Id, ref actualNewLevelId, ref errorMessage , _hostingEnvironment);
                //}
                var data = new
                {
                    result = result,
                    newStatus = newStatus
                };
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(data, ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(data, ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        [HttpPost]
        [ActionName("SendOperationEmail")]
        public JsonResult SendOperationEmail([FromBody] OperationTypeModel OperationTypeModel)
        {
            int actualNewLevelId = 0;
            string errorMessage = "";
            int currentStatusId = OperationTypeModel.Status;
            try
            {
                GlobalErrors result = _pricesAndOffersService.SendApprovalEmail(OperationTypeModel.OperationTypeId, OperationTypeModel.Id, ref currentStatusId, OperationTypeModel.OperationCode, OperationTypeModel.IsApprove, ref errorMessage, _hostingEnvironment);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessrJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Success_Getting_Data, _requestRepository.LanguageId));
                }
                if (result == GlobalErrors.NoMoreRows)
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(errorMessage, _requestRepository.LanguageId));

                }
                if (result == GlobalErrors.ValueIsMoreThanRequested)
                {
                    return JSonResultResponse.GetSuccessrJSon(result, ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        
        
        [HttpPost]
        [ActionName("DownloadFile")]
        public async Task<FileStream> DownloadFile(string id, string fileName , int operationType)
        {
            string operationFileName = "";
            try
            {
                if (string.IsNullOrEmpty(fileName))
                {
                    return null;
                }
                switch ((ApprovalCycleOperations) operationType)
                {
                    case ApprovalCycleOperations.Promotions:
                        operationFileName = "promotions";
                        break;
                    case ApprovalCycleOperations.Discounts:
                        operationFileName = "discounts";
                        break;
                    case ApprovalCycleOperations.CreditRelease:
                        operationFileName = "creditReleases";
                        break;
                }
                string folderName = Path.Combine("Resources\\attachements\\",operationFileName, id, fileName);
                string rootPath = _hostingEnvironment.ContentRootPath;
                var path = Path.Combine(rootPath, folderName);


                return new FileStream(path, FileMode.Open, FileAccess.Read);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return null;
            }
        }
        
        

        
        #endregion

    }
}
